/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.service.impl;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.Constant;
import cn.gtmap.gtc.workflow.domain.manage.StatisticsTaskDto;
import cn.gtmap.gtc.workflow.domain.statistics.BaseTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.OrgTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskCountDto;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskStatisticsInfo;
import cn.gtmap.gtc.workflow.domain.statistics.UserTaskStatisticsTimeDto;
import cn.gtmap.gtc.workflow.enums.statistics.DateType;
import cn.gtmap.gtc.workflow.statistics.config.DslManager;
import cn.gtmap.gtc.workflow.statistics.dao.StatisticsTaskDao;
import cn.gtmap.gtc.workflow.statistics.elasticsearch.client.RestClientFactory;
import cn.gtmap.gtc.workflow.statistics.manager.AccountManager;
import cn.gtmap.gtc.workflow.statistics.service.StatisticsTaskService;
import cn.gtmap.gtc.workflow.statistics.service.impl.BaseServiceImpl;
import cn.gtmap.gtc.workflow.statistics.util.JsonResultBuilder;
import cn.gtmap.gtc.workflow.statistics.util.StatisticsDateUtils;
import cn.gtmap.gtc.workflow.utils.GtmapDateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class StatisticsTaskServiceImpl
extends BaseServiceImpl
implements StatisticsTaskService {
    private final Map<String, String> emptyParamsMap = Collections.emptyMap();
    @Value(value="${elasticsearch.statisticsTaskIndexPrefix}")
    private String statisticsTaskIndexPrefix;
    @Autowired
    private StatisticsTaskDao statisticsTaskDao;
    @Autowired
    private DslManager dslManager;
    @Autowired
    private RestClientFactory restClientFactory;
    @Autowired
    private AccountManager accountManager;

    public List<StatisticsTaskDto> selectActiveByUserId(String userId) {
        return this.statisticsTaskDao.selectActiveByUserId(userId);
    }

    public List<OrgTaskStatisticsInfo> getStatisticsOfAllOrgs(Map<String, Object> map) {
        List list;
        String queryJson = this.dslManager.generateDsl("getStatisticsOfAllOrgs", map);
        this.logger.debug("getStatisticsOfAllOrgs:{}", (Object)queryJson);
        NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
        try {
            String response = this.restClientFactory.performRequest("POST", this.statisticsTaskIndexPrefix + "-*" + "/_search", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
            list = JsonResultBuilder.getStatisticsResultOfAllOrgs((String)response);
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6\u6240\u6709\u90e8\u95e8\u7684\u4efb\u52a1\u7edf\u8ba1\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            list = Collections.emptyList();
        }
        return list;
    }

    public List<UserTaskStatisticsInfo> getStatisticsByOrg(Map<String, Object> map) {
        List list;
        String queryJson = this.dslManager.generateDsl("getStatisticsByOrg", map);
        this.logger.debug("getStatisticsByOrg:{}", (Object)queryJson);
        NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
        try {
            String response = this.restClientFactory.performRequest("POST", this.statisticsTaskIndexPrefix + "-*" + "/_search", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
            list = JsonResultBuilder.getStatisticsResultByOrg((String)response);
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6\u5355\u4e2a\u90e8\u95e8\u4e0b\u7684\u4eba\u5458\u7684\u4efb\u52a1\u7edf\u8ba1\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            list = Collections.emptyList();
        }
        return list;
    }

    public List<UserTaskStatisticsTimeDto> getUserStatisticsTime(Map<String, Object> params) {
        String queryJson = this.dslManager.generateDsl("getUserStatisticsTime", params);
        this.logger.debug("getUserStatisticsTime:{}", (Object)queryJson);
        NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
        List list = null;
        try {
            String response = this.restClientFactory.performRequest("POST", this.statisticsTaskIndexPrefix + "-*" + "/_search", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
            list = JsonResultBuilder.getStatisticsTimeResult((String)response);
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6\u8282\u70b9\u529e\u7406\u65f6\u95f4\u7edf\u8ba1", (Throwable)e);
            list = Collections.emptyList();
        }
        return list;
    }

    public List<BaseTaskStatisticsInfo> getStatisticsByUser(Map<String, Object> map) {
        List list;
        String queryJson = this.dslManager.generateDsl("getStatisticsByUser", map);
        NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
        try {
            String json = this.restClientFactory.performRequest("POST", this.statisticsTaskIndexPrefix + "-*" + "/_search", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
            list = JsonResultBuilder.getStatisticsResultByUser((String)json);
        }
        catch (IOException e) {
            this.logger.error("\u83b7\u53d6\u5355\u7528\u6237\u7684\u4efb\u52a1\u7edf\u8ba1\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            list = Collections.emptyList();
        }
        return list;
    }

    public List<UserTaskCountDto> queryUserTaskCount(String username, Integer taskStatus, Long startTime, Long endTime, String dateType) {
        UserDto userDto = this.accountManager.getUserDto(username);
        if (userDto != null) {
            DateType type = DateType.enumValue((String)dateType);
            if (null == type) {
                throw new IllegalArgumentException("\u65f6\u95f4\u7c7b\u578b\u53c2\u6570\u5f02\u5e38");
            }
            HashMap query = Maps.newHashMap();
            if (userDto.getAdmin() != 1) {
                query.put("taskAssId", username);
            }
            query.put("taskStatus", taskStatus);
            query.put("dateType", type.getName());
            query.put("startTime", startTime);
            query.put("endTime", endTime);
            String queryJson = this.dslManager.generateDsl("getUserTaskCount", (Map)query);
            this.logger.error(queryJson);
            NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
            try {
                String json = this.restClientFactory.performRequest("POST", this.statisticsTaskIndexPrefix + "-*" + "/_search", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
                List dtos = JsonResultBuilder.buildUserTaskCount((String)json, (DateType)type);
                return this.supplementTime(startTime, endTime, dtos, type);
            }
            catch (IOException e) {
                this.logger.error("queryUserTaskCount", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<UserTaskCountDto> supplementTime(Long startTime, Long endTime, List<UserTaskCountDto> dtos, DateType dateType) {
        Long start = null;
        if (startTime != null) {
            start = startTime + Constant.B_UTC;
        }
        Long end = null;
        end = endTime == null ? Long.valueOf(System.currentTimeMillis()) : Long.valueOf(endTime + Constant.B_UTC);
        LinkedList res = Lists.newLinkedList();
        if (start != null) {
            String queryStartStr = StatisticsDateUtils.getQueryStr((Long)start, (DateType)dateType);
            String resStartStr = StatisticsDateUtils.getResStartStr((long)end, dtos, (DateType)dateType);
            if ((queryStartStr = this.buildData((List)res, queryStartStr, resStartStr, dateType, false)).compareTo(resStartStr) == 0 && CollectionUtils.isEmpty(dtos)) {
                UserTaskCountDto dto = new UserTaskCountDto();
                dto.setDateStr(queryStartStr).setDate(GtmapDateUtils.strToDate((String)queryStartStr, (String)dateType.getFormat())).setCount(0);
                res.add(dto);
            }
        }
        res.addAll(dtos);
        String resEndStr = StatisticsDateUtils.getResEndStr((List)res, (DateType)dateType);
        if (resEndStr == null && start != null) {
            resEndStr = StatisticsDateUtils.getQueryStr((Long)start, (DateType)dateType);
        }
        if (resEndStr != null) {
            String queryEndStr = StatisticsDateUtils.getQueryStr((Long)end, (DateType)dateType);
            this.buildData((List)res, resEndStr, queryEndStr, dateType, true);
        }
        return res;
    }

    private String buildData(List<UserTaskCountDto> res, String startStr, String endStr, DateType dateType, boolean isEnd) {
        UserTaskCountDto dto;
        while (startStr.compareTo(endStr) < 0) {
            dto = new UserTaskCountDto();
            Date startDate = GtmapDateUtils.strToDate((String)startStr, (String)dateType.getFormat());
            dto.setDateStr(startStr).setDate(startDate).setCount(0);
            res.add(dto);
            startStr = StatisticsDateUtils.getNextStartStr((Date)startDate, (DateType)dateType);
        }
        if (startStr.compareTo(endStr) == 0 && isEnd) {
            dto = new UserTaskCountDto();
            dto.setDateStr(startStr).setDate(GtmapDateUtils.strToDate((String)startStr, (String)dateType.getFormat())).setCount(0);
            res.add(dto);
        }
        return startStr;
    }
}

