/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.service.impl;

import cn.gtmap.gtc.workflow.entity.StatisticsProc;
import cn.gtmap.gtc.workflow.helper.AbstractWorkdayHelper;
import cn.gtmap.gtc.workflow.statistics.manager.StatisticsProcManager;
import cn.gtmap.gtc.workflow.statistics.service.StatisticsProcWorkService;
import cn.gtmap.gtc.workflow.statistics.service.impl.StatisticsBaseServiceImpl;
import cn.gtmap.gtc.workflow.utils.DateUtils;
import cn.gtmap.gtc.workflow.utils.WorkDayUtil;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class StatisticsProcWorkServiceImpl
extends StatisticsBaseServiceImpl
implements StatisticsProcWorkService {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StatisticsProcManager statisticsProcManageService;

    public void addStatisticsProcToEs(StatisticsProc statisticsProc) {
        SimpleDateFormat df = new SimpleDateFormat(this.statisticsProcIndexSuffixFormat);
        String indexName = this.statisticsProcIndexPrefix + "-" + df.format(statisticsProc.getProcStartTime());
        try {
            String json = this.mapper.writeValueAsString((Object)statisticsProc);
            this.documentService.add(indexName, "doc", statisticsProc.getProcInsId(), json);
        }
        catch (Exception e) {
            this.logger.error("\u6d41\u7a0b\u7edf\u8ba1\u4fe1\u606f\u5b58\u50a8\u5230ES\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public void updateStatisticsProcToEs(StatisticsProc statisticsProc) {
        SimpleDateFormat df = new SimpleDateFormat(this.statisticsProcIndexSuffixFormat);
        String indexName = this.statisticsProcIndexPrefix + "-" + df.format(statisticsProc.getProcStartTime());
        try {
            String json = this.mapper.writeValueAsString((Object)statisticsProc);
            this.documentService.update(indexName, "doc", statisticsProc.getProcInsId(), json);
        }
        catch (Exception e) {
            this.logger.error("\u6d41\u7a0b\u7edf\u8ba1\u4fe1\u606f\u5b58\u50a8\u5230ES\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public void statisticsJob(String procInsId, AbstractWorkdayHelper workdayHelper) {
        StatisticsProc statisticsProc = this.statisticsProcManageService.selectByProcInsId(procInsId);
        if (statisticsProc != null) {
            int time;
            this.changeOldData(statisticsProc);
            Calendar reckonTime = DateUtils.toCalendar((Date)statisticsProc.getReckonTime());
            Date newReckonTime = WorkDayUtil.getNextReckonTime((Date)new Date());
            if (newReckonTime.compareTo(statisticsProc.getReckonTime()) <= 0) {
                return;
            }
            Integer timeoutCount = 0;
            WorkDayUtil.ComputeMode type = this.getProcDueType(statisticsProc.getProcDueType());
            if (type == WorkDayUtil.ComputeMode.DAY) {
                timeoutCount = this.getBetweenDays(reckonTime, workdayHelper, newReckonTime);
            } else if (type == WorkDayUtil.ComputeMode.HOUR) {
                try {
                    timeoutCount = this.getBetweenHours(reckonTime, workdayHelper, newReckonTime);
                }
                catch (Exception e) {
                    this.logger.error("{}\uff1a{}\u5728\u6309\u5c0f\u65f6\u8ba1\u7b97\u8d85\u671f\u5c0f\u65f6\u6570\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{"PROC_INS_ID", procInsId, e});
                    return;
                }
            }
            if (statisticsProc.getStatisticsTime() == 0L) {
                time = this.getProTimeBetweenMins(statisticsProc.getProcInsId(), statisticsProc.getProcStartTime(), statisticsProc.getReckonTime(), workdayHelper);
                statisticsProc.setStatisticsTime(Long.valueOf(statisticsProc.getStatisticsTime() + (long)time));
            }
            if (timeoutCount != 0) {
                time = this.getProTimeBetweenMins(statisticsProc.getProcInsId(), statisticsProc.getReckonTime(), new Date(), workdayHelper);
                statisticsProc.setStatisticsTime(Long.valueOf(statisticsProc.getStatisticsTime() + (long)time));
                statisticsProc.setReckonTime(new Date());
                statisticsProc.setProcTimeoutCount(Integer.valueOf(statisticsProc.getProcTimeoutCount() + timeoutCount));
                statisticsProc.setProcTimeoutStatus(Integer.valueOf(this.getTimeoutStatus(statisticsProc.getProcTimeoutCount())));
                this.statisticsProcManageService.updateStatisticsProc(statisticsProc);
                this.updateStatisticsProcToEs(statisticsProc);
            }
        }
    }

    public void initProcStatisticsTime() {
        List statisticsProcList;
        Integer pageNumber = 1;
        Integer pgeSize = 500;
        HashMap<String, List> workDayMap = new HashMap<String, List>();
        pageNumber = 1;
        while (pageNumber < 100000 && CollectionUtils.isNotEmpty((Collection)(statisticsProcList = this.getStatisticsProcsPage(pageNumber, pgeSize)))) {
            for (StatisticsProc proc : statisticsProcList) {
                try {
                    int btime;
                    List workDayList = null;
                    if (!StringUtils.isEmpty((Object)proc.getWorkId())) {
                        workDayList = (List)workDayMap.get(proc.getWorkId());
                    }
                    if (CollectionUtils.isEmpty(workDayList) && CollectionUtils.isNotEmpty((Collection)(workDayList = this.getProcWorkDays(proc, null, null)))) {
                        workDayMap.put(proc.getWorkId(), workDayList);
                    }
                    AbstractWorkdayHelper procWorkdayHelper = this.getAbstractWorkdayHelper(workDayList);
                    int time = this.getProTimeBetweenMins(proc.getProcInsId(), proc.getProcStartTime(), proc.getProcEndTime(), procWorkdayHelper);
                    WorkDayUtil.ComputeMode type = this.getProcDueType(proc.getProcDueType());
                    if (type == WorkDayUtil.ComputeMode.DAY) {
                        if (proc.getProcDueLimit() != null && proc.getProcTimeoutCount() != null) {
                            btime = (proc.getProcDueLimit() + proc.getProcTimeoutCount()) * 480;
                            if (btime != 0 && time > btime) {
                                time = btime;
                            } else if (btime == 0 && proc.getStatisticsTime() != 0L) {
                                time = proc.getStatisticsTime().intValue();
                            }
                        }
                    } else if (type == WorkDayUtil.ComputeMode.HOUR && proc.getProcDueLimit() != null && proc.getProcTimeoutCount() != null) {
                        btime = (proc.getProcDueLimit() + proc.getProcTimeoutCount()) * 60;
                        if (btime != 0 && time > btime) {
                            time = btime;
                        } else if (btime == 0 && proc.getStatisticsTime() != 0L) {
                            time = proc.getStatisticsTime().intValue();
                        }
                    }
                    proc.setStatisticsTime(Long.valueOf(time));
                    this.statisticsProcManageService.updateStatisticsProc(proc);
                    this.updateStatisticsProcToEs(proc);
                    this.delOldStatisticsTaskFromEs(proc);
                }
                catch (Exception e) {
                    this.logger.warn("initProcStatisticsTime", (Throwable)e);
                }
            }
            Integer n = pageNumber;
            pageNumber = pageNumber + 1;
            Integer n2 = pageNumber;
        }
    }

    private void delOldStatisticsTaskFromEs(StatisticsProc statisticsProc) {
        if (statisticsProc != null) {
            SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
            String indexName = this.statisticsProcIndexPrefix + "-" + df.format(statisticsProc.getProcStartTime());
            try {
                this.documentService.delete(indexName, "doc", statisticsProc.getProcInsId());
            }
            catch (Exception e) {
                this.logger.error("\u6d41\u7a0b\u7edf\u8ba1\u4fe1\u606f\u4eceES\u4e2d\u5220\u9664\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private List<StatisticsProc> getStatisticsProcsPage(Integer pageNumber, Integer pgeSize) {
        PageHelper.startPage((int)pageNumber, (int)pgeSize);
        return this.statisticsProcManageService.lisProcStatisticsWithComplete();
    }

    public void changeOldData(StatisticsProc statisticsProc) {
        if (statisticsProc.getReckonTime() == null) {
            statisticsProc.setReckonTime(statisticsProc.getProcStartTime());
            if (statisticsProc.getProcDueLimit() != null) {
                statisticsProc.setProcTimeoutCount(Integer.valueOf(-statisticsProc.getProcDueLimit().intValue()));
            }
        }
    }
}

