/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.service.impl;

import cn.gtmap.gtc.workflow.clients.define.v1.WorkDayClient;
import cn.gtmap.gtc.workflow.domain.define.WorkDay;
import cn.gtmap.gtc.workflow.domain.define.WorkDayRelation;
import cn.gtmap.gtc.workflow.entity.StatisticsProc;
import cn.gtmap.gtc.workflow.entity.StatisticsTask;
import cn.gtmap.gtc.workflow.helper.AbstractWorkdayHelper;
import cn.gtmap.gtc.workflow.helper.SimpleWorkdayHelper;
import cn.gtmap.gtc.workflow.helper.StrictWorkdayHelper;
import cn.gtmap.gtc.workflow.property.WorkdayProperties;
import cn.gtmap.gtc.workflow.statistics.manager.DocumentService;
import cn.gtmap.gtc.workflow.utils.DateUtils;
import cn.gtmap.gtc.workflow.utils.WorkDayUtil;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class StatisticsBaseServiceImpl
implements InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final String TASK_ID = "TASK_ID";
    static final String PROC_INS_ID = "PROC_INS_ID";
    static final String WORKDAY_STRATEGY_STRICT = "strict";
    static final String ERROR_COMPUTE_DUE_DAY = "{}\uff1a{}\u5728\u6309\u5929\u8ba1\u7b97\u5230\u671f\u65f6\u95f4\u65f6\u53d1\u751f\u9519\u8bef";
    static final String ERROR_COMPUTE_DUE_HOUR = "{}\uff1a{}\u5728\u6309\u5c0f\u65f6\u8ba1\u7b97\u5230\u671f\u65f6\u95f4\u65f6\u53d1\u751f\u9519\u8bef";
    static final String ERROR_COMPUTE_TIMEOUT_DAY = "{}\uff1a{}\u5728\u6309\u5929\u8ba1\u7b97\u8d85\u671f\u5929\u6570\u65f6\u53d1\u751f\u9519\u8bef";
    static final String ERROR_COMPUTE_TIMEOUT_HOUR = "{}\uff1a{}\u5728\u6309\u5c0f\u65f6\u8ba1\u7b97\u8d85\u671f\u5c0f\u65f6\u6570\u65f6\u53d1\u751f\u9519\u8bef";
    @Value(value="${elasticsearch.statisticsTaskIndexPrefix}")
    String statisticsTaskIndexPrefix;
    @Value(value="${elasticsearch.statisticsTaskIndexSuffixFormat}")
    String statisticsTaskIndexSuffixFormat;
    @Value(value="${elasticsearch.statisticsProcIndexPrefix}")
    String statisticsProcIndexPrefix;
    @Value(value="${elasticsearch.statisticsProcIndexSuffixFormat}")
    String statisticsProcIndexSuffixFormat;
    @Autowired
    WorkDayClient workDayClient;
    @Autowired
    WorkdayProperties workdayConfig;
    @Autowired
    DocumentService documentService;
    ObjectMapper mapper = new ObjectMapper();

    public void afterPropertiesSet() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DeserializationConfig dc = this.mapper.getDeserializationConfig();
        dc = (DeserializationConfig)dc.with((DateFormat)df);
        this.mapper.setConfig(dc);
        SerializationConfig sc = this.mapper.getSerializationConfig();
        sc = sc.with((DateFormat)df);
        this.mapper.setConfig(sc);
    }

    WorkDayUtil.ComputeMode getProcDueType(String type) {
        return WorkDayUtil.ComputeMode.getByName((String)type);
    }

    WorkDayUtil.ComputeMode getTaskDueType(Integer dueDays, Integer dueHours) {
        if (null != dueDays) {
            return WorkDayUtil.ComputeMode.DAY;
        }
        if (null != dueHours) {
            return WorkDayUtil.ComputeMode.HOUR;
        }
        return WorkDayUtil.ComputeMode.NONE;
    }

    Map<String, Object> getTaskDueInfo(Date dueDate) {
        if (dueDate == null) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
            resultMap.put("type", WorkDayUtil.ComputeMode.NONE);
            return resultMap;
        }
        return WorkDayUtil.getDueDateNum((Date)dueDate);
    }

    Integer getBetweenDays(Calendar calendar, AbstractWorkdayHelper workdayHelper, Date nowDate) {
        if (calendar == null) {
            return null;
        }
        if (nowDate == null) {
            nowDate = new Date();
        }
        if (workdayHelper == null) {
            return (int)Math.ceil(1.0 * (double)(nowDate.getTime() - calendar.getTimeInMillis()) / 8.64E7);
        }
        return workdayHelper.getBetweenDays(calendar, DateUtils.toCalendar((Date)nowDate));
    }

    Integer getBetweenHours(Calendar calendar, AbstractWorkdayHelper workdayHelper, Date nowDate) throws ParseException {
        if (calendar == null) {
            return null;
        }
        if (nowDate == null) {
            nowDate = new Date();
        }
        if (workdayHelper == null) {
            return (int)Math.ceil(1.0 * (double)(nowDate.getTime() - calendar.getTimeInMillis()) / 3600000.0);
        }
        return workdayHelper.getBetweenHours(calendar, DateUtils.toCalendar((Date)nowDate));
    }

    Integer getTimeoutDays(Calendar calendar, AbstractWorkdayHelper workdayHelper, Date nowDate) {
        if (calendar == null) {
            return null;
        }
        if (nowDate == null) {
            nowDate = new Date();
        }
        if (workdayHelper == null) {
            return (int)Math.ceil(1.0 * (double)(nowDate.getTime() - calendar.getTimeInMillis()) / 8.64E7);
        }
        return workdayHelper.getTimeOutDays(calendar, DateUtils.toCalendar((Date)nowDate));
    }

    Integer getStaticsTimeMins(Calendar calendar, AbstractWorkdayHelper workdayHelper, Date nowDate) throws ParseException {
        if (calendar == null) {
            return null;
        }
        if (nowDate == null) {
            nowDate = new Date();
        }
        if (workdayHelper == null) {
            return (int)Math.ceil(1.0 * (double)(nowDate.getTime() - calendar.getTimeInMillis()) / 60000.0);
        }
        int time = workdayHelper.getBetweenMinis(calendar, DateUtils.toCalendar((Date)nowDate));
        if (time < 0) {
            return 0 - time;
        }
        return time;
    }

    int getTimeoutStatus(Integer timeoutCount) {
        return timeoutCount != null && timeoutCount > 0 ? 1 : 0;
    }

    AbstractWorkdayHelper getAbstractWorkdayHelper(List<WorkDay> workDayList) {
        if (CollectionUtils.isNotEmpty(workDayList)) {
            if (WORKDAY_STRATEGY_STRICT.equalsIgnoreCase(this.workdayConfig.getStrategy())) {
                return new StrictWorkdayHelper(workDayList);
            }
            return new SimpleWorkdayHelper(workDayList);
        }
        return null;
    }

    Date getDueTime(Date startTime, Integer count, WorkDayUtil.ComputeMode type, AbstractWorkdayHelper workdayHelper) {
        if (null == count) {
            return null;
        }
        if (count == 0) {
            return startTime;
        }
        Calendar realDueCalendar = null;
        Calendar startCalendar = DateUtils.toCalendar((Date)startTime);
        if (type == WorkDayUtil.ComputeMode.DAY) {
            boolean normal = true;
            if (workdayHelper != null) {
                try {
                    realDueCalendar = workdayHelper.addDateByWorkDay(startCalendar, count.intValue());
                }
                catch (Exception e) {
                    normal = false;
                }
            } else {
                normal = false;
            }
            if (!normal) {
                realDueCalendar = DateUtils.addDays((Calendar)startCalendar, (int)count);
                if (!WORKDAY_STRATEGY_STRICT.equalsIgnoreCase(this.workdayConfig.getStrategy())) {
                    realDueCalendar.set(11, 23);
                    realDueCalendar.set(12, 59);
                    realDueCalendar.set(13, 59);
                }
            }
        } else if (type == WorkDayUtil.ComputeMode.HOUR) {
            boolean normal = true;
            if (workdayHelper != null) {
                try {
                    realDueCalendar = workdayHelper.addHourByWorkDay(startCalendar, count.intValue());
                }
                catch (Exception e) {
                    normal = false;
                }
            } else {
                normal = false;
            }
            if (!normal) {
                realDueCalendar = DateUtils.addHours((Calendar)startCalendar, (int)count);
            }
        }
        if (realDueCalendar != null) {
            return realDueCalendar.getTime();
        }
        return null;
    }

    WorkDayRelation getTaskWorkDayRelation(StatisticsTask statisticsTask, WorkDayRelation processRelation) throws IllegalAccessException {
        if (processRelation != null) {
            if (processRelation.getIsPriority() == 0) {
                return processRelation;
            }
            if (processRelation.getIsPriority() == 1) {
                if (StringUtils.isEmpty((Object)statisticsTask.getTaskAssId())) {
                    throw new IllegalAccessException("\u672a\u53d1\u73b0\u4eba\u5458\u4fe1\u606f taskId:" + statisticsTask.getTaskId());
                }
                WorkDayRelation userWorkDayRelation = this.workDayClient.findWorkDayRelation(statisticsTask.getTaskAssId(), Integer.valueOf(1));
                if (userWorkDayRelation != null) {
                    return userWorkDayRelation;
                }
                return processRelation;
            }
        }
        return null;
    }

    List<WorkDay> getProcWorkDays(StatisticsProc proc, Date startTime, Date endTime) {
        List workDayList = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)proc.getWorkId())) {
            workDayList = this.workDayClient.getWorkDays(proc.getWorkId(), "", "");
        } else {
            WorkDayRelation workDayRelation = this.workDayClient.findWorkDayRelation(proc.getProcInsId(), Integer.valueOf(0));
            if (workDayRelation != null) {
                proc.setWorkId(workDayRelation.getWorkId());
                workDayList = this.workDayClient.getWorkDays(proc.getWorkId(), "", "");
            }
        }
        return workDayList;
    }

    List<WorkDay> getTaskWorkDays(StatisticsTask task, Date startTime, Date endTime) {
        List workDayList;
        block3: {
            WorkDayRelation workDayRelation = this.workDayClient.findWorkDayRelation(task.getProcInsId(), Integer.valueOf(0));
            workDayList = null;
            try {
                WorkDayRelation relation = this.getTaskWorkDayRelation(task, workDayRelation);
                if (null != relation) {
                    workDayList = this.workDayClient.getWorkDays(relation.getWorkId(), "", "");
                    task.setWorkId(relation.getWorkId());
                }
            }
            catch (IllegalAccessException e) {
                if (workDayRelation == null) break block3;
                workDayList = this.workDayClient.getWorkDays(workDayRelation.getWorkId(), "", "");
                task.setWorkId(workDayRelation.getWorkId());
            }
        }
        return workDayList;
    }

    int getProTimeBetweenMins(String procInsId, Date startTime, Date endTime, AbstractWorkdayHelper workdayHelper) {
        Integer mins = 0;
        Calendar reckonTime = DateUtils.toCalendar((Date)startTime);
        try {
            mins = this.getStaticsTimeMins(reckonTime, workdayHelper, endTime);
        }
        catch (Exception e) {
            this.logger.error(ERROR_COMPUTE_TIMEOUT_HOUR, new Object[]{PROC_INS_ID, procInsId, e});
            throw new IllegalStateException("\u8ba1\u7b97\u6d41\u7a0b\u8d85\u671f\u65f6\u95f4\u65f6\u5b58\u5728\u5f02\u5e38");
        }
        return mins;
    }

    int getTaskTimeBetweenMins(String taskId, Date startTime, Date endTime, AbstractWorkdayHelper workdayHelper) {
        Integer mins = 0;
        Calendar reckonTime = DateUtils.toCalendar((Date)startTime);
        try {
            mins = this.getStaticsTimeMins(reckonTime, workdayHelper, endTime);
        }
        catch (Exception e) {
            this.logger.error(ERROR_COMPUTE_TIMEOUT_HOUR, new Object[]{TASK_ID, taskId, e});
            throw new IllegalStateException("\u8ba1\u7b97\u6d41\u7a0b\u8d85\u671f\u65f6\u95f4\u65f6\u5b58\u5728\u5f02\u5e38");
        }
        return mins;
    }
}

