/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.service.impl;

import cn.gtmap.gtc.feign.common.util.ObjectMapperUtils;
import cn.gtmap.gtc.msg.domain.dto.ProduceMsgDto;
import cn.gtmap.gtc.msg.domain.enums.ConsumerType;
import cn.gtmap.gtc.msg.domain.enums.NotifyType;
import cn.gtmap.gtc.msg.domain.enums.OperationType;
import cn.gtmap.gtc.msg.domain.enums.ProducerType;
import cn.gtmap.gtc.msg.rabbitmq.produce.MessageProducer;
import cn.gtmap.gtc.workflow.entity.StatisticsTask;
import cn.gtmap.gtc.workflow.enums.rabbitmq.WorkflowMsgType;
import cn.gtmap.gtc.workflow.property.MessageProperties;
import cn.gtmap.gtc.workflow.statistics.service.MessageService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger logger = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private MessageProperties messageProperties;
    @Autowired
    private MessageProducer messageProducer;
    @Value(value="${security.oauth2.client.client-id}")
    private String clientId;

    public void sendTaskTimeOutMsg(StatisticsTask task) {
        if (this.messageProperties.isTimeOut()) {
            try {
                ProduceMsgDto msg = new ProduceMsgDto();
                msg.setClientId(this.clientId).setMsgCode("task:".concat(task.getTaskId())).setRead(0).setMsgType(WorkflowMsgType.TASK_TIME_OUT.getValue()).setMsgTypeName(WorkflowMsgType.TASK_TIME_OUT.getRemark()).setProducer(this.clientId).setProducerType(ProducerType.SYSTEM.getName()).setNotifyType(NotifyType.RABBITMQ.getName()).setOptions(OperationType.SAVE.getName()).setConsumer(task.getTaskAssId()).setConsumerType(ConsumerType.PERSONAL.getName());
                msg.setMsgTitle(task.getTaskName());
                HashMap contentMap = Maps.newHashMap();
                contentMap.put("processDefKey", task.getProcDefKey());
                contentMap.put("taskId", task.getTaskId());
                contentMap.put("taskName", task.getTaskName());
                contentMap.put("processInsId", task.getProcInsId());
                msg.setMsgContent(ObjectMapperUtils.toJson((Object)contentMap));
                this.messageProducer.send(msg);
            }
            catch (Exception e) {
                logger.error("sendTaskTimeOutMsg", (Throwable)e);
            }
        }
    }
}

