/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.manager.impl;

import cn.gtmap.gtc.workflow.statistics.dao.TokenDataRepo;
import cn.gtmap.gtc.workflow.statistics.manager.TokenManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class TokenMangerImpl
implements TokenManager {
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${app.security.moduleAuthPath}")
    private String authUrl;
    @Value(value="${security.oauth2.client.client-id}")
    private String clientId;
    @Value(value="${security.oauth2.client.client-secret}")
    private String clientSecret;

    public String getAccessToken() {
        if (this.isExpire()) {
            return this.getNewAccessToken();
        }
        return TokenDataRepo.getInstance().getToken();
    }

    private boolean isExpire() {
        int time = TokenDataRepo.getInstance().getTime();
        int now = (int)(System.currentTimeMillis() / 1000L);
        return now > time - 20;
    }

    private String getNewAccessToken() {
        String authPath = "";
        if (!StringUtils.isEmpty((Object)this.authUrl)) {
            Map map;
            authPath = this.authUrl.lastIndexOf(47) != this.authUrl.length() - 1 ? this.authUrl.concat("/") : this.authUrl;
            StringBuilder builder = new StringBuilder(authPath);
            builder.append("oauth/token?grant_type=client_credentials&client_id=").append(this.clientId).append("&client_secret=").append(this.clientSecret);
            ResponseEntity o = this.restTemplate.postForEntity(builder.toString(), null, Map.class, new Object[0]);
            if (o.getStatusCode() == HttpStatus.OK && (map = (Map)o.getBody()) != null && null != map.get("access_token")) {
                String accessToken = (String)map.get("access_token");
                int expires = (Integer)map.get("expires_in");
                if (expires > 200) {
                    expires = 200;
                }
                int time = (int)(System.currentTimeMillis() / 1000L) + expires;
                TokenDataRepo.getInstance().setTime(time);
                TokenDataRepo.getInstance().setToken(accessToken);
                return accessToken;
            }
        }
        return null;
    }
}

