/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.manager.impl;

import cn.gtmap.gtc.workflow.entity.StatisticsProc;
import cn.gtmap.gtc.workflow.enums.manage.ProcStatus;
import cn.gtmap.gtc.workflow.statistics.dao.StatisticsProcDao;
import cn.gtmap.gtc.workflow.statistics.manager.StatisticsProcManager;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class StatisticsProcManagerImpl
implements StatisticsProcManager {
    @Autowired
    private StatisticsProcDao statisticsProcDao;

    public void addStatisticsProc(StatisticsProc statisticsProc) {
        statisticsProc.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        this.statisticsProcDao.insertSelective((Object)statisticsProc);
    }

    public void updateStatisticsProc(StatisticsProc statisticsProc) {
        this.statisticsProcDao.updateByPrimaryKeySelective((Object)statisticsProc);
    }

    public void delStatisticsProcById(String id) {
        StatisticsProc statisticsProc = this.selectById(id);
        if (statisticsProc != null) {
            this.statisticsProcDao.deleteByPrimaryKey((Object)id);
        }
    }

    public StatisticsProc selectById(String id) {
        return (StatisticsProc)this.statisticsProcDao.selectByPrimaryKey((Object)id);
    }

    public StatisticsProc selectByProcInsId(String procInsId) {
        Example example = new Example(StatisticsProc.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("procInsId", (Object)procInsId);
        return (StatisticsProc)this.statisticsProcDao.selectOneByExample((Object)example);
    }

    public List<StatisticsProc> listRunProcStatistics() {
        Example example = new Example(StatisticsProc.class);
        example.setOrderByClause("proc_start_time ASC");
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("procStatus", (Object)ProcStatus.RUNNING.getValue());
        return this.statisticsProcDao.selectByExample((Object)example);
    }

    public List<StatisticsProc> lisProcStatisticsWithCompleteAndNoneStatisticTime() {
        Example example = new Example(StatisticsProc.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("procStatus", (Object)ProcStatus.END.getValue());
        Example.Criteria c2 = example.createCriteria();
        c2.andIsNull("statisticsTime").orEqualTo("statisticsTime", (Object)0);
        example.and(c2);
        return this.statisticsProcDao.selectByExample((Object)example);
    }

    public List<StatisticsProc> lisProcStatisticsWithComplete() {
        Example example = new Example(StatisticsProc.class);
        Example.Criteria c = example.createCriteria();
        c.andEqualTo("procStatus", (Object)ProcStatus.END.getValue());
        return this.statisticsProcDao.selectByExample((Object)example);
    }
}

