/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.manager.impl;

import cn.gtmap.gtc.workflow.bean.ResultBean;
import cn.gtmap.gtc.workflow.statistics.elasticsearch.client.RestClientFactory;
import cn.gtmap.gtc.workflow.statistics.manager.DocumentService;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements DocumentService,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper mapper = new ObjectMapper();
    private final Map<String, String> emptyParamsMap = Collections.emptyMap();
    @Autowired
    private RestClientFactory restClientFactory;
    private static final String ERROR_ADD_DOC = "\u65b0\u589eDocument\u65f6\u53d1\u751f\u9519\u8bef";
    private static final String ERROR_UPDATE_DOC = "\u66f4\u65b0Document\u65f6\u53d1\u751f\u9519\u8bef";
    private static final String ERROR_PATCH_DOC = "\u5c40\u90e8\u66f4\u65b0Document\u65f6\u53d1\u751f\u9519\u8bef";
    private static final String ERROR_DELETE_DOC = "\u5220\u9664Document\u65f6\u53d1\u751f\u9519\u8bef";

    public void afterPropertiesSet() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DeserializationConfig dc = this.mapper.getDeserializationConfig();
        dc = (DeserializationConfig)dc.with((DateFormat)df);
        this.mapper.setConfig(dc);
        SerializationConfig sc = this.mapper.getSerializationConfig();
        sc = sc.with((DateFormat)df);
        this.mapper.setConfig(sc);
    }

    public ResultBean add(String index, String type, String id, String json) {
        ResultBean resultBean = new ResultBean();
        NStringEntity entity = new NStringEntity(json, ContentType.APPLICATION_JSON);
        try {
            this.restClientFactory.performRequest("PUT", "/" + index + "/" + type + "/" + id + "?refresh", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
        }
        catch (IOException e) {
            this.logger.error(ERROR_ADD_DOC, (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage(ERROR_ADD_DOC);
        }
        return resultBean;
    }

    public ResultBean update(String index, String type, String id, String json) {
        ResultBean resultBean = new ResultBean();
        NStringEntity entity = new NStringEntity(json, ContentType.APPLICATION_JSON);
        try {
            this.restClientFactory.performRequest("PUT", "/" + index + "/" + type + "/" + id + "?refresh", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
        }
        catch (IOException e) {
            this.logger.error(ERROR_UPDATE_DOC, (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage(ERROR_UPDATE_DOC);
        }
        return resultBean;
    }

    public ResultBean updatePartial(String index, String type, String id, String json) {
        ResultBean resultBean = new ResultBean();
        NStringEntity entity = new NStringEntity("{\"doc\" :" + json + "}", ContentType.APPLICATION_JSON);
        try {
            this.restClientFactory.performRequest("POST", "/" + index + "/" + type + "/" + id + "/_update" + "?refresh", this.emptyParamsMap, (HttpEntity)entity, new Header[0]);
        }
        catch (IOException e) {
            this.logger.error(ERROR_PATCH_DOC, (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage(ERROR_PATCH_DOC);
        }
        return resultBean;
    }

    public ResultBean delete(String index, String type, String id) {
        ResultBean resultBean = new ResultBean();
        try {
            this.restClientFactory.performRequest("DELETE", "/" + index + "/" + type + "/" + id + "?refresh", this.emptyParamsMap, null, new Header[0]);
        }
        catch (ResponseException re) {
            String responseEntity = null;
            try {
                responseEntity = EntityUtils.toString((HttpEntity)re.getResponse().getEntity());
                JsonNode rootNode = (JsonNode)this.mapper.readValue(responseEntity, JsonNode.class);
                if (rootNode.has("found") && !rootNode.get("found").booleanValue()) {
                    resultBean.setSuccess(true);
                }
                this.logger.error(ERROR_DELETE_DOC, (Throwable)re);
                resultBean.setSuccess(false);
                resultBean.setMessage(ERROR_DELETE_DOC);
            }
            catch (IOException e) {
                this.logger.error(ERROR_DELETE_DOC, (Throwable)e);
                resultBean.setSuccess(false);
                resultBean.setMessage(ERROR_DELETE_DOC);
            }
        }
        catch (IOException e) {
            this.logger.error(ERROR_DELETE_DOC, (Throwable)e);
            resultBean.setSuccess(false);
            resultBean.setMessage(ERROR_DELETE_DOC);
        }
        return resultBean;
    }

    public String queryById(String index, String type, String id) {
        String json = "";
        try {
            json = this.restClientFactory.performRequest("GET", "/" + index + "/" + type + "/" + id, this.emptyParamsMap, null, new Header[0]);
        }
        catch (IOException e) {
            this.logger.error("\u6839\u636eid\u67e5\u8be2Document\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return json;
    }
}

