/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.manager.impl;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.workflow.statistics.manager.AccountManager;
import cn.gtmap.gtc.workflow.statistics.manager.TokenManager;
import cn.gtmap.gtc.workflow.statistics.util.JsonResultBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class AccountManagerImpl
implements AccountManager {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TokenManager tokenManager;
    @Value(value="${app.security.moduleAuthPath}")
    private String authUrl;

    private String getAccountUrl() {
        String authPath = "";
        if (this.authUrl != null) {
            authPath = this.authUrl.lastIndexOf(47) != this.authUrl.length() - 1 ? this.authUrl + '/' : this.authUrl;
        }
        return authPath;
    }

    public UserDto getUserDto(String username) {
        String requestUrl;
        UserDto dto;
        String accessToken = this.tokenManager.getAccessToken();
        if (!StringUtils.isEmpty((Object)accessToken) && null != (dto = (UserDto)this.restTemplate.getForObject(requestUrl = this.getAccountUrl().concat("rest/v1/users/").concat(username).concat("?access_token=").concat(accessToken), UserDto.class, new Object[0]))) {
            return dto;
        }
        UserDto def = new UserDto();
        def.setId(username);
        def.setAlias(username);
        def.setUsername(username);
        return def;
    }

    public List<OrganizationDto> findOrgByIds(List<String> ids) {
        String requestUrl;
        ResponseEntity res;
        String accessToken = this.tokenManager.getAccessToken();
        ArrayList dtos = Lists.newArrayList();
        if (!StringUtils.isEmpty((Object)accessToken) && HttpStatus.OK.equals((Object)(res = this.restTemplate.postForEntity(requestUrl = this.getAccountUrl().concat("rest/v1/orgs/ids").concat("?access_token=").concat(accessToken), ids, List.class, new Object[0])).getStatusCode()) && !CollectionUtils.isEmpty((Collection)((Collection)res.getBody()))) {
            for (Object o : (List)res.getBody()) {
                OrganizationDto dto = (OrganizationDto)JsonResultBuilder.convertValue(o, OrganizationDto.class);
                dtos.add(dto);
            }
        }
        return dtos;
    }

    public List<UserDto> listUserByUserNames(List<String> usernames) {
        if (!CollectionUtils.isEmpty(usernames)) {
            String requestUrl;
            ResponseEntity res;
            String accessToken = this.tokenManager.getAccessToken();
            ArrayList dtos = Lists.newArrayList();
            if (!StringUtils.isEmpty((Object)accessToken) && HttpStatus.OK.equals((Object)(res = this.restTemplate.postForEntity(requestUrl = this.getAccountUrl().concat("rest/v1/users/username-list").concat("?access_token=").concat(accessToken), usernames, List.class, new Object[0])).getStatusCode()) && !CollectionUtils.isEmpty((Collection)((Collection)res.getBody()))) {
                for (Object o : (List)res.getBody()) {
                    UserDto dto = (UserDto)JsonResultBuilder.convertValue(o, UserDto.class);
                    dtos.add(dto);
                }
            }
            return dtos;
        }
        return Collections.emptyList();
    }
}

