/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.config;

import cn.gtmap.gtc.workflow.statistics.config.ElasticsearchProperties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ElasticsearchConfig {
    @Autowired
    private ElasticsearchProperties elasticsearchProperties;

    @Bean(name={"elasticsearchClient"})
    public RestClient elasticsearchClient() {
        HttpHost[] httpHosts = this.buildHosts(this.elasticsearchProperties.getHosts());
        String user = this.elasticsearchProperties.getUser();
        String password = this.elasticsearchProperties.getPassword();
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        if (StringUtils.isNotEmpty((String)user)) {
            String auth = String.format("%s:%s", user, password);
            String encoded = Base64.encodeBase64String((byte[])auth.getBytes());
            Header[] defaultHeaders = new Header[]{new BasicHeader("Authorization", "Basic " + encoded)};
            restClientBuilder.setDefaultHeaders(defaultHeaders);
        }
        return restClientBuilder.build();
    }

    private HttpHost[] buildHosts(String hosts) {
        hosts = hosts.replace("\uff0c", ",");
        String[] hs = hosts.split(",");
        HttpHost[] httpHosts = new HttpHost[hs.length];
        for (int i = 0; i < httpHosts.length; ++i) {
            String[] arr = hs[i].split(":");
            if (arr.length == 1) {
                httpHosts[i] = new HttpHost(arr[0].trim(), 9200, "http");
                continue;
            }
            if (arr.length != 2) continue;
            httpHosts[i] = new HttpHost(arr[0], Integer.parseInt(arr[1].trim()), "http");
        }
        return httpHosts;
    }
}

