/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.workflow.statistics.config;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
public class DslManager {
    private String templateLoaderPath;
    private freemarker.template.Configuration freemarkerConfig;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DslManager(@Value(value="${elasticsearch.templateLoaderPath}") String templateLoaderPath) throws IOException {
        this.templateLoaderPath = templateLoaderPath;
        this.loadTemplates();
    }

    private void loadTemplates() throws IOException {
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        this.freemarkerConfig = new freemarker.template.Configuration(freemarker.template.Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.freemarkerConfig.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        this.freemarkerConfig.setDefaultEncoding("utf-8");
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource[] mappers = resourceResolver.getResources(this.templateLoaderPath);
        resources.addAll(Arrays.asList(mappers));
        this.loadTemplateFile(resources);
    }

    private void loadTemplateFile(List<Resource> resources) throws IOException {
        for (Resource resource : resources) {
            try {
                InputStream inputStream = resource.getInputStream();
                Throwable throwable = null;
                try {
                    this.loadTemplateFile(inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.logger.error("\u89e3\u6790DSL\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    private void loadTemplateFile(InputStream inputStream) throws IOException, DocumentException {
        Document doc = DocumentHelper.parseText((String)IOUtils.toString((InputStream)inputStream, (Charset)Charsets.toCharset((String)"utf-8")));
        List es = doc.selectNodes("dsls/dsl");
        for (Element e : es) {
            ((StringTemplateLoader)this.freemarkerConfig.getTemplateLoader()).putTemplate(e.attributeValue("id"), e.getTextTrim());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String generateDsl(String id, Map<String, Object> map) {
        try (StringWriter sw = new StringWriter();){
            this.freemarkerConfig.getTemplate(id).process(map, (Writer)sw);
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6ID\u4e3a{}\u7684DSL\u8bed\u53e5\u65f6\u53d1\u751f\u9519\u8bef", (Object)id, (Object)e);
            return "";
        }
    }
}

