/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.bc.util;

import cn.gtmap.gtc.bc.domain.enums.RichQueryCondition;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SelectorBuilder.class);
    Selector selector = new Selector();
    ObjectMapper objectMapper = new ObjectMapper();

    public String toString() {
        try {
            return this.objectMapper.writeValueAsString((Object)this.selector);
        }
        catch (JsonProcessingException e) {
            logger.error("toString", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public SelectorBuilder equal(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RichQueryCondition.EQ.value(), value);
        this.selector.addSelector(key, map);
        return this;
    }

    public SelectorBuilder like(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RichQueryCondition.REGEX.value(), value);
        this.selector.addSelector(key, map);
        return this;
    }

    public SelectorBuilder in(String key, Collection<Object> values) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RichQueryCondition.IN.value(), values);
        this.selector.addSelector(key, map);
        return this;
    }

    public SelectorBuilder gte(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RichQueryCondition.GTE.value(), value);
        this.selector.addSelector(key, map);
        return this;
    }

    public SelectorBuilder lte(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(RichQueryCondition.LTE.value(), value);
        this.selector.addSelector(key, map);
        return this;
    }

    class Selector {
        private Map<String, Map<String, Object>> selector = new HashMap<String, Map<String, Object>>();

        Selector() {
        }

        public Map<String, Map<String, Object>> getSelector() {
            return this.selector;
        }

        public void setSelector(Map<String, Map<String, Object>> selector) {
            this.selector = selector;
        }

        public void addSelector(String key, Map<String, Object> condition) {
            this.selector.put(key, condition);
        }
    }
}

