package cn.gtmap.gtc.bc.util;

import cn.gtmap.gtc.bc.domain.enums.RichQueryCondition;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-3-12
 * @description
 */
public class SelectorBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SelectorBuilder.class);

    class Selector {
        private Map<String, Map<String, Object>> selector = new HashMap<>();

        public Map<String, Map<String, Object>> getSelector() {
            return selector;
        }

        public void setSelector(Map<String, Map<String, Object>> selector) {
            this.selector = selector;
        }

        public void addSelector(String key, Map<String, Object> condition){
            selector.put(key, condition);
        }
    }
    Selector selector = new Selector();
    ObjectMapper objectMapper = new ObjectMapper();

    public String toString(){
        try {
            return objectMapper.writeValueAsString(selector);
        } catch (JsonProcessingException e) {
             logger.error("toString",e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public SelectorBuilder equal(String key, Object value){
        Map<String, Object> map = new HashMap<>();
        map.put(RichQueryCondition.EQ.value(), value);
        selector.addSelector(key, map);
        return this;
    }

    public SelectorBuilder like(String key, Object value){
        Map<String, Object> map = new HashMap<>();
        map.put(RichQueryCondition.REGEX.value(), value);
        selector.addSelector(key, map);
        return this;
    }

    public SelectorBuilder in(String key, Collection<Object> values){
        Map<String, Object> map = new HashMap<>();
        map.put(RichQueryCondition.IN.value(), values);
        selector.addSelector(key, map);
        return this;
    }


    public SelectorBuilder gte(String key, Object value){
        Map<String, Object> map = new HashMap<>();
        map.put(RichQueryCondition.GTE.value(), value);
        selector.addSelector(key, map);
        return this;
    }


    public SelectorBuilder lte(String key, Object value){
        Map<String, Object> map = new HashMap<>();
        map.put(RichQueryCondition.LTE.value(), value);
        selector.addSelector(key, map);
        return this;
    }

}
