package cn.gtmap.gtc.bc.domain.enums;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-3-12
 * @description
 */
public enum RichQueryCondition {
    AND("$and", "数组参数"),
    OR("$or", "数组参数"),
    NOT("$not", "单一参数"),
    NOR("$nor", "数组参数"),
    ALL("$all", "数组参数（数组值的特殊运算符）"),
    ELEM_MATCH("$elemMatch", "单一参数（数组值的特殊运算符"),
    LT("$lt", "任意 JSON"),
    LTE("$lte", "任意 JSON"),
    EQ("$eq", "任意 JSON"),
    NE("$ne", "任意 JSON"),
    GTE("$gte", "任意 JSON"),
    GT("$gt", "任意 JSON"),
    EXISTS("$exists", "布尔值，检查字段是否存在，无论其值如何"),
    IN("$in","JSON值数组，文档字段必须存在于提供的列表中"),
    NIN("$nin","JSON值数组，文档字段不得存在于提供的列表中"),
    REGEX("$regex","字符串，与文档字段匹配的正则表达式模式。仅当字段为字符串值并与提供的匹配项匹配时才匹配");

    private String value;
    private String remark;

    RichQueryCondition(String value, String remark) {
        this.value = value;
        this.remark = remark;
    }

    public String value() {
        return value;
    }

    public String remark() {
        return remark;
    }
}
