package cn.gtmap.gtc.bc.domain.enums;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-3-16
 * @description
 */
public enum ChainCodeDeployStatus {
    ENCODE("encode", "编码"),
    UPLOAD("upload", "已上传"),
    PACKAGED("packaged", "已经打包"),
    INSTALLED("installed", "已安装"),
    UPDATED("updated", "已更新");


    private String value;
    private String remark;

    ChainCodeDeployStatus(String value, String remark) {
        this.value = value;
        this.remark = remark;
    }

    public String value() {
        return value;
    }

    public String remark() {
        return remark;
    }

    public static ChainCodeDeployStatus enumValue(String value){
        for (ChainCodeDeployStatus status : ChainCodeDeployStatus.values()){
            if (status.value.equals(value)){
                return status;
            }
        }
        return null;
    }
}
