package cn.gtmap.gtc.bc.domain.dto;

import java.io.Serializable;
import java.util.List;

/**
 * @version 1.0 2020-2-25
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
public class ChainOptionDTO implements Serializable {

    private String channelId;

    private String chainCodeId;

    private String chainCodeVersion;

    private String funcName;

    private List<String> args;

    // fabric连接信息
    private ChainConnectDTO chainConnectDTO;

    // 调用的链码中发起的跨链码调用， 区块链参数
    private List<ChaincodeCallDTO> invokeChain;

    public String getChannelId() {
        return channelId;
    }

    public ChainOptionDTO setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    public String getChainCodeId() {
        return chainCodeId;
    }

    public ChainOptionDTO setChainCodeId(String chainCodeId) {
        this.chainCodeId = chainCodeId;
        return this;
    }

    public String getChainCodeVersion() {
        return chainCodeVersion;
    }

    public ChainOptionDTO setChainCodeVersion(String chainCodeVersion) {
        this.chainCodeVersion = chainCodeVersion;
        return this;
    }

    public String getFuncName() {
        return funcName;
    }

    public ChainOptionDTO setFuncName(String funcName) {
        this.funcName = funcName;
        return this;
    }

    public List<String> getArgs() {
        return args;
    }

    public ChainOptionDTO setArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public ChainConnectDTO getChainConnectDTO() {
        return chainConnectDTO;
    }

    public ChainOptionDTO setChainConnectDTO(ChainConnectDTO chainConnectDTO) {
        this.chainConnectDTO = chainConnectDTO;
        return this;
    }

    public List<ChaincodeCallDTO> getInvokeChain() {
        return invokeChain;
    }

    public ChainOptionDTO setInvokeChain(List<ChaincodeCallDTO> invokeChain) {
        this.invokeChain = invokeChain;
        return this;
    }

    @Override
    public String toString() {
        return "HFRequestBody{" +
            "channelId='" + channelId + '\'' +
            ", chainCodeId='" + chainCodeId + '\'' +
            ", funcName='" + funcName + '\'' +
            ", args=" + args +
            '}';
    }
}
