package cn.gtmap.gtc.bc.clients.v1;

import cn.gtmap.gtc.bc.domain.dto.ChainOptionDTO;
import cn.gtmap.gtc.bc.domain.dto.ChainResultDTO;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-2-25
 * @description
 */
@FeignClient(name = "blockchain-app")
@RequestMapping("/rest/v1/chain")
public interface ChainClient {

    @PostMapping("/invoke")
    ChainResultDTO invokeChainCode(@RequestBody ChainOptionDTO chainOptionDTO) ;

    @PostMapping("/query")
    ChainResultDTO queryByChainCode(@RequestBody ChainOptionDTO chainOptionDTO) ;
}
