
layui.config({
    base: blockchainPath + '/custom/js/'
});

layui.use(['jquery','table','custom_tree', 'layer'], function(){

    var custom_tree = layui.custom_tree;
    var table = layui.table;
    var form = layui.form;
    var $ = layui.$

    var tableHeight= initHeight("init");
    // window.onresize=initHeight;
    function initHeight (flag){
        var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+$('.crumbs-path').height()+22+30+20+10;
        var bodyHeight=client().height-$(".gt-toolbar").height()-32;
        $(".gtmap-body").height(bodyHeight);
        if(flag=="init"){
            return vheight;
        }else{
            table.reload('blockchain_manager', {
                height: "full-"+vheight
            });
        }
    }

    table.on('checkbox(user)', function(obj){
        console.log(obj)
    });

    //testAjs();
    //初始化表格
    table.render({
        elem: '#LAY_table_user'
        ,url: blockchainPath + '/rest/ui/manage/chaincode'
        ,height: 'full-'+tableHeight
        ,cols: [[
            {field:'name', title: '名称'}
            ,{field:'version', title: '版本'}
            ,{field:'path',title: '发布路径'}
            ,{fixed: 'right', title: '操作', align:'center', width:200, toolbar: '#barDemo'}
        ]]
        ,id: 'blockchain_manager'
        ,page: false
    });

    //监听工具条
    table.on('tool(user)', function(obj){
        var data = obj.data;
        if(obj.event==='config'){
            configMiddle(data.path,data.name);
        }else if(obj.event==='showData'){
            window.location.href= blockchainPath+ '/data/manager?channelName=' + data.name + '&chainCodeName=' + data.name + '&chainCodeVersion=' + data.version;
        }
    });

    $('div [data-type="reloadTable"]').bind("click",function () {
        active.reloadTable();
    });

    var $ = layui.$, active = {
        reloadTable: function(){
            var path = blockchainPath + '/rest/ui/manage/chaincode';
            path = path + '?chainCodeName=' + encodeURIComponent($("#chainCodeName").val());
            table.reload('blockchain_manager', {
                url: path
                ,height: 'full-'+tableHeight
                ,page: {
                    curr: 1 //重新从第 1 页开始
                }
            });
        },
        createUser: function () {
            window.location.href=blockchainPath + '/auth/user/create?menu=' + menuShowType;
        },
        downTemp: function () {
            layer.msg('不允许空模板导入，需要填写模板后导入',{icon: 2});
            window.open(blockchainPath + '/doc/'+ encodeURIComponent('用户导入模板.xls'));
        }
    };

    /**------------------监听上方工具按钮---------------*/
    $('.gt-toolbar .layui-btn').on('click', function () {
        var type = $(this).data('type');
        active[type] ? active[type].call(this) : '';
    });
    /*
        $('.optionTable .layui-btn').on('click', function(){
            var type = $(this).data('type');
            active[type] ? active[type].call(this) : '';
        });*/

    //加载树
    var onClick = function(event, treeId, treeNode){
        loadRightContent(treeNode);
    }
    //加载树
    custom_tree.load({
        treeId: "org_tree",
        commonUrl: blockchainPath + "/rest/ui/manage/chaincode/channels",
        onClick: onClick,
        checkboxEnabled: false
    });

    function loadRightContent(treeNode){
        //var path = blockchainPath + '/rest/org/' + treeNode.id + '/users';
        var path = blockchainPath + '/rest/ui/manage/chaincode?channelName=' + treeNode.id;
        table.reload('blockchain_manager', {
            url: path
            ,height: 'full-'+tableHeight
            ,page: {
                curr: 1 //重新从第 1 页开始
            }
        });
    }

});

function configMiddle(path,chainCodeName){
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });

        $.ajax({
            //几个参数需要注意一下
            type: "GET",//方法类型
            dataType: "json",//预期服务器返回的数据类型
            url: blockchainPath + "/rest/ui/manage/chaincode/context/remote?path="+path+"&chainCodeName="+chainCodeName,//url
            success: function (result) {
                $("#configContent").val(result);
                var index = layer.open({
                    type: 1,
                    title: '链码',
                    shadeClose: true,
                    skin: 'layer-ext-blue',
                    shade: false,
                    maxmin:true , //开启最大化最小化按钮
                    area: ['800px', '500px'],
                    content: $("#middlewareConfig")
                    ,btn: ['更新', '关闭'] //只是为了演示
                    ,btnAlign: 'c'
                    ,moveType: 0 //拖拽模式，0或者1
                    ,yes: function(){
                        layer.closeAll();
                    }
                    ,btn2: function(){
                        layer.closeAll();
                    }
                });
            },
            error: function (result) {
                $("#configContent").val(result.responseText);
                var index = layer.open({
                    type: 1,
                    title: '链码',
                    shadeClose: true,
                    skin: 'layer-ext-blue',
                    shade: false,
                    maxmin:true , //开启最大化最小化按钮
                    area: ['800px', '500px'],
                    content: $("#middlewareConfig")
                    ,btn: ['更新', '关闭'] //只是为了演示
                    ,btnAlign: 'c'
                    ,moveType: 0 //拖拽模式，0或者1
                    ,yes: function(){
                        layer.closeAll();
                    }
                    ,btn2: function(){
                        layer.closeAll();
                    }
                });
            }
        });
    });
}


