
layui.config({
    base: blockchainPath + '/custom/js/'
});
var form;
var laytpl;

layui.use(['jquery','table', 'layer','form','laytpl'], function(){

    var table = layui.table;
    form = layui.form;
    var $ = layui.$
    laytpl = layui.laytpl;

    var tableHeight= initHeight("init");
    // window.onresize=initHeight;
    function initHeight (flag){
        var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+$('.crumbs-path').height()+22+30+20+10;
        var bodyHeight=client().height-$(".gt-toolbar").height()-32;
        $(".gtmap-body").height(bodyHeight);
        if(flag=="init"){
            return vheight;
        }else{
            table.reload('blockchain_manager', {
                height: "full-"+vheight
            });
        }
    }

    table.on('checkbox(user)', function(obj){
        console.log(obj)
    });

    //testAjs();
    //初始化表格
    table.render({
        elem: '#LAY_table_user'
        ,url: blockchainPath + '/rest/ui/manage/chaincode/local'
        ,height: 'full-'+tableHeight
        ,cols: [[
            {field:'name', title: '名称'}
            ,{field:'version', title: '版本'}
            ,{field:'status',title: '当前阶段'}
            ,{field:'path',title: '本地路径'}
            ,{fixed: 'right', title: '操作', align:'center', width:300, toolbar: '#barDemo'}
        ]]
        ,id: 'blockchain_manager'
        ,page: false
    });

    //监听工具条
    table.on('tool(user)', function(obj){
        var data = obj.data;
        if(obj.event==='config'){
            configMiddle(data.path,data.name);
        }else if(obj.event==='downLocal'){
            window.open(blockchainPath + "/rest/ui/manage/chaincode/download/local?path="+ encodeURIComponent(data.path));
        }
    });

    $('div [data-type="reloadTable"]').bind("click",function () {
        active.reloadTable();
    });

    var $ = layui.$, active = {
        reloadTable: function(){
            var path = blockchainPath + '/rest/ui/manage/chaincode/local';
            path = path + '?chainCodeName=' + encodeURIComponent($("#chainCodeName").val());
            table.reload('blockchain_manager', {
                url: path
                ,height: 'full-'+tableHeight
                ,page: {
                    curr: 1 //重新从第 1 页开始
                }
            });
        },
        downTemp: function () {
            layer.msg('不允许空模板导入，需要填写模板后导入',{icon: 2});
            window.open(blockchainPath + '/doc/'+ encodeURIComponent('用户导入模板.xls'));
        },
        addChaincode:function(){

            //初始化主bean
            var initBeanConfigTpl = $("#initBeanConfigTpl").html();
            laytpl(initBeanConfigTpl).render({allFileTypeList:allFieldTypeList}, function(result){
                $("#primaryBeanContent").html(result)
            });
            form.render('select')
            form.render('checkbox')
            //删除子bean
            $(".refBeanContent").remove();
            layui.use('layer', function(){
                var layer = layui.layer;
                layer.config({
                    extend: 'blue/layer.css' //同样需要加载新皮肤
                });

                var index = layer.open({
                    type: 1,
                    title: '添加智能合约',
                    shadeClose: true,
                    skin: 'layer-ext-blue',
                    shade: false,
                    maxmin:true , //开启最大化最小化按钮
                    area: ['90%', '90%'],
                    content: $("#chainCodeDefineLayer")
                    ,btn: ['生成链码', '关闭'] //只是为了演示
                    ,btnAlign: 'c'
                    ,moveType: 0 //拖拽模式，0或者1
                    ,yes: function(){
                        saveChaincode();
                    }
                    ,btn2: function(){
                        layer.closeAll();
                    }
                });

            });
        }
    };

    /**------------------监听上方工具按钮---------------*/
    $('.gt-toolbar .layui-btn').on('click', function () {
        var type = $(this).data('type');
        active[type] ? active[type].call(this) : '';
    });

    form.on('select(fieldTypeChange)', function(data){
        /* alert(data.elem);*/ //得到select原始DOM对象
        /*alert(data.value);*/ //得到被选中的值
        /*alert(data.othis); *///得到美化后的DOM对象

        if(data.value=='arr' || data.value=='obj'){
            $(data.elem).parents("tr").find("td.refFieldTypeTd").html("<a class=\"layui-btn layui-btn-xs layui-fontbtn\" onclick=\"selectRefFieldType(this)\">选择</a>");
        }else{
            $(data.elem).parents("tr").find("td.refFieldTypeTd").html("");
        }
    });

    function saveChaincode(){
        var param = checkChaincode();
        if(param){
            dosaveChaincode(param);
        }
    }

    function checkChaincode(){
        var param = {};
        var beanDefinitionList = [];
        param.beanDefinitionList = beanDefinitionList;
        var isValid = true;

        //设置基本信息
        var chainCodeName = $("#formChainCodeName").val();
        if(!chainCodeName){
            layer.msg('合约名称必填',{icon:2});
            return false;
        }
        param.chainCodeName = chainCodeName;

        var version = $("#version").val();
        if(!version){
            layer.msg('版本号必填',{icon:2});
            return false;
        }
        param.version = version;

        $("#code_define_form").find("#primaryBeanContent,.refBeanContent").each(function(index,item){
            var beanDefinition = {};
            var fieldDefinitionList = [];
            //设置beanName
            var beanName = $(item).find("input[name='beanName']").val();
            if(!beanName){
                layer.msg('类名必填',{icon:2});
                isValid = false;
                return false;
            }
            beanDefinition.beanName = beanName;
            //设置beanDesc
            beanDefinition.beanDesc = $(item).find("input[name='beanDesc']").val();
            //设置是否是主类
            if($(item).attr("id")=="primaryBeanContent"){
                beanDefinition.isPrimary = 1;
            }else{
                beanDefinition.isPrimary = 0;
            }
            //设置属性字段
            beanDefinition.goFieldDefinitionList = fieldDefinitionList;
            var primaryKeyCount = 0;
            $(item).find("tbody tr").each(function(j,fieldItem){
                var fieldDefinition = {};
                //设置主键
                if($(fieldItem).find("input[name='isPrimaryKey']") && $(fieldItem).find("input[name='isPrimaryKey']").prop("checked")){
                    if(primaryKeyCount>0){
                        layer.msg('主键最多只有一个',{icon:2});
                        isValid = false;
                        return false;
                    }
                    primaryKeyCount++;
                    fieldDefinition.isPrimaryKey = 1;
                }else{
                    fieldDefinition.isPrimaryKey = 0;
                }

                //设置是否是索引
                if($(fieldItem).find("input[name='isIndex']") && $(fieldItem).find("input[name='isIndex']").prop("checked")==1){
                    fieldDefinition.isIndex = 1;
                }else{
                    fieldDefinition.isIndex = 0;
                }

                //设置fieldName
                var fieldName = $(fieldItem).find("input[name='fieldName']").val();
                if(!fieldName){
                    layer.msg('字段名称不能为空',{icon:2});
                    isValid = false;
                    return false;
                }
                fieldDefinition.fieldName = fieldName;
                //设置字段类型
                var fieldType = $(fieldItem).find("select[name='fieldType']").val();
                if(!fieldType){
                    layer.msg('字段类型不能为空',{icon:2});
                    isValid = false;
                    return false;
                }
                fieldDefinition.fieldType = fieldType;
                //设置fieldDesc
                var fieldDesc = $(fieldItem).find("input[name='fieldDesc']").val();
                fieldDefinition.fieldDesc = fieldDesc;
                if(fieldType=='arr'){
                    //设置关联属性
                    var refStr = $(fieldItem).find(".refFieldTypeTd").text();
                    if(!refStr){
                        layer.msg('数组类型需要选择关联类型',{icon:2});
                        isValid = false;
                        return false;
                    }
                    var basicRefFieldArr = basicFieldTypeList.filter(function(item) {
                        return item.value==refStr;
                    });
                    if(basicRefFieldArr && basicRefFieldArr.leng>0){
                        fieldDefinition.basicFieldType = refStr;
                    }else{
                        if(!fieldDefinition.refBean) fieldDefinition.refBean = {};
                        fieldDefinition.refBean.beanName = refStr;
                    }

                }else if(fieldType=='obj'){
                    var refStr = $(fieldItem).find(".refFieldTypeTd").text();
                    if(!refStr){
                        layer.msg('数组类型需要选择关联类型',{icon:2});
                        isValid = false;
                        return false;
                    }
                    fieldDefinition.refBean.beanName = refStr;
                }
                fieldDefinitionList.push(fieldDefinition);
            })

            if(beanDefinition.isPrimary && primaryKeyCount==0){
                layer.msg('主类必须存在主键',{icon:2});
                isValid = false;
                return false;
            }



            if(!isValid){
                return false;
            }
            beanDefinitionList.push(beanDefinition)
        });
        if(isValid){
            return param;
        }
        return isValid;
    }

    function dosaveChaincode(param){
        $.ajax({
            url: blockchainPath + '/rest/ui/manage/chaincode/generateCodeFile',
            type: 'post',
            data: JSON.stringify(param),
            contentType: 'application/json',
            beforeSend: function (XMLHttpRequest) {
                layer.load(2, {
                    shade: 0.3
                });
            },
            success: function (res) {
                layer.closeAll('loading');
                layer.msg('生成成功',{icon:1});
                window.location.reload();
            },
            error : function(error) {
                layer.closeAll('loading');
                layer.msg('生成失败！', {icon: 5});
            }
        });
    }


});

function configMiddle(path,chainCodeName){
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });

        $.ajax({
            //几个参数需要注意一下
            type: "GET",//方法类型
            dataType: "json",//预期服务器返回的数据类型
            url: blockchainPath + "/rest/ui/manage/chaincode/context/local?path="+encodeURIComponent(path)+"&chainCodeName="+chainCodeName,//url
            success: function (result) {
                $("#configContent").val(result);
                var index = layer.open({
                    type: 1,
                    title: '链码',
                    shadeClose: true,
                    skin: 'layer-ext-blue',
                    shade: false,
                    maxmin:true , //开启最大化最小化按钮
                    area: ['800px', '500px'],
                    content: $("#middlewareConfig")
                    ,btn: ['更新', '关闭'] //只是为了演示
                    ,btnAlign: 'c'
                    ,moveType: 0 //拖拽模式，0或者1
                    ,yes: function(){
                        layer.closeAll();
                    }
                    ,btn2: function(){
                        layer.closeAll();
                    }
                });
            },
            error: function (result) {
                $("#configContent").val(result.responseText);
                var index = layer.open({
                    type: 1,
                    title: '链码',
                    shadeClose: true,
                    skin: 'layer-ext-blue',
                    shade: false,
                    maxmin:true , //开启最大化最小化按钮
                    area: ['800px', '500px'],
                    content: $("#middlewareConfig")
                    ,btn: ['更新', '关闭'] //只是为了演示
                    ,btnAlign: 'c'
                    ,moveType: 0 //拖拽模式，0或者1
                    ,yes: function(){
                        layer.closeAll();
                    }
                    ,btn2: function(){
                        layer.closeAll();
                    }
                });
            }
        });
    });
}

function addFieldConfig(e,ref){
    var fieldConfigTpl = $("#fieldConfigTpl").html();
    if(ref){
        fieldConfigTpl = $("#refFieldConfigTpl").html();
    }

    laytpl(fieldConfigTpl).render({allFileTypeList:allFieldTypeList}, function(html){
        $(e).parent().parent().find(".field-table tbody").append(html);
    });
    form.render('select')
    form.render('checkbox');
}

function delFieldConfig(e){
    $(e).parents("tr").remove();
}


function selectRefFieldType(e){
    var refFieldTypeList = [];
    var fieldType = $(e).parents("tr").find("select[name='fieldType']").val();
    var objTypeList = [];
    //获取所有子类
    $("#chainCodeDefineLayer .refBeanContent").each(function(index,item){
        var beanName = $(item).find("input[name='beanName']").val();
        if(beanName){
            objTypeList.push({value:beanName,remark:beanName});
        }
    });

    if(fieldType == 'arr'){
        refFieldTypeList = basicFieldTypeList.concat(objTypeList);
    }else if(fieldType == 'obj'){
        refFieldTypeList = objTypeList;
    }

    var fieldConfigTypeOptionTpl = $("#fieldConfigTypeOptionTpl").html();
    laytpl(fieldConfigTypeOptionTpl).render({fieldTypeList:refFieldTypeList}, function(result){
        $("#refFieldTypeLayer [name='refFieldType']").html(result)
    });
    form.render('select')


    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });

        var index = layer.open({
            type: 1,
            title: '选择关联类型',
            shadeClose: true,
            skin: 'layer-ext-blue',
            shade: false,
            maxmin:true , //开启最大化最小化按钮
            area: ['600px', '400px'],
            content: $("#refFieldTypeLayer")
            ,btn: ['确定', '取消'] //只是为了演示
            ,btnAlign: 'c'
            ,moveType: 0 //拖拽模式，0或者1
            ,yes: function(){
                var refFieldType = $("#refFieldTypeLayer [name='refFieldType']").val();
                if(refFieldType){
                    $(e).parents("tr").find("td.refFieldTypeTd").html("<a class=\"layui-btn layui-btn-xs layui-fontbtn\" onclick=\"selectRefFieldType(this)\">"+refFieldType+"</a>");
                    layer.close(index);
                }else{
                    layer.msg('请选择关联类型',{icon: 2});
                }
            }
            ,btn2: function(){
                layer.close(index);
            }
        });

    });
}

function addRefBean(){


    var refBeanConfigTpl = $("#refBeanConfigTpl").html();
    laytpl(refBeanConfigTpl).render({allFileTypeList:allFieldTypeList}, function(result){
        $("#code_define_form").append(result);
    });
    form.render('select')
}

function deleteRefBeanContent(e){
    $(e).parents(".refBeanContent").remove();
}

