var deployUiPath=$("#deployUiPath").val();
var selectHostId,selectMiddlewareType;
var tableHeight;
layui.config({
    base: deployUiPath + '/custom/js/'
});

layui.use(['table','layer','custom_tree'], function(){
    var table = layui.table;
    var layer = layui.layer;
    var custom_tree = layui.custom_tree;

    //监听工具条
    table.on('tool(model)', function(obj){
        var data = obj.data;
        if(obj.event === 'del'){
            delMiddle(data.id);
        } else if(obj.event === 'restart'){
            restartMiddle(data.hostUuid,data.type);
        }else if(obj.event === 'stop'){
            stopMiddle(data.hostUuid,data.type);
        }else if(obj.event === 'check'){
            checkMiddle(data.hostUuid,data.type);
        }else if(obj.event==='config'){
            configMiddle(data.path,data.name);
        }else if(obj.event==='showData'){
            showData(data);
        }else if(obj.event==="showDataDetail"){
            showDataDetail(data);
        }
    });

    //加载树
    var onClick = function(event, treeId, treeNode){
        loadRightContent(treeNode);
    }
    //加载树
    custom_tree.load({
        treeId: "org_tree",
        commonUrl: blockchainPath + "/rest/ui/manage/chaincode/channels",
        onClick: onClick,
        checkboxEnabled: false
    });

    tableHeight = initHeight("init");
    // window.onresize=initHeight;
    function initHeight (flag){
        var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+$('.crumbs-path').height()+22+30+20+10;
        var bodyHeight=client().height-$(".gt-toolbar").height()-32;
        $(".gtmap-body").height(bodyHeight);
        if(flag=="init"){
            return vheight;
        }else{
            table.reload('table_user_manager', {
                height: "full-"+vheight
            });
        }
    }

    function loadRightContent(treeNode){
        console.log("loadRightContent");
        console.log(treeNode);
        console.log(treeNode.id);
        var path = blockchainPath + '/rest/ui/manage/chaincode?channelName=' + treeNode.id;
        table.reload('table_chaincode_model', {
            url: path
            ,height: 'full-'+tableHeight
            ,page: false
        });
    }

});

/**
 * 表格数据加载
 */
var loadData=function(){
    layui.use(['table','layer'], function() {
        var table = layui.table;
        var hostIP = $('#hostIP').val();
        hostIP=hostIP.trim();
        //执行重载
        table.reload('table_middle_model', {
            page: {
                curr: 1 //重新从第 1 页开始
            }
            , where: {
                hostIP: hostIP
            }
        });
    })
}

/**
 * 打开中间件详细
 * @param modelId
 * @param action
 */
var openMiddleInfo=function (middleId) {
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });
        var index = layer.open({
            type: 2,
            title: '中间件详细',
            shadeClose: true,
            skin: 'layer-ext-blue',
            shade: false,
            maxmin:false , //开启最大化最小化按钮
            area: ['550px', '500px'],
            content: '/middleware-info?id='+middleId
        });
    });

    // window.location.href =deployUiPath + '/Middle-info?MiddleId='+MiddleId
}

/**
 * 新建主机
 * @param modelId
 */
var addMiddleInfo=function(){
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });
        var url = '/middleware-info?type=2';
        if($.cookie('intro_cookie_middleware')){
            url = '/middleware-info'
        }
        var index = layer.open({
            type: 2,
            title: '新建中间件',
            shadeClose: true,
            skin: 'layer-ext-blue',
            shade: false,
            maxmin:false , //开启最大化最小化按钮
            area: ['800px', '360px'],
            content: url
        });
    });

}

function delMiddle(id) {
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.confirm('真的卸载吗?',{btnAlign: 'c',icon: 3 },function(index){
            var path = deployUiPath + '/ui/v1/middle-ware/'+id+'/unload';
            $.ajax({
                url: path,
                type: 'post',
                cache: false,
                beforeSend: function (XMLHttpRequest) {
                    layer.load(2,{
                        shade: 0.3
                    });
                },
                error: function() {
                    layer.closeAll('loading');
                    layer.close(index);
                    layer.msg("操作失败", {icon: 5});
                },
                success : function(data) {
                    layer.closeAll('loading');
                    loadData();
                    layer.close(index);
                    layer.msg('操作成功', {icon: 6});

                }
            });
        });
    });
}

function restartMiddle(hostId,middlewareType) {
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.confirm('真的重启吗?',{btnAlign: 'c',icon: 3 },function(index){
            var path = deployUiPath + '/ui/v1/middle-ware/'+hostId+'/restart?middlewareType='+ middlewareType;
            $.ajax({
                url: path,
                type: 'post',
                cache: false,
                beforeSend: function (XMLHttpRequest) {
                    layer.load(2,{
                        shade: 0.3
                    });
                },
                error: function() {
                    layer.closeAll('loading');
                    layer.close(index);
                    layer.msg("操作失败", {icon: 5});
                },
                success : function(data) {
                    layer.closeAll('loading');
                    loadData();
                    layer.close(index);
                    layer.msg('操作成功', {icon: 6});

                }
            });
        });
    });
}
function configMiddle(path,chainCodeName){
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });

        $.ajax({
            //几个参数需要注意一下
            type: "GET",//方法类型
            dataType: "json",//预期服务器返回的数据类型
            url: deployUiPath + "/rest/ui/manage/chaincode/context?path="+path+"&chainCodeName="+chainCodeName,//url
            success: function (result) {
                $("#configContent").val(result);
                var index = layer.open({
                    type: 1,
                    title: '链码',
                    shadeClose: true,
                    skin: 'layer-ext-blue',
                    shade: false,
                    maxmin:true , //开启最大化最小化按钮
                    area: ['800px', '500px'],
                    content: $("#middlewareConfig")
                    ,btn: ['更新', '关闭'] //只是为了演示
                    ,btnAlign: 'c'
                    ,moveType: 0 //拖拽模式，0或者1
                    ,yes: function(){
                        layer.closeAll();
                    }
                    ,btn2: function(){
                        layer.closeAll();
                    }
                });
            },
            error: function (result) {
                $("#configContent").val(result.responseText);
                var index = layer.open({
                    type: 1,
                    title: '链码',
                    shadeClose: true,
                    skin: 'layer-ext-blue',
                    shade: false,
                    maxmin:true , //开启最大化最小化按钮
                    area: ['800px', '500px'],
                    content: $("#middlewareConfig")
                    ,btn: ['更新', '关闭'] //只是为了演示
                    ,btnAlign: 'c'
                    ,moveType: 0 //拖拽模式，0或者1
                    ,yes: function(){
                        layer.closeAll();
                    }
                    ,btn2: function(){
                        layer.closeAll();
                    }
                });
            }
        });
    });
}

function showData (data) {

    channelId = data.name;
    chainCodeId = data.name;
    chainCodeVersion = data.version;

    layui.use(['table','layer'], function() {
        var table = layui.table;

        table.reload('table_detail_model', {
            url: deployUiPath + '/rest/v1/chain/invoke'
            , method: "post"
            , contentType: "application/json"
            , where: {
                "channelId": data.name,
                "chainCodeId": data.name,
                "chainCodeVersion": data.version,
                "funcName": "richQuery",
                "args": ["{\"selector\":{\"Bdcdyh\":{\"$regex\":\"\"}}}"]
            }
            , parseData: function(res) {
                var resData = res.data.substr(36);
                var index = resData.indexOf(",\\\"total\\\"");
                resData = resData.substr(0, index);
                resData = resData.replace(/\\"/g,"\"");
                var resDataObj = {};
                resDataObj.code = 0;
                resDataObj.data = eval(resData);
                return resDataObj;
            }
            , height: 'full-' + tableHeight
            , page: false
        });
    });

    layer.open({
        type: 1
        , title: '数据展示'
        , shadeClose: true
        , skin: 'layer-ext-blue'
        , shade: false
        , maxmin: true //开启最大化最小化按钮
        , area: ['800px', '500px']
        , content: $("#channelDataShow")
        , btn: ['确认', '关闭'] //只是为了演示
        , btnAlign: 'c'
        , moveType: 0 //拖拽模式，0或者1
        , yes: function() {
            layer.closeAll();
        }
        , btn2: function() {
            layer.closeAll();
        }
    });
}

var channelId;
var chainCodeId;
var chainCodeVersion;
function showDataDetail (data) {

    $.ajax({
        url: deployUiPath + '/rest/v1/chain/invoke'
        , type: "post"
        , contentType: "application/json"
        , data: JSON.stringify({
            "channelId": channelId,
            "chainCodeId": chainCodeId,
            "chainCodeVersion": chainCodeVersion,
            "funcName": "findById",
            "args": [data.Key]
        })
        , success: function(res) {
            console.log(res);
            var resData = res.data.substr(36);
            var index = resData.length - 2;
            console.log(index);
            console.log(resData);
            resData = resData.substr(0, index);
            console.log(resData);
            resData = resData.replace(/\\"/g,"\"");
            $("#dataDetailContent").val(resData);
        }
    });

    layer.open({
        type: 1
        , title: '数据详情'
        , shadeClose: true
        , skin: 'layer-ext-blue'
        , shade: false
        , maxmin: true //开启最大化最小化按钮
        , area: ['800px', '500px']
        , content: $("#channelDataDetail")
        , btnAlign: 'c'
        , moveType: 0 //拖拽模式，0或者1
    });
}

function saveConfigMiddle(){
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });

        $.ajax({
            //几个参数需要注意一下
            type: "post",//方法类型
            dataType: "json",//预期服务器返回的数据类型
            data: {hostId:selectHostId,middlewareType:selectMiddlewareType,configContent:$("#configContent").val()},
            url: deployUiPath + "/ui/v1/middle-ware/config",//url
            success: function (result) {
                if(result.code==0){
                    layer.msg('更新成功', {icon: 6});
                }else{
                    layer.msg(result.msg);
                }
            },
            error: function () {
                layer.msg("更新异常！");
            }
        });

    });
}

function checkMiddle(hostId,middlewareType) {
    layui.use('layer', function(){
        var layer = layui.layer;
        var path = deployUiPath + '/ui/v1/middle-ware/'+hostId+'/check?middlewareType='+ middlewareType;
        $.ajax({
            url: path,
            type: 'post',
            cache: false,
            error: function() {
                layer.msg("服务内部错误！", {icon: 5});
            },
            success : function(data) {
                loadData();
                if(data){
                    layer.msg('中间件启动成功！', {icon: 6});
                }else {
                    layer.msg("中间件启动失败！", {icon: 5});
                }



            }
        });
    });
}

function stopMiddle(hostId,middlewareType) {
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.confirm('真的停止吗?',{btnAlign: 'c',icon: 3 },function(index){
            var path = deployUiPath + '/ui/v1/middle-ware/'+hostId+'/stop?middlewareType='+middlewareType;
            $.ajax({
                url: path,
                type: 'post',
                cache: false,
                error: function() {
                    layer.close(index);
                    layer.msg("操作失败", {icon: 5});
                },
                success : function(data) {
                    loadData();
                    layer.close(index);
                    layer.msg('操作成功', {icon: 6});

                }
            });
        });
    });
}


function openLog(id) {
    var index;
    layui.use('layer', function(){
        var layer = layui.layer;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });
        index = layer.open({
            type: 2,
            title: '日志查看',
            area: ['1200px', '800px'],
            shadeClose: true,
            skin: 'layer-ext-blue',
            shade: false,
            maxmin:false , //开启最大化最小化按钮
            content: deployUiPath + '/log-info?logKey='+id
        });
    });
    return index;
}

function initHelp(){
    //这个变量可以用来存取版本号， 系统更新时候改变相应值
    var cur_val = 1;
    //判断函数所接收变量的长度
    if (isEmpty(arguments.length)) {
        //每个页面设置不同的cookie变量名称，不可以重复，有新版本时，更新cur_val
        //这里模拟很多网站有新版本更新时才出现一次引导页， 第二次进入进不再出现， 这里有COOKIE来判断
        if ($.cookie('intro_cookie_middleware') == cur_val) {
            return;
        }
    }
    introJs().setOptions({
        /* 下一步按钮的显示名称 */
        nextLabel: '下一步 ',
        /* 上一步按钮的显示名称 */
        prevLabel: '上一步',
        /* 跳过按钮的显示名称 */
        skipLabel: '跳过',
        /* 结束按钮的显示名称 */
        doneLabel: '开始',
        /* 引导说明框相对高亮说明区域的位置 */
        tooltipPosition: 'bottom',
        /* 是否使用键盘Esc退出 */
        exitOnEsc: true,
        /* 是否允许点击空白处退出 */
        exitOnOverlayClick: false,
        /* 是否显示说明的数据步骤*/
        showStepNumbers: true,
        /* 是否使用点点点显示进度 */
        showBullets: true,
        /* 是否显示进度条 */
        showProgress: false,
        /* 是否滑动到高亮的区域 */
        scrollToElement: true,
        /* 遮罩层的透明度 */
        overlayOpacity: 0.8,
        /* 当位置选择自动的时候，位置排列的优先级 */
        positionPrecedence: ["bottom", "top", "right", "left"]
    }).start().oncomplete(function() {
        //点击开始按钮后执行的事件(这里保存对应的版本号到cookie,并且设置有效期为30天）
        $.cookie('intro_cookie_middleware',cur_val,{'path': '/',expires:30});
        addMiddleInfo();

    }).onexit(function() {
        //点击跳过按钮后执行的事件(这里保存对应的版本号到cookie,并且设置有效期为30天）
        $.cookie('intro_cookie_middleware',cur_val,{'path': '/',expires:30});
    });
}
/** 手动开启向导，先清空cookie .*/
$('#initHelp').click(function () {
    $.removeCookie('intro_cookie_middleware',{ path: '/'});
    $.removeCookie('intro_cookie_middleware-info',{ path: '/'});
    initHelp();
});

//initHelp();





