/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.web.rest.v1;

import cn.gtmap.gtc.bc.domain.dto.ChainOptionDTO;
import cn.gtmap.gtc.bc.domain.dto.ChainResultDTO;
import cn.gtmap.gtc.bc.domain.enums.BlockChainPlatform;
import cn.gtmap.gtc.chain.property.BlockChainProperties;
import cn.gtmap.gtc.chain.service.AliFabricService;
import cn.gtmap.gtc.chain.service.FabricService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1/chain"})
@Api(value="ChainController", tags={"\u94fe\u7801\u8c03\u7528"})
public class ChainController {
    @Autowired
    private BlockChainProperties blockChainProperties;
    @Autowired
    private FabricService fabricService;
    @Autowired
    private AliFabricService aliFabricService;

    @ApiOperation(value="\u63d0\u4ea4\u4fdd\u5b58\u7b49\u6570\u636e\u53d8\u66f4\u64cd\u4f5c")
    @PostMapping(value={"/invoke"})
    public ChainResultDTO invokeChainCode(@RequestBody ChainOptionDTO chainOptionDTO) {
        ChainResultDTO resultDTO = new ChainResultDTO();
        try {
            if (StringUtils.endsWithIgnoreCase((String)BlockChainPlatform.FABRIC.name(), (String)this.blockChainProperties.getPlatform())) {
                String data = this.fabricService.invokeBlockChain(chainOptionDTO);
                resultDTO.setData(data);
            } else if (StringUtils.endsWithIgnoreCase((String)BlockChainPlatform.ALI_FABRIC.name(), (String)this.blockChainProperties.getPlatform())) {
                String data = this.aliFabricService.invokeBlockChain(chainOptionDTO);
                resultDTO.setData(data);
            } else {
                resultDTO.setCode(ChainResultDTO.ResultCode.FAILURE.intValue()).setMsg("not support platform for".concat(this.blockChainProperties.getPlatform()));
            }
        }
        catch (Exception e) {
            resultDTO.setCode(ChainResultDTO.ResultCode.FAILURE.intValue()).setMsg(e.getMessage());
        }
        return resultDTO;
    }

    @ApiOperation(value="\u5f53\u524d\u6570\u636e\u53ca\u5386\u53f2\u6570\u636e\u67e5\u8be2\u64cd\u4f5c")
    @PostMapping(value={"/query"})
    public ChainResultDTO queryByChainCode(@RequestBody ChainOptionDTO chainOptionDTO) {
        ChainResultDTO resultDTO = new ChainResultDTO();
        try {
            if (StringUtils.endsWithIgnoreCase((String)BlockChainPlatform.FABRIC.name(), (String)this.blockChainProperties.getPlatform())) {
                String data = this.fabricService.queryBlockChain(chainOptionDTO);
                resultDTO.setData(data);
            } else if (StringUtils.endsWithIgnoreCase((String)BlockChainPlatform.ALI_FABRIC.name(), (String)this.blockChainProperties.getPlatform())) {
                String data = this.aliFabricService.queryBlockChain(chainOptionDTO);
                resultDTO.setData(data);
            } else {
                resultDTO.setCode(ChainResultDTO.ResultCode.FAILURE.intValue()).setMsg("not support platform for".concat(this.blockChainProperties.getPlatform()));
            }
        }
        catch (Exception e) {
            resultDTO.setCode(ChainResultDTO.ResultCode.FAILURE.intValue()).setMsg(e.getMessage());
        }
        return resultDTO;
    }
}

