/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.web.rest.ui;

import cn.gtmap.gtc.bc.domain.enums.ChainCodeDeployStatus;
import cn.gtmap.gtc.bc.domain.qo.ChainPageable;
import cn.gtmap.gtc.bc.domain.vo.ChainCodeVO;
import cn.gtmap.gtc.bc.domain.vo.ChainPageVO;
import cn.gtmap.gtc.bc.domain.vo.LayPage;
import cn.gtmap.gtc.chain.generator.core.entity.ChaincodeDefinition;
import cn.gtmap.gtc.chain.generator.core.entity.GoBeanDefinition;
import cn.gtmap.gtc.chain.generator.core.entity.GoFieldDefinition;
import cn.gtmap.gtc.chain.generator.core.generatorConstant;
import cn.gtmap.gtc.chain.service.FabricService;
import cn.gtmap.gtc.chain.service.ShellManageService;
import cn.gtmap.gtc.chain.service.impl.ShellManageServiceImpl;
import cn.gtmap.gtc.chain.util.FileUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/ui/manage/chaincode"})
@Api(value="ChaincodeManageController", tags={"\u94fe\u7801\u7ba1\u7406"})
public class ChaincodeManageController {
    @Autowired
    private ShellManageService shellManageService;
    @Autowired
    private FabricService fabricService;
    @Autowired
    Configuration configuration;

    @ApiOperation(value="\u83b7\u53d6\u9891\u9053\u5217\u8868")
    @PostMapping(value={"/channels"})
    public List<Map<String, Object>> listChannel(Authentication authentication) {
        ArrayList result = Lists.newArrayList();
        List list = this.shellManageService.listChannel(authentication);
        for (String item : list) {
            HashMap map = Maps.newHashMap();
            map.put("id", item);
            map.put("name", item);
            result.add(map);
        }
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6\u8fdc\u7a0b\u667a\u80fd\u5408\u7ea6")
    @GetMapping
    public LayPage<ChainCodeVO> listRemoteChainCode(Authentication authentication, @RequestParam(name="channelName", required=false) String channelName, @RequestParam(name="chainCodeName", required=false) String chainCodeName) {
        List chainCodeVOList = this.shellManageService.listRemoteChainCode(authentication, channelName, chainCodeName);
        return new LayPage((long)chainCodeVOList.size(), chainCodeVOList);
    }

    @ApiOperation(value="\u83b7\u53d6\u672c\u5730\u667a\u80fd\u5408\u7ea6")
    @GetMapping(value={"/local"})
    public LayPage<ChainCodeVO> listLocalChainCode(Authentication authentication, @RequestParam(name="channelName", required=false) String channelName, @RequestParam(name="chainCodeName", required=false) String chainCodeName) {
        List chainCodeVOList = this.shellManageService.listLocalChainCode(authentication, channelName, chainCodeName);
        return new LayPage((long)chainCodeVOList.size(), chainCodeVOList);
    }

    @ApiOperation(value="\u83b7\u53d6\u8fdc\u7a0b\u667a\u80fd\u5408\u7ea6\u5185\u5bb9")
    @GetMapping(value={"/context/remote"})
    public String catRemoteCode(Authentication authentication, @RequestParam(name="path") String path, @RequestParam(name="chainCodeName") String chainCodeName) {
        return this.shellManageService.catRemoteCode(authentication, path, chainCodeName);
    }

    @ApiOperation(value="\u83b7\u53d6\u8fdc\u7a0b\u667a\u80fd\u5408\u7ea6\u5185\u5bb9")
    @GetMapping(value={"/context/local"})
    public String catLocalCode(Authentication authentication, @RequestParam(name="path") String path, @RequestParam(name="chainCodeName") String chainCodeName) throws IOException {
        return this.shellManageService.catLocalCode(authentication, path, chainCodeName);
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    public boolean chainCodeUpload(@RequestParam(value="file") MultipartFile[] files, @RequestParam(name="chainCodeName") String chainCodeName, @RequestParam(name="version") String version) throws IOException {
        return this.shellManageService.chainCodeUpload(chainCodeName, version, files);
    }

    @GetMapping(value={"/download/local"})
    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6")
    public ResponseEntity localChainCodeDownload(@RequestParam(value="path") String path) throws IOException {
        return this.shellManageService.localChainCodeDownload(path);
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u667a\u80fd\u5408\u7ea6\u6570\u636e")
    @PostMapping(value={"/data/page"})
    public ChainPageVO pageChainCode(Authentication authentication, @RequestBody ChainPageable chainPageable) throws Exception {
        JSONArray array;
        String res = this.fabricService.pageQuery(authentication, chainPageable);
        ChainPageVO vo = new ChainPageVO();
        JSONObject object = JSON.parseObject((String)res);
        if (object.containsKey((Object)"Bookmark")) {
            vo.setBookmark(object.getString("Bookmark"));
        }
        LinkedList data = Lists.newLinkedList();
        if (object.containsKey((Object)"Records") && (array = object.getJSONArray("Records")) != null && !array.isEmpty()) {
            for (int i = 0; i < array.size(); ++i) {
                HashMap m = Maps.newHashMap();
                JSONObject o = array.getJSONObject(i);
                m.put("chainCodeKey", o.getString("Key"));
                JSONObject record = o.getJSONObject("Record");
                Set keys = record.keySet();
                if (vo.getKeys() == null) {
                    vo.setKeys(new LinkedList(keys));
                }
                keys.stream().forEach(s -> m.put(s, record.getString(s)));
                data.add(m);
            }
        }
        vo.setData((List)data);
        return vo;
    }

    @ApiOperation(value="\u751f\u6210\u94fe\u7801\u6587\u4ef6")
    @PostMapping(value={"/generateCodeFile"})
    public void generateCodeFile(@RequestBody ChaincodeDefinition chaincodeDefinition) throws Exception {
        List beanDefinitionList = chaincodeDefinition.getBeanDefinitionList();
        if (!CollectionUtils.isEmpty((Collection)beanDefinitionList)) {
            String primaryKey = this.getPrimaryKeyFileName(beanDefinitionList);
            if (StringUtils.isBlank((CharSequence)primaryKey)) {
                throw new RuntimeException("\u5fc5\u987b\u8bbe\u7f6e\u4e3b\u952e");
            }
            GoBeanDefinition primaryBean = this.getPrimaryBean(beanDefinitionList);
            this.initRefBean(beanDefinitionList);
            this.generateGoFile(chaincodeDefinition, primaryKey, primaryBean);
            this.generateIndexFile(chaincodeDefinition, primaryBean);
            this.generateStatusFile(chaincodeDefinition);
            return;
        }
    }

    private void generateStatusFile(@RequestBody ChaincodeDefinition chaincodeDefinition) throws IOException {
        String fileDirPath = String.format(ShellManageServiceImpl.LOCAL_GO_FILE_PATH, chaincodeDefinition.getChainCodeName(), chaincodeDefinition.getVersion());
        Path location = Paths.get(fileDirPath, new String[0]);
        FileUtils.createDir((Path)location);
        String filePath = fileDirPath.concat("/").concat(ChainCodeDeployStatus.ENCODE.value()).concat(".status");
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
    }

    private void generateIndexFile(@RequestBody ChaincodeDefinition chaincodeDefinition, GoBeanDefinition primaryBean) throws IOException, TemplateException {
        Template template = this.configuration.getTemplate(generatorConstant.GO_INDEX_CODE_TEMPLATE_FILE);
        String fileDirPath = String.format(ShellManageServiceImpl.LOCAL_GO_MATE_INFO_FULL_PATH, chaincodeDefinition.getChainCodeName(), chaincodeDefinition.getVersion());
        Path location = Paths.get(fileDirPath, new String[0]);
        FileUtils.createDir((Path)location);
        String filePath = fileDirPath.concat("/").concat(chaincodeDefinition.getChainCodeName()).concat(".json");
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        FileWriter out = new FileWriter(file);
        HashMap<String, List> map = new HashMap<String, List>();
        List indexFieldDefinitionList = this.getIndexFieldList(primaryBean);
        map.put("indexFieldDefinitionList", indexFieldDefinitionList);
        template.process(map, (Writer)out);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private List<GoFieldDefinition> getIndexFieldList(GoBeanDefinition primaryBean) {
        List goFieldDefinitionList = primaryBean.getGoFieldDefinitionList();
        if (!CollectionUtils.isEmpty((Collection)goFieldDefinitionList)) {
            return goFieldDefinitionList.stream().filter(goFieldDefinition -> goFieldDefinition.getIsIndex() == 1).collect(Collectors.toList());
        }
        return null;
    }

    private void generateGoFile(@RequestBody ChaincodeDefinition chaincodeDefinition, String primaryKey, GoBeanDefinition primaryBean) throws IOException, TemplateException {
        List beanDefinitionList = chaincodeDefinition.getBeanDefinitionList();
        Template template = this.configuration.getTemplate(generatorConstant.GO_CODE_TEMPLATE_FILE);
        String fileDirPath = String.format(ShellManageServiceImpl.LOCAL_GO_FILE_PATH, chaincodeDefinition.getChainCodeName(), chaincodeDefinition.getVersion());
        Path location = Paths.get(fileDirPath, new String[0]);
        FileUtils.createDir((Path)location);
        String filePath = fileDirPath.concat("/").concat(chaincodeDefinition.getChainCodeName()).concat(".go");
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        FileWriter out = new FileWriter(file);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("beanDefinitionList", beanDefinitionList);
        map.put("primaryKey", primaryKey);
        map.put("primaryBeanName", primaryBean.getBeanName());
        template.process(map, (Writer)out);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private void initRefBean(List<GoBeanDefinition> beanDefinitionList) {
        Map<String, List<GoBeanDefinition>> beanDefinitionMap = beanDefinitionList.stream().collect(Collectors.groupingBy(GoBeanDefinition::getBeanName));
        beanDefinitionList.stream().forEach(goBeanDefinition -> {
            List goFieldDefinitionList = goBeanDefinition.getGoFieldDefinitionList();
            goFieldDefinitionList.stream().forEach(goFieldDefinition -> {
                if (goFieldDefinition.getRefBean() != null && StringUtils.isNotBlank((CharSequence)goFieldDefinition.getRefBean().getBeanName())) {
                    goFieldDefinition.setRefBean((GoBeanDefinition)((List)beanDefinitionMap.get(goFieldDefinition.getRefBean().getBeanName())).get(0));
                }
            });
        });
    }

    private GoBeanDefinition getPrimaryBean(List<GoBeanDefinition> beanDefinitionList) {
        for (GoBeanDefinition beanDefinition : beanDefinitionList) {
            if (beanDefinition.getIsPrimary() != 1) continue;
            return beanDefinition;
        }
        return null;
    }

    private String getPrimaryKeyFileName(List<GoBeanDefinition> beanDefinitionList) {
        for (GoBeanDefinition beanDefinition : beanDefinitionList) {
            List goFieldDefinitionList;
            if (beanDefinition.getIsPrimary() != 1 || CollectionUtils.isEmpty((Collection)(goFieldDefinitionList = beanDefinition.getGoFieldDefinitionList()))) continue;
            for (GoFieldDefinition goFieldDefinition : goFieldDefinitionList) {
                if (goFieldDefinition.getIsPrimaryKey() != 1) continue;
                return goFieldDefinition.getFieldName();
            }
        }
        return null;
    }
}

