/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.web;

import cn.gtmap.gtc.chain.generator.core.enums.FieldTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping
public class IndexController {
    private static final Logger logger = LoggerFactory.getLogger(IndexController.class);
    @Autowired
    private Environment env;
    @Value(value="${blockchain.platform:fabric}")
    private String platform;
    @Value(value="${app.oauth}")
    private String logout;

    private String getPlatformPath() {
        if ("fabric".equalsIgnoreCase(this.platform)) {
            return "/fabric/gtmap/";
        }
        return "";
    }

    @GetMapping(value={"/", "/index"})
    public String index() {
        return "/common/index";
    }

    @GetMapping(value={"/login"})
    public String login() {
        return "/common/login_default";
    }

    @GetMapping(value={"/border"})
    public String border() {
        return "/common/border";
    }

    @GetMapping(value={"/authUrl"})
    @ResponseBody
    public String getAuthUrl() {
        return this.env.getProperty("app.oauth");
    }

    @GetMapping(value={"/channel/manager"})
    public String channelManager() {
        return this.getPlatformPath() + "channel_manage";
    }

    @GetMapping(value={"/chaincode/manager"})
    public String chaincodeManager(Model model) {
        FieldTypeEnum[] fieldTypeEnums = FieldTypeEnum.values();
        if (fieldTypeEnums != null && fieldTypeEnums.length > 0) {
            model.addAttribute("allFieldTypeList", (Object)fieldTypeEnums);
        }
        return this.getPlatformPath() + "chaincode_manage";
    }

    @GetMapping(value={"/data/manager"})
    public String dataManager(Model model, @RequestParam(name="channelName") String channelName, @RequestParam(name="chainCodeName") String chainCodeName, @RequestParam(name="chainCodeVersion", required=false) String chainCodeVersion) {
        model.addAttribute("channelName", (Object)channelName);
        model.addAttribute("chainCodeName", (Object)chainCodeName);
        model.addAttribute("chainCodeVersion", (Object)chainCodeVersion);
        return this.getPlatformPath() + "data_manage";
    }
}

