/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtil {
    private static byte[] _byte = new byte[1024];
    private static final Logger logger = LoggerFactory.getLogger(ZipUtil.class.getClass());

    private ZipUtil() {
    }

    public static void zipFile(String zip, List<File> srcFiles) {
        if (!CollectionUtils.isEmpty(srcFiles)) {
            ZipUtil.zipFile((String)zip, (File[])srcFiles.toArray(new File[0]));
        }
    }

    public static void zipFile(String zip, File[] srcFiles) {
        try {
            if (zip.endsWith(".zip") || zip.endsWith(".zip".toUpperCase())) {
                ZipOutputStream _zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zip)));
                _zipOut.setEncoding("utf-8");
                for (File _f : srcFiles) {
                    ZipUtil.handlerFile((String)zip, (ZipOutputStream)_zipOut, (File)_f, (String)"");
                }
                _zipOut.close();
            } else {
                logger.debug("target file[" + zip + "] is not .zip type file");
            }
        }
        catch (IOException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlerFile(String zip, ZipOutputStream zipOut, File srcFile, String path) throws IOException {
        block13: {
            logger.debug(" begin to compression file[" + srcFile.getName() + "]");
            if (!"".equals(path) && !path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (srcFile.getPath().equals(zip)) break block13;
            if (srcFile.isDirectory()) {
                File[] _files = srcFile.listFiles();
                if (_files.length == 0) {
                    zipOut.putNextEntry(new ZipEntry(path + srcFile.getName() + File.separator));
                    zipOut.closeEntry();
                } else {
                    for (File _f : _files) {
                        ZipUtil.handlerFile((String)zip, (ZipOutputStream)zipOut, (File)_f, (String)(path + srcFile.getName()));
                    }
                }
            } else {
                FileInputStream _in = null;
                try {
                    _in = new FileInputStream(srcFile);
                    zipOut.putNextEntry(new ZipEntry(path + srcFile.getName()));
                    int len = 0;
                    while ((len = ((InputStream)_in).read(_byte)) > 0) {
                        zipOut.write(_byte, 0, len);
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
                finally {
                    if (_in != null) {
                        ((InputStream)_in).close();
                    }
                    zipOut.closeEntry();
                }
            }
        }
    }

    public static void zipFile(String zip, List<File> files, List<String> fileNameList) {
        try {
            if (zip.endsWith(".zip") || zip.endsWith(".zip".toUpperCase())) {
                ZipOutputStream _zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zip)));
                _zipOut.setEncoding("utf-8");
                for (int i = 0; i < files.size(); ++i) {
                    ZipUtil.handlerFile((ZipOutputStream)_zipOut, (File)files.get(i), (String)"", (String)fileNameList.get(i));
                }
                _zipOut.close();
            } else {
                logger.debug("target file[" + zip + "] is not .zip type file");
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlerFile(ZipOutputStream zipOut, File srcFile, String path, String fileName) throws IOException {
        logger.debug(" begin to compression file[" + fileName + "]");
        if (!"".equals(path) && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        zipOut.putNextEntry(new ZipEntry(path + fileName));
        int len = 0;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(srcFile);
            while ((len = inputStream.read(_byte)) > 0) {
                zipOut.write(_byte, 0, len);
            }
        }
        catch (IOException e) {
            logger.error(e.toString());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            zipOut.closeEntry();
        }
    }

    public static List<File> upzipFile(String zipPath, String descDir) {
        return ZipUtil.upzipFile((File)new File(zipPath), (String)descDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> upzipFile(File zipFile, String descDir) {
        ArrayList<File> _list = new ArrayList<File>();
        ZipFile _zipFile = null;
        try {
            _zipFile = new ZipFile(zipFile, "utf-8");
            Enumeration entries = _zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File _file = new File(descDir + File.separator + entry.getName());
                if (entry.isDirectory()) {
                    _file.mkdirs();
                    continue;
                }
                File _parent = _file.getParentFile();
                if (!_parent.exists()) {
                    _parent.mkdirs();
                }
                try (InputStream _in = _zipFile.getInputStream(entry);
                     FileOutputStream _out = new FileOutputStream(_file);){
                    int len = 0;
                    while ((len = _in.read(_byte)) > 0) {
                        ((OutputStream)_out).write(_byte, 0, len);
                    }
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
                _list.add(_file);
            }
        }
        catch (IOException e) {
            logger.error("\u89e3\u538b\u7f29zip\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (_zipFile != null) {
                try {
                    _zipFile.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95edzip\u6587\u4ef6\u6d41\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                }
            }
        }
        return _list;
    }

    public static File doZip(String zipDirectory, String zipPath) {
        File zipDir = new File(zipDirectory);
        if (zipPath == null) {
            zipPath = zipDir.getParent();
        }
        String zipFileName = zipPath + "\\" + zipDir.getName() + ".zip";
        try {
            ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipFileName)));
            ZipUtil.handleDir((File)zipDir, (int)(zipDir.getParent().length() + 1), (ZipOutputStream)zipOut);
            zipOut.close();
            return new File(zipFileName);
        }
        catch (IOException e) {
            logger.error(e.toString());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleDir(File dir, int len, ZipOutputStream zipOut) throws IOException {
        FileInputStream fileIn = null;
        File[] files = dir.listFiles();
        if (files != null) {
            if (files.length > 0) {
                for (File fileName : files) {
                    if (fileName.isDirectory()) {
                        ZipUtil.handleDir((File)fileName, (int)len, (ZipOutputStream)zipOut);
                        continue;
                    }
                    try {
                        int readedBytes;
                        fileIn = new FileInputStream(fileName);
                        byte[] buf = new byte[fileIn.available()];
                        zipOut.putNextEntry(new ZipEntry(fileName.getPath().substring(len + dir.getName().length()).replaceAll("\\\\", "")));
                        while ((readedBytes = fileIn.read(buf)) > 0) {
                            zipOut.write(buf, 0, readedBytes);
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.toString());
                    }
                    finally {
                        if (fileIn != null) {
                            fileIn.close();
                        }
                        zipOut.closeEntry();
                    }
                }
            } else {
                zipOut.putNextEntry(new ZipEntry(dir.getPath().substring(len) + "/"));
                zipOut.closeEntry();
            }
        } else {
            try {
                int readedBytes;
                fileIn = new FileInputStream(dir);
                byte[] buf = new byte[fileIn.available()];
                zipOut.putNextEntry(new ZipEntry(dir.getPath().substring(len)));
                while ((readedBytes = fileIn.read(buf)) > 0) {
                    zipOut.write(buf, 0, readedBytes);
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
            finally {
                if (fileIn != null) {
                    zipOut.closeEntry();
                    fileIn.close();
                }
            }
        }
    }
}

