/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.util;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XmlEntityConvertUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public String entityToXml(Object object) {
        String xmlStr = "";
        try {
            if (object != null) {
                Annotation[] aos = object.getClass().getAnnotations();
                Boolean bol = false;
                for (Annotation ao : aos) {
                    if (!ao.annotationType().equals(XmlRootElement.class)) continue;
                    bol = true;
                    break;
                }
                if (bol.booleanValue()) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
                    Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                    jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                    StringWriter writer = new StringWriter();
                    jaxbMarshaller.marshal(object, (Writer)writer);
                    xmlStr = writer.toString().replaceAll("\\s*standalone=\"yes\"", "");
                }
            }
        }
        catch (Exception e) {
            this.logger.error("errorMsg:", (Throwable)e);
        }
        return xmlStr;
    }

    public Object xmlToEntity(Class clazz, InputStream respondStream) {
        Object entity = null;
        try {
            if (clazz != null) {
                Annotation[] aos = clazz.getAnnotations();
                Boolean bol = false;
                for (Annotation ao : aos) {
                    if (!ao.annotationType().equals(XmlRootElement.class)) continue;
                    bol = true;
                    break;
                }
                if (bol.booleanValue()) {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    Unmarshaller um = jaxbContext.createUnmarshaller();
                    entity = um.unmarshal(respondStream);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("errorMsg:", (Throwable)e);
        }
        return entity;
    }
}

