/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.util;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SshUtils {
    private static final Logger logger = LoggerFactory.getLogger(SshUtils.class);

    public static List<String> exeSessionCmd(String hostname, String username, String password, int port, List<String> cmds, String startFlag, String endFlag) {
        LinkedList res = Lists.newLinkedList();
        Assert.hasLength((String)endFlag, (String)"Cannot query empty endFlag.");
        Assert.notEmpty(cmds, (String)"Cannot invoke empty cmds.");
        try {
            String line;
            Connection conn = new Connection(hostname, port);
            conn.connect();
            boolean isAuthenticated = conn.authenticateWithPassword(username, password);
            if (!isAuthenticated) {
                throw new IOException("Authentication failed.");
            }
            Session sess = conn.openSession();
            sess.requestPTY("bash");
            sess.startShell();
            PrintWriter out = new PrintWriter(sess.getStdin());
            cmds.forEach(s -> out.println((String)s));
            out.close();
            StreamGobbler stdout = new StreamGobbler(sess.getStdout());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stdout));
            boolean saveData = false;
            while (!((line = br.readLine()) == null || saveData && line.contains(endFlag))) {
                if (saveData) {
                    res.add(line);
                } else if (StringUtils.isEmpty((Object)startFlag) || line.contains(startFlag)) {
                    saveData = true;
                    continue;
                }
                logger.debug(line);
            }
            System.out.println("ExitCode: " + sess.getExitStatus());
            sess.close();
            conn.close();
        }
        catch (IOException e) {
            logger.error("exeSessionCmd", (Throwable)e);
        }
        return res;
    }

    public static String exeSystemCmd(String hostname, String username, String password, int port, String cmd) {
        Assert.hasLength((String)cmd, (String)"Cannot invoke empty cmd.");
        try {
            Connection conn = new Connection(hostname, port);
            conn.connect();
            boolean isAuthenticated = conn.authenticateWithPassword(username, password);
            if (!isAuthenticated) {
                throw new IOException("Authentication failed.");
            }
            Session sess = conn.openSession();
            sess.execCommand(cmd);
            StreamGobbler stdout = new StreamGobbler(sess.getStdout());
            String result = IOUtils.toString((InputStream)stdout, (Charset)StandardCharsets.UTF_8);
            System.out.println("ExitCode: " + sess.getExitStatus());
            sess.close();
            conn.close();
            return result;
        }
        catch (IOException e) {
            logger.error("exeSystemCmd", (Throwable)e);
            return null;
        }
    }
}

