/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.util;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static OkHttpClient okHttpClient = new OkHttpClient.Builder().retryOnConnectionFailure(false).connectionPool(new ConnectionPool(5, 5L, TimeUnit.MINUTES)).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();

    public static StringBuffer getQueryString(String url, Map<String, String> queries) {
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            boolean firstFlag = true;
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (firstFlag) {
                    sb.append("?" + entry.getKey() + "=" + entry.getValue());
                    firstFlag = false;
                    continue;
                }
                sb.append("&" + entry.getKey() + "=" + entry.getValue());
            }
        }
        return sb;
    }

    private static String execNewCall(Request request) {
        try (Response response = null;){
            response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            try {
                throw new IllegalStateException(response.body().string());
            }
            catch (Exception e) {
                logger.error("okhttp3 put error >> ex = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    public static String get(String url, Map<String, String> queries, String authorizationHeader) {
        StringBuffer sb = HttpUtils.getQueryString((String)url, queries);
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Accept", "application/json");
        builder.addHeader("Content-Type", "application/json");
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).build();
        return HttpUtils.execNewCall((Request)request);
    }

    public static String delete(String url, String jsonParams, Map<String, String> queries, String authorizationHeader) {
        StringBuffer sb = HttpUtils.getQueryString((String)url, queries);
        RequestBody requestBody = null;
        if (StringUtils.isNotBlank((CharSequence)jsonParams)) {
            requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        }
        Request.Builder builder = new Request.Builder();
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).delete(requestBody).build();
        return HttpUtils.execNewCall((Request)request);
    }

    public static String put(String url, String jsonParams, Map<String, String> queries, String authorizationHeader) {
        StringBuffer sb = HttpUtils.getQueryString((String)url, queries);
        RequestBody requestBody = null;
        requestBody = StringUtils.isNotBlank((CharSequence)jsonParams) ? RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams) : RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        Request.Builder builder = new Request.Builder();
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).put(requestBody).build();
        return HttpUtils.execNewCall((Request)request);
    }

    public static String post(String url, String jsonParams, Map<String, String> queries, String authorizationHeader) {
        StringBuffer sb = HttpUtils.getQueryString((String)url, queries);
        RequestBody requestBody = null;
        requestBody = StringUtils.isNotBlank((CharSequence)jsonParams) ? RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams) : RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)"");
        Request.Builder builder = new Request.Builder();
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            builder.addHeader("Authorization", authorizationHeader);
        }
        Request request = builder.url(sb.toString()).post(requestBody).build();
        return HttpUtils.execNewCall((Request)request);
    }

    public static String postFormParams(String url, Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        if (params != null && params.keySet().size() > 0) {
            for (String key : params.keySet()) {
                builder.add(key, params.get(key));
            }
        }
        Request request = new Request.Builder().url(url).post((RequestBody)builder.build()).build();
        return HttpUtils.execNewCall((Request)request);
    }

    public static String postJsonParams(String url, String jsonParams) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return HttpUtils.execNewCall((Request)request);
    }

    public static String postXmlParams(String url, String xml) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xml);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return HttpUtils.execNewCall((Request)request);
    }
}

