/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.util;

import cn.gtmap.gtc.chain.domain.AuthUserDetails;
import cn.gtmap.gtc.chain.property.FabricPeerInfo;
import cn.gtmap.gtc.chain.property.FabricPeerProperties;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class BaseUtils {
    private static final Logger log = LoggerFactory.getLogger(BaseUtils.class);

    public static String getLikeString(String str) {
        if (str == null) {
            return "";
        }
        String s = str.trim();
        char[] chars = new char[s.length() + 2];
        s.getChars(0, s.length(), chars, 1);
        chars[0] = 37;
        chars[chars.length - 1] = 37;
        return new String(chars);
    }

    public static String generalCountSql(String sql) {
        StringBuilder builder = new StringBuilder("select count(*) from (");
        builder.append(sql);
        builder.append(") count_sql");
        return builder.toString();
    }

    public static String generalInStringListSql(List<String> ids) {
        if (null != ids && !ids.isEmpty()) {
            StringBuilder builder = new StringBuilder(" (");
            for (String id : ids) {
                builder.append("'");
                builder.append(id);
                builder.append("'");
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(") ");
            return builder.toString();
        }
        return "";
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIGKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String getRandomLower(int length) {
        String str = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(36);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String generateList2String(Collection<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String temp : list) {
            sb.append(temp).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String decodeBase64(String str) {
        Base64.Decoder decoder = Base64.getDecoder();
        String result = "";
        try {
            if (str.contains("=?GB2312?B?")) {
                String[] strArr = str.split(" ");
                List<String> list = Arrays.asList(strArr);
                str = list.stream().map(p -> StringUtils.substringBefore((String)StringUtils.substringAfter((String)p, (String)"=?GB2312?B?"), (String)"?=")).collect(Collectors.joining());
            }
            result = new String(decoder.decode(str), "GBK");
        }
        catch (Exception e) {
            log.warn("decodeBase64", (Throwable)e);
        }
        return result;
    }

    public static String[] splitExtension(String str) {
        String[] array = new String[2];
        if (StringUtils.isEmpty((String)str)) {
            array[0] = "";
            array[1] = "";
            return array;
        }
        if (str.indexOf(46) < 0) {
            array[0] = str;
            array[1] = "";
            return array;
        }
        array[0] = str.substring(0, str.lastIndexOf(46));
        array[1] = str.substring(str.lastIndexOf(46));
        return array;
    }

    public static String[] parseExtension(String fileName) {
        if (fileName.indexOf(46) > -1) {
            String[] array = new String[2];
            int dotIndex = fileName.lastIndexOf(46);
            array[0] = fileName.substring(0, dotIndex);
            array[1] = fileName.substring(dotIndex + 1);
            return array;
        }
        return new String[]{fileName, ""};
    }

    public static boolean isInteger(String str) {
        String regExp = "^[1-9][0-9]*$";
        Pattern pattern = Pattern.compile(regExp);
        return pattern.matcher(str).matches();
    }

    public static String getRequestParam(HttpServletRequest request, String key) {
        String[] urls;
        if (null == request && null != RequestContextHolder.getRequestAttributes() && RequestContextHolder.getRequestAttributes() instanceof ServletRequestAttributes) {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            request = attributes.getRequest();
        }
        if (null == request) {
            return null;
        }
        Map parameterMap = request.getParameterMap();
        if (!CollectionUtils.isEmpty((Map)parameterMap) && (urls = (String[])parameterMap.get(key)) != null && urls.length > 0 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)urls[0])) {
            return urls[0];
        }
        return null;
    }

    public static FabricPeerInfo getFabricPeerInfo(FabricPeerProperties fabricPeerProperties, Authentication authentication) {
        if (authentication.getPrincipal() instanceof AuthUserDetails) {
            AuthUserDetails userDetails = (AuthUserDetails)authentication.getPrincipal();
            if (!CollectionUtils.isEmpty((Collection)fabricPeerProperties.getPeers())) {
                for (FabricPeerInfo info : fabricPeerProperties.getPeers()) {
                    if (!info.getUrl().contains(userDetails.getPeerServer())) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public static String getOauth2Header(String accessToken) {
        return StringUtils.isNotBlank((String)accessToken) ? "bearer ".concat(accessToken) : null;
    }
}

