/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.service.impl;

import cn.gtmap.estateplat.model.exchange.national.MessageModel;
import cn.gtmap.gtc.bc.domain.dto.ChainOptionDTO;
import cn.gtmap.gtc.chain.property.XsdConfigInfo;
import cn.gtmap.gtc.chain.service.XsdCheckService;
import cn.gtmap.gtc.chain.util.FileUtil;
import cn.gtmap.gtc.chain.util.RsaUtil;
import cn.gtmap.gtc.chain.util.XmlEntityConvertUtil;
import cn.gtmap.gtc.chain.util.XmlUtil;
import cn.gtmap.gtc.chain.util.XmlValidateResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class XsdCheckServiceImpl
implements XsdCheckService,
ErrorHandler {
    public static final Logger logger = LoggerFactory.getLogger(XsdCheckServiceImpl.class);
    private static boolean xsd = false;
    public static final Map<String, String> XSDINFOS_BDCDYH = new HashMap();
    public static final Map<String, String> XSDINFOS_NOBDCDYH = new HashMap();
    @Autowired
    private XsdConfigInfo xsdConfigInfo;
    @Autowired
    private XmlEntityConvertUtil xmlEntityConvertUtil;
    private String ERRORMSG = "";
    private Map<String, String> tableList = Maps.newHashMap();
    private String[] lwfield = new String[]{"SJID", "BDCQZHJC", "QLRID", "YWRDH", "QLRDH"};
    private String[] lwtablefield = new String[]{"ZTT_GY_QLR.YWH"};
    private String[] datefield = new String[]{"SHJSSJ", "DJSJ", "JSSJ", "SLSJ", "SZSJ", "SJSJ", "TDSYJSSJ", "TDSYQSSJ", "SHKSSJ", "SHJSSJ", "JGRQ", "ZWLXJSSJ", "ZWLXQSSJ", "ZXSJ", "SYQJSSJ", "SYQQSSJ", "CREATEDATE", "GDSJ", "CreateDate"};
    private String[] lwkey = new String[]{"ZD_K_103"};

    public XsdCheckServiceImpl() {
        this.tableList.put("ZTT_GY_QLR", "zttGyQlrList");
        this.tableList.put("KTT_ZDJBXX", "kttZdjbxxList");
        this.tableList.put("KTF_ZDBHQK", "ktfZdbhqkList");
        this.tableList.put("KTT_ZHJBXX", "kttZhjbxxList");
        this.tableList.put("KTF_ZH_YHZK", "ktfZhYhzkList");
        this.tableList.put("KTF_ZH_YHYDZB", "ktfZhYhydzbList");
        this.tableList.put("KTF_ZHBHQK", "ktfZhbhqkList");
        this.tableList.put("KTT_FW_ZRZ", "kttFwZrzList");
        this.tableList.put("KTT_FW_LJZ", "kttFwLjzList");
        this.tableList.put("KTT_FW_C", "kttFwCList");
        this.tableList.put("KTT_FW_H", "kttFwHList");
        this.tableList.put("KTT_GZW", "kttGzwList");
        this.tableList.put("KTT_GY_JZX", "kttGyJzxList");
        this.tableList.put("KTT_GY_JZD", "kttGyJzdList");
        this.tableList.put("ZD_K_103", "zdKList");
        this.tableList.put("QLT_FW_FDCQ_DZ", "qltFwFdcqDzList");
        this.tableList.put("QLF_FW_FDCQ_DZ_XM", "qlfFwFdcqDzXmList");
        this.tableList.put("QLT_FW_FDCQ_YZ", "qltFwFdcqYzList");
        this.tableList.put("QLF_FW_FDCQ_QFSYQ", "qlfFwFdcqQfsyqList");
        this.tableList.put("QLF_QL_HYSYQ", "qlfQlHysyqList");
        this.tableList.put("QLT_QL_GJZWSY", "qltQlGjzwsyqList");
        this.tableList.put("QLF_QL_NYDSYQ", "qlfQlNydsyqList");
        this.tableList.put("QLT_QL_LQ", "qltQlLqList");
        this.tableList.put("QLF_QL_ZXDJ", "qlfQlZxdjList");
        this.tableList.put("QLF_QL_YYDJ", "qlfQlYydjList");
        this.tableList.put("QLF_QL_YGDJ", "qlfQlYgdjList");
        this.tableList.put("QLF_QL_CFDJ", "qlfQlCfdjList");
        this.tableList.put("QLF_QL_DYAQ", "qlfQlDyaqList");
        this.tableList.put("QLF_QL_DYIQ", "qlfQlDyiqList");
        this.tableList.put("QLF_QL_JSYDSY", "qlfQlJsydsyqList");
        this.tableList.put("QLF_QL_TDSYQ", "qlfQlTdsyqList");
        this.tableList.put("DJT_DJ_SLSQ", "djtDjSlsqList");
        this.tableList.put("DJF_DJ_SJ", "djfDjSjList");
        this.tableList.put("DJF_DJ_SF", "djfDjSfList");
        this.tableList.put("DJF_DJ_SH", "djfDjShList");
        this.tableList.put("DJF_DJ_SZ", "djfDjSzList");
        this.tableList.put("DJF_DJ_FZ", "djfDjFzList");
        this.tableList.put("DJF_DJ_GD", "djfDjGdList");
        this.tableList.put("DJF_DJ_SQR", "djfDjSqrList");
        this.tableList.put("FJ_F_100", "fjFList");
    }

    public boolean dataXsdCheck(ChainOptionDTO chainOptionDTO) {
        MessageModel messageModel = (MessageModel)JSON.parseObject((String)((String)chainOptionDTO.getArgs().get(0)), MessageModel.class);
        JSONObject returnJSON = JSON.parseObject((String)((String)chainOptionDTO.getArgs().get(0)));
        JSONObject qkljson = JSON.parseObject((String)JSON.toJSONString((Object)messageModel));
        if (StringUtils.equals((String)chainOptionDTO.getFuncName(), (String)this.xsdConfigInfo.getFunction()) && StringUtils.equals((String)chainOptionDTO.getChannelId(), (String)this.xsdConfigInfo.getChannel()) && StringUtils.equals((String)chainOptionDTO.getChainCodeId(), (String)this.xsdConfigInfo.getChaincode())) {
            Long MsgID = Long.parseLong(new DateTime().toString("yyyyMMdd") + "0000");
            String BizMsgID = "";
            messageModel.getHeadModel().setBizMsgID(messageModel.getHeadModel().getAreaCode() + MsgID);
            String xml = this.xmlEntityConvertUtil.entityToXml((Object)messageModel);
            xml = RsaUtil.setRsaSign((String)xml);
            System.out.println("-------------------xml:" + xml);
            boolean xsdflag = false;
            try {
                String retype = XmlUtil.getTextByXpath((String)"/Message/Head/RecType", (String)xml);
                boolean flag = XsdCheckServiceImpl.isXML((String)xml);
                if (flag) {
                    String estateNum;
                    if (!xsd) {
                        this.initXSDResource();
                    }
                    String xsdString = "";
                    xsdString = this.xsdConfigInfo.getNoBdcdyhXsdCheckEnable().booleanValue() ? (xml.contains("<EstateNum>") ? (StringUtils.isNotBlank((String)(estateNum = XmlUtil.getTextByXpath((String)"/Message/Head/EstateNum", (String)xml))) ? (String)XSDINFOS_BDCDYH.get(retype) : (String)XSDINFOS_NOBDCDYH.get(retype)) : (String)XSDINFOS_NOBDCDYH.get(retype)) : (String)XSDINFOS_BDCDYH.get(retype);
                    XmlValidateResult result = this.checkXmlByXsd(xml, xsdString);
                    xsdflag = result.isValidated();
                    returnJSON.put("Checkcode", (Object)result.getErrorMsg());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList args = Lists.newArrayList();
            args.add(returnJSON.toJSONString());
            chainOptionDTO.setArgs((List)args);
            return xsdflag;
        }
        return true;
    }

    private String stdFieldValue(String key, String fieldvalue) {
        for (String item : this.datefield) {
            if (!StringUtils.equals((String)key, (String)item)) continue;
            Long timeStamp = Long.parseLong(fieldvalue) / 1000L;
            Date timeArray = new Date(timeStamp);
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timeArray).replaceAll(" ", "T");
        }
        return fieldvalue;
    }

    private boolean checkKeyInList(String key, String[] list) {
        for (String keyItem : list) {
            if (!StringUtils.equals((String)key, (String)keyItem)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> setParam(String key, String value) {
        HashMap param = Maps.newHashMap();
        param.put(key, value);
        return param;
    }

    private String firstUpper(String str) {
        str = str.substring(0, 1).toUpperCase() + str.substring(1);
        return str;
    }

    private String createXmlToString(Document document) {
        String xmlString = null;
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("doctype-public", "");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(document);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            transformer.transform(domSource, new StreamResult(bos));
            xmlString = bos.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    private void initXSDResource() throws UnsupportedEncodingException {
        List files = FileUtil.getXSDFiles((String)this.xsdConfigInfo.getXsdPathBdcdyh());
        if (this.xsdConfigInfo.getNoBdcdyhXsdCheckEnable().booleanValue()) {
            List noBdcdyhFiles = FileUtil.getXSDFiles((String)this.xsdConfigInfo.getXsdPathNoBdcdyh());
            Boolean bdcdyhXsd = false;
            if (!CollectionUtils.isEmpty((Collection)files)) {
                bdcdyhXsd = true;
                for (Object file : files) {
                    String name = ((File)file).getName().split("\\.")[0];
                    String content = this.getFileByByte((File)file);
                    XSDINFOS_BDCDYH.put(name, content);
                }
            } else {
                bdcdyhXsd = false;
                logger.info("\u6709\u4e0d\u52a8\u4ea7\u5355\u5143\u53f7\u7684xsd\u6587\u4ef6\u5939\u4e3a\u7a7a");
            }
            Boolean noBdcdyhXsd = false;
            if (!CollectionUtils.isEmpty((Collection)noBdcdyhFiles)) {
                noBdcdyhXsd = true;
                for (File file : noBdcdyhFiles) {
                    String name = file.getName().split("\\.")[0];
                    String content = this.getFileByByte(file);
                    XSDINFOS_NOBDCDYH.put(name, content);
                }
            } else {
                noBdcdyhXsd = false;
                logger.info("\u65e0\u4e0d\u52a8\u4ea7\u5355\u5143\u53f7\u7684xsd\u6587\u4ef6\u5939\u4e3a\u7a7a");
            }
            xsd = bdcdyhXsd.booleanValue() && noBdcdyhXsd.booleanValue();
        } else if (!CollectionUtils.isEmpty((Collection)files)) {
            xsd = true;
            for (File file : files) {
                String name = file.getName().split("\\.")[0];
                String content = this.getFileByByte(file);
                XSDINFOS_BDCDYH.put(name, content);
            }
        } else {
            xsd = false;
            logger.info("xsd\u6587\u4ef6\u5939\u4e3a\u7a7a");
        }
    }

    private String getFileByByte(File file) throws UnsupportedEncodingException {
        byte[] fileBytes = new byte[]{};
        fileBytes = FileUtil.getBytes((File)file);
        String encodeType = "";
        try {
            encodeType = XsdCheckServiceImpl.getEncodeStr((String)file.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)encodeType, (CharSequence)"UTF8")) {
            String str = "";
            try {
                XsdCheckServiceImpl.deleteUTF8BOM((File)file);
                file.renameTo(file);
                str = XsdCheckServiceImpl.readFile2String((File)file, (String)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return str;
        }
        return new String(fileBytes, "UTF-8");
    }

    public static void deleteUTF8BOM(File file) throws Exception {
        byte[] bom = new byte[]{-17, -69, -65};
        byte[] fileByte = FileUtils.readFileToByteArray((File)file);
        if (fileByte != null && fileByte.length >= 3 && fileByte[0] == bom[0] && fileByte[1] == bom[1] && fileByte[2] == bom[2]) {
            FileUtils.writeByteArrayToFile((File)file, (byte[])Arrays.copyOfRange(fileByte, 3, fileByte.length));
        }
    }

    public static String readFile2String(File file, String encoding) {
        String data = null;
        try {
            data = FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEncodeStr(String fullFileName) {
        String encodeType = "";
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(fullFileName));
            byte[] head = new byte[3];
            bis.read(head);
            if (head[0] == -17 && head[1] == -69 && head[2] == -65) {
                encodeType = "UTF8";
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728:{}", (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error("io\u89e3\u6790\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error("io\u89e3\u6790\u5f02\u5e38:{}", (Object)e.getMessage());
                }
            }
        }
        return encodeType;
    }

    public XmlValidateResult checkXmlByXsd(String xmlStr, String xsdStr) {
        this.ERRORMSG = "";
        XmlValidateResult vs = new XmlValidateResult();
        String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory schemaFactory = SchemaFactory.newInstance(schemaLanguage);
        try {
            BufferedReader xsdReader = new BufferedReader(new StringReader(xsdStr));
            StreamSource xsdSource = new StreamSource(xsdReader);
            ByteArrayInputStream inputSource = new ByteArrayInputStream(xmlStr.getBytes(Charset.forName("UTF-8")));
            StreamSource source = new StreamSource(inputSource);
            Schema schema = schemaFactory.newSchema(xsdSource);
            Validator validator = schema.newValidator();
            validator.setErrorHandler((ErrorHandler)this);
            validator.validate(source);
            vs.setValidated(true);
        }
        catch (SAXException e) {
            logger.error("error:", (Throwable)e);
            vs.setErrorMsg(e.getMessage());
            vs.setValidated(false);
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            vs.setErrorMsg(e.getMessage());
            vs.setValidated(false);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.ERRORMSG)) {
            vs.setErrorMsg(this.ERRORMSG);
            vs.setValidated(false);
        }
        return vs;
    }

    public static boolean isXML(String value) {
        try {
            DocumentHelper.parseText((String)value);
        }
        catch (DocumentException e) {
            logger.error("\u6821\u9a8cxml\u6587\u4ef6\u683c\u5f0f\u5f02\u5e38\uff01{}", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.ERRORMSG = this.ERRORMSG.length() < 1000000 ? this.ERRORMSG + "\u8b66\u544a\uff1a" + exception + "\n" : this.ERRORMSG + "\u63d0\u793a\uff1a\u9519\u8bef\u4fe1\u606f\u8fc7\u957f\uff0c\u6b64\u5904\u5ffd\u7565......\n";
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.ERRORMSG = this.ERRORMSG.length() < 1000000 ? this.ERRORMSG + "\u9519\u8bef\uff1a" + exception + "\n" : this.ERRORMSG + "\u63d0\u793a\uff1a\u9519\u8bef\u4fe1\u606f\u8fc7\u957f\uff0c\u6b64\u5904\u5ffd\u7565......\n";
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.ERRORMSG = this.ERRORMSG.length() < 1000000 ? this.ERRORMSG + "\u4e25\u91cd\uff1a" + exception + "\n" : this.ERRORMSG + "\u63d0\u793a\uff1a\u9519\u8bef\u4fe1\u606f\u8fc7\u957f\uff0c\u6b64\u5904\u5ffd\u7565......\n";
    }
}

