/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.service.impl;

import cn.gtmap.gtc.bc.domain.enums.ChainCodeDeployStatus;
import cn.gtmap.gtc.bc.domain.vo.ChainCodeVO;
import cn.gtmap.gtc.chain.builder.ChainCodeBuilder;
import cn.gtmap.gtc.chain.domain.AuthUserDetails;
import cn.gtmap.gtc.chain.property.FabricPeerInfo;
import cn.gtmap.gtc.chain.property.FabricPeerProperties;
import cn.gtmap.gtc.chain.service.ShellManageService;
import cn.gtmap.gtc.chain.util.BaseUtils;
import cn.gtmap.gtc.chain.util.FileUtils;
import cn.gtmap.gtc.chain.util.SshUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ShellManageServiceImpl
implements ShellManageService {
    public static final String DOCKER_CLI = "docker exec -it cli bash";
    public static final String LOCAL_GO_PATH = "/opt/gopath/src/";
    public static final String LOCAL_GO_FILE_PATH = "/opt/gopath/src/".concat("%s-%s");
    public static final String LOCAL_GO_MATE_INFO_FULL_PATH = LOCAL_GO_FILE_PATH.concat("/MATE-INF/statedb/couchdb/indexes");
    public static final String STATUS_SUFFIX = ".status";
    @Autowired
    private FabricPeerProperties fabricPeerProperties;

    public List<String> listChannel(Authentication authentication) {
        FabricPeerInfo peerInfo = BaseUtils.getFabricPeerInfo((FabricPeerProperties)this.fabricPeerProperties, (Authentication)authentication);
        LinkedList cmds = Lists.newLinkedList();
        cmds.add(DOCKER_CLI);
        cmds.add("peer channel list");
        cmds.add("exit");
        return SshUtils.exeSessionCmd((String)((AuthUserDetails)authentication.getPrincipal()).getPeerServer(), (String)peerInfo.getShhUser(), (String)peerInfo.getShhPwd(), (int)peerInfo.getShhPort(), (List)cmds, (String)"Channels peers has joined", (String)"peer#");
    }

    public List<ChainCodeVO> listLocalChainCode(Authentication authentication, String channelName, String chainCodeName) {
        File[] fs;
        String goPath = LOCAL_GO_PATH;
        Path location = Paths.get(goPath, new String[0]);
        if (location.toFile().exists() && (fs = location.toFile().listFiles()) != null) {
            LinkedList vos = Lists.newLinkedList();
            for (File f : fs) {
                if (!f.isDirectory()) continue;
                ChainCodeVO chainCodeVO = new ChainCodeVO();
                String name = f.getName();
                String[] names = name.split("-");
                chainCodeVO.setName(names[0]);
                if (names.length > 1) {
                    chainCodeVO.setVersion(names[1]);
                }
                chainCodeVO.setPath(f.getAbsolutePath());
                File[] files = f.listFiles();
                if (files != null) {
                    for (File file : files) {
                        ChainCodeDeployStatus status;
                        if (!file.getName().contains(STATUS_SUFFIX) || (status = ChainCodeDeployStatus.enumValue((String)file.getName().replace(STATUS_SUFFIX, ""))) == null) continue;
                        chainCodeVO.setStatus(status.remark());
                    }
                }
                vos.add(chainCodeVO);
            }
            return vos;
        }
        return Collections.emptyList();
    }

    public List<ChainCodeVO> listRemoteChainCode(Authentication authentication, String channelName, String chainCodeName) {
        String queryRes;
        FabricPeerInfo peerInfo = BaseUtils.getFabricPeerInfo((FabricPeerProperties)this.fabricPeerProperties, (Authentication)authentication);
        LinkedList cmds = Lists.newLinkedList();
        cmds.add(DOCKER_CLI);
        String query = "peer chaincode list";
        if (!StringUtils.isEmpty((Object)channelName)) {
            query = query.concat(" --instantiated -C ").concat(channelName);
            queryRes = "Get instantiated chaincodes on channel";
        } else {
            query = query.concat(" --installed");
            queryRes = "Get installed chaincodes on peer";
        }
        cmds.add(query);
        cmds.add("exit");
        List res = SshUtils.exeSessionCmd((String)((AuthUserDetails)authentication.getPrincipal()).getPeerServer(), (String)peerInfo.getShhUser(), (String)peerInfo.getShhPwd(), (int)peerInfo.getShhPort(), (List)cmds, (String)queryRes, (String)"peer#");
        return ChainCodeBuilder.buildVoList((List)res);
    }

    public String catRemoteCode(Authentication authentication, String path, String chainCodeName) {
        FabricPeerInfo peerInfo = BaseUtils.getFabricPeerInfo((FabricPeerProperties)this.fabricPeerProperties, (Authentication)authentication);
        path = LOCAL_GO_PATH.concat(path).concat("/").concat(chainCodeName).concat(".go");
        return SshUtils.exeSystemCmd((String)((AuthUserDetails)authentication.getPrincipal()).getPeerServer(), (String)peerInfo.getShhUser(), (String)peerInfo.getShhPwd(), (int)peerInfo.getShhPort(), (String)("cat " + path));
    }

    public String catLocalCode(Authentication authentication, String path, String chainCodeName) throws IOException {
        Path location = Paths.get(path, new String[0]);
        Path loc = location.resolve(chainCodeName.concat(".go"));
        if (loc.toFile().exists()) {
            FileInputStream inputStream = new FileInputStream(loc.toFile());
            String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return result;
        }
        return null;
    }

    public boolean chainCodeUpload(String chainCodeName, String version, MultipartFile[] files) throws IOException {
        if (files == null || files.length != 2) {
            throw new IllegalArgumentException("need two files .json and .go");
        }
        String goPath = LOCAL_GO_PATH.concat(chainCodeName).concat("-").concat(version);
        Path location = Paths.get(goPath, new String[0]);
        FileUtils.createDir((Path)location);
        File[] fs = location.toFile().listFiles();
        if (fs != null) {
            for (File f : fs) {
                if (!f.getName().contains(STATUS_SUFFIX)) continue;
                if (!f.getName().contains(ChainCodeDeployStatus.UPLOAD.value()) && !f.getName().contains(ChainCodeDeployStatus.ENCODE.value())) {
                    throw new IllegalArgumentException("chaincode has" + f.getName());
                }
                f.delete();
            }
        }
        String metePath = goPath.concat("/").concat("MATE-INF/statedb/couchdb/indexes");
        Path mateInfo = Paths.get(metePath, new String[0]);
        FileUtils.createDir((Path)mateInfo);
        for (MultipartFile file : files) {
            Path loc;
            if (file.getOriginalFilename().contains(".go")) {
                loc = location.resolve(chainCodeName.concat(".go"));
                Files.copy(file.getInputStream(), loc, new CopyOption[0]);
                continue;
            }
            if (!file.getOriginalFilename().contains(".json")) continue;
            loc = mateInfo.resolve(chainCodeName.concat(".json"));
            Files.copy(file.getInputStream(), loc, new CopyOption[0]);
        }
        return true;
    }

    private String getZipWritePath() throws IOException {
        Path tempPath = Paths.get("/opt/gopath/zip/".concat(UUID.randomUUID().toString()), new String[0]);
        FileUtils.createDir((Path)tempPath);
        return tempPath.toAbsolutePath().toString();
    }

    public ResponseEntity localChainCodeDownload(String path) throws IOException {
        Path location = Paths.get(path, new String[0]);
        if (location.toFile().exists()) {
            String zipName = location.toFile().getName();
            String zipPath = FileUtils.commonZip((String)location.toAbsolutePath().toString(), (String)zipName);
            Path zipFile = Paths.get(zipPath, new String[0]);
            byte[] bytes = null;
            if (zipFile.toFile().exists()) {
                bytes = Files.readAllBytes(zipFile);
            }
            zipFile.toFile().delete();
            String fileName = new String(zipName.getBytes("UTF-8"), "ISO-8859-1");
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + fileName.concat(".zip") + "\""})).lastModified(new Date().getTime())).contentLength((long)bytes.length).contentType(MediaType.parseMediaType((String)"application/zip")).body((Object)bytes);
        }
        return ResponseEntity.noContent().build();
    }
}

