/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.service.impl;

import cn.gtmap.gtc.bc.domain.dto.ChainConnectDTO;
import cn.gtmap.gtc.bc.domain.dto.ChainOptionDTO;
import cn.gtmap.gtc.bc.domain.po.HFUser;
import cn.gtmap.gtc.bc.domain.qo.ChainPageable;
import cn.gtmap.gtc.chain.domain.AuthUserDetails;
import cn.gtmap.gtc.chain.exception.BlockChainException;
import cn.gtmap.gtc.chain.property.FabricAccountProperties;
import cn.gtmap.gtc.chain.property.FabricClientProperties;
import cn.gtmap.gtc.chain.property.FabricPeerInfo;
import cn.gtmap.gtc.chain.property.FabricPeerProperties;
import cn.gtmap.gtc.chain.service.FabricService;
import cn.gtmap.gtc.chain.service.XsdCheckService;
import cn.gtmap.gtc.chain.util.BaseUtils;
import cn.gtmap.gtc.chain.util.FabricUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hyperledger.fabric.sdk.ChaincodeID;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.Orderer;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.QueryByChaincodeRequest;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric_ca.sdk.HFCAClient;
import org.hyperledger.fabric_ca.sdk.RegistrationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FabricServiceImpl
implements FabricService {
    private static final Logger logger = LoggerFactory.getLogger(FabricService.class);
    @Autowired
    private FabricAccountProperties accountProperties;
    @Autowired
    private FabricClientProperties clientProperties;
    @Autowired
    private FabricPeerProperties fabricPeerProperties;
    @Autowired
    private XsdCheckService xsdCheckService;
    private Map<String, HFCAClient> hfcaClientMap = new ConcurrentHashMap();
    private Map<String, HFClient> hfClientMap = new ConcurrentHashMap();

    public String invokeBlockChain(ChainOptionDTO hfRequestBody) throws Exception {
        try {
            boolean bl = this.xsdCheckService.dataXsdCheck(hfRequestBody);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HFClient hfClient = this.initClient(hfRequestBody);
        Channel channel = hfClient.getChannel(hfRequestBody.getChannelId());
        TransactionProposalRequest req = hfClient.newTransactionProposalRequest();
        ChaincodeID cid = ChaincodeID.newBuilder().setName(hfRequestBody.getChainCodeId()).build();
        req.setChaincodeID(cid);
        req.setFcn(hfRequestBody.getFuncName());
        req.setChaincodeVersion(hfRequestBody.getChainCodeVersion());
        if (hfRequestBody.getArgs().size() > 0) {
            String[] strings = new String[hfRequestBody.getArgs().size()];
            req.setArgs(hfRequestBody.getArgs().toArray(strings));
        }
        Collection resps = channel.sendTransactionProposal(req);
        channel.sendTransaction(resps);
        return this.conventResponse(resps);
    }

    private String conventResponse(Collection<ProposalResponse> resps) throws InvalidArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        for (ProposalResponse resp : resps) {
            if (resp.getStatus() == ChaincodeResponse.Status.SUCCESS) {
                String payload = new String(resp.getChaincodeActionResponsePayload());
                logger.debug(String.format("[\u221a] Got success response from peer %s => payload: %s", resp.getPeer().getName(), payload));
                stringBuffer.append(payload);
                continue;
            }
            String status = resp.getStatus().toString();
            String msg = resp.getMessage();
            logger.warn(String.format("[\u00d7] Got failed response from peer %s => %s: %s ", resp.getPeer().getName(), status, msg));
            throw new BlockChainException(msg);
        }
        return stringBuffer.toString();
    }

    public String queryBlockChain(ChainOptionDTO hfRequestBody) throws Exception {
        HFClient hfClient = this.initClient(hfRequestBody);
        Channel channel = hfClient.getChannel(hfRequestBody.getChannelId());
        QueryByChaincodeRequest qpr = hfClient.newQueryProposalRequest();
        ChaincodeID fabcarCCId = ChaincodeID.newBuilder().setName(hfRequestBody.getChainCodeId()).build();
        qpr.setChaincodeID(fabcarCCId);
        qpr.setFcn(hfRequestBody.getFuncName());
        qpr.setChaincodeVersion(hfRequestBody.getChainCodeVersion());
        if (hfRequestBody.getArgs().size() > 0) {
            String[] strings = new String[hfRequestBody.getArgs().size()];
            qpr.setArgs(hfRequestBody.getArgs().toArray(strings));
        }
        Collection ress = channel.queryByChaincode(qpr);
        return this.conventResponse(ress);
    }

    public String pageQuery(Authentication authentication, ChainPageable chainPageable) throws Exception {
        ChainOptionDTO hfRequestBody = new ChainOptionDTO();
        BeanUtils.copyProperties((Object)chainPageable, (Object)hfRequestBody);
        ArrayList args = Lists.newArrayList();
        args.add(chainPageable.getSelector());
        if (chainPageable.getSize() == null) {
            args.add("10");
        } else {
            args.add(chainPageable.getSize().toString());
        }
        if (chainPageable.getBookmark() == null) {
            args.add("");
        } else {
            args.add(chainPageable.getBookmark());
        }
        hfRequestBody.setArgs((List)args);
        FabricPeerInfo fabricPeerInfo = BaseUtils.getFabricPeerInfo((FabricPeerProperties)this.fabricPeerProperties, (Authentication)authentication);
        if (fabricPeerInfo != null && hfRequestBody.getChainConnectDTO() == null) {
            ChainConnectDTO connectDTO = new ChainConnectDTO();
            BeanUtils.copyProperties((Object)this.clientProperties, (Object)connectDTO);
            AuthUserDetails userDetails = (AuthUserDetails)authentication.getPrincipal();
            connectDTO.setPeerName(fabricPeerInfo.getName()).setPeerServer(fabricPeerInfo.getUrl()).setUserId(userDetails.getUsername()).setSecret(userDetails.getPassword()).setOrgName(userDetails.getOrgName()).setOrgMsp(userDetails.getOrgMsp());
            hfRequestBody.setChainConnectDTO(connectDTO);
        }
        if (StringUtils.isEmpty((Object)hfRequestBody.getFuncName())) {
            hfRequestBody.setFuncName("richQueryWithPagination");
        }
        return this.queryBlockChain(hfRequestBody);
    }

    private HFClient initClient(ChainOptionDTO hfRequestBody) throws Exception {
        return this.getHfClient(hfRequestBody);
    }

    private HFClient getHfClient(ChainOptionDTO hfRequestBody) throws Exception {
        Channel channel;
        String clientKey;
        HFClient hfClient;
        String userId = this.accountProperties.getUserId();
        String userPwd = this.accountProperties.getUserPwd();
        String orgName = this.accountProperties.getOrgName();
        String orgMsp = this.accountProperties.getOrgMsp();
        String caServer = this.clientProperties.getCaServer();
        String peerName = this.clientProperties.getPeerName();
        String peerServer = this.clientProperties.getPeerServer();
        String ordererName = this.clientProperties.getOrdererName();
        String ordererServer = this.clientProperties.getOrdererServer();
        if (hfRequestBody.getChainConnectDTO() != null) {
            caServer = hfRequestBody.getChainConnectDTO().getCaServer();
            userId = hfRequestBody.getChainConnectDTO().getUserId();
            userPwd = hfRequestBody.getChainConnectDTO().getSecret();
            orgName = hfRequestBody.getChainConnectDTO().getOrgName();
            orgMsp = hfRequestBody.getChainConnectDTO().getOrgMsp();
            peerName = hfRequestBody.getChainConnectDTO().getPeerName();
            peerServer = hfRequestBody.getChainConnectDTO().getPeerServer();
            ordererName = hfRequestBody.getChainConnectDTO().getOrdererName();
            ordererServer = hfRequestBody.getChainConnectDTO().getOrdererServer();
        }
        if (null == (hfClient = (HFClient)this.hfClientMap.get(clientKey = orgName.concat("_").concat(userId)))) {
            CryptoSuite cryptoSuite = CryptoSuite.Factory.getCryptoSuite();
            hfClient = HFClient.createNewInstance();
            hfClient.setCryptoSuite(cryptoSuite);
            HFCAClient caClient = this.getHfCaClient(caServer, null);
            hfClient.setUserContext((User)this.getAdmin(caClient, userId, userPwd, orgName, orgMsp));
            this.hfClientMap.put(clientKey, hfClient);
        }
        if (!StringUtils.isEmpty((Object)hfRequestBody.getChannelId()) && null == (channel = hfClient.getChannel(hfRequestBody.getChannelId()))) {
            channel = hfClient.newChannel(hfRequestBody.getChannelId());
            Peer peer = hfClient.newPeer(peerName + hfRequestBody.getChannelId(), peerServer);
            Orderer orderer = hfClient.newOrderer(ordererName + hfRequestBody.getChannelId(), ordererServer);
            channel.addPeer(peer);
            channel.addOrderer(orderer);
            channel.initialize();
        }
        return hfClient;
    }

    private HFUser getUser(HFCAClient caClient, HFUser registrar, String userId) throws Exception {
        HFUser hfUser = FabricUtils.tryDeserialize((String)userId, (String)this.accountProperties.getFileSuffixName());
        if (hfUser == null) {
            RegistrationRequest rr = new RegistrationRequest(userId, this.accountProperties.getOrgName());
            String enrollmentSecret = caClient.register(rr, (User)registrar);
            Enrollment enrollment = caClient.enroll(userId, enrollmentSecret);
            hfUser = new HFUser(userId, this.accountProperties.getOrgName(), this.accountProperties.getOrgMsp(), enrollment);
            FabricUtils.serialize((HFUser)hfUser, (String)this.accountProperties.getFileSuffixName());
        }
        return hfUser;
    }

    public HFUser getAdmin(HFCAClient caClient, String userId, String userPwd, String orgName, String orgMsp) throws Exception {
        HFUser admin = FabricUtils.tryDeserialize((String)userId, (String)this.accountProperties.getFileSuffixName());
        if (admin == null) {
            Enrollment adminEnrollment = caClient.enroll(userId, userPwd);
            admin = new HFUser(this.accountProperties.getUserId(), orgName, orgMsp, adminEnrollment);
            FabricUtils.serialize((HFUser)admin, (String)this.accountProperties.getFileSuffixName());
        }
        return admin;
    }

    public HFCAClient getHfCaClient(String caUrl, Properties caClientProperties) throws Exception {
        HFCAClient hfcaClient = (HFCAClient)this.hfcaClientMap.get(caUrl);
        if (null == hfcaClient) {
            CryptoSuite cryptoSuite = CryptoSuite.Factory.getCryptoSuite();
            hfcaClient = HFCAClient.createNewInstance((String)caUrl, (Properties)caClientProperties);
            hfcaClient.setCryptoSuite(cryptoSuite);
            this.hfcaClientMap.put(caUrl, hfcaClient);
            return hfcaClient;
        }
        return hfcaClient;
    }
}

