/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.service.impl;

import cn.gtmap.gtc.bc.domain.po.HFUser;
import cn.gtmap.gtc.chain.domain.AuthUserDetails;
import cn.gtmap.gtc.chain.property.BlockChainProperties;
import cn.gtmap.gtc.chain.property.FabricAccountProperties;
import cn.gtmap.gtc.chain.property.FabricClientProperties;
import cn.gtmap.gtc.chain.service.AuthUserDetailsService;
import cn.gtmap.gtc.chain.service.FabricService;
import cn.gtmap.gtc.chain.util.BaseUtils;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.hyperledger.fabric_ca.sdk.HFCAClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class AuthUserDetailsServiceImpl
implements AuthUserDetailsService {
    private static final Logger logger = LoggerFactory.getLogger(AuthUserDetailsService.class);
    private static final String ROLE_PERFIX = "ROLE_";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private FabricService fabricService;
    @Autowired
    private BlockChainProperties blockChainProperties;
    @Autowired
    private FabricAccountProperties fabricAccountProperties;
    @Autowired
    private FabricClientProperties fabricClientProperties;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        String password = BaseUtils.getRequestParam((HttpServletRequest)this.request, (String)"password");
        String peerServer = BaseUtils.getRequestParam((HttpServletRequest)this.request, (String)"peerServer");
        String orgName = BaseUtils.getRequestParam((HttpServletRequest)this.request, (String)"orgName");
        String orgMsp = BaseUtils.getRequestParam((HttpServletRequest)this.request, (String)"orgMsp");
        try {
            HFCAClient hfcaClient;
            HFUser hfUser;
            if (this.blockChainProperties.getPlatform().equalsIgnoreCase("fabric") && null == (hfUser = this.fabricService.getAdmin(hfcaClient = this.fabricService.getHfCaClient(this.fabricClientProperties.getCaServer(), null), username, password, orgName, orgMsp))) {
                throw new UsernameNotFoundException(username);
            }
        }
        catch (Exception e) {
            logger.error("loadUserByUsername", (Throwable)e);
            throw new UsernameNotFoundException(username);
        }
        AuthUserDetails userDetails = new AuthUserDetails();
        userDetails.setUsername(username);
        userDetails.setId(orgName.concat("_").concat(username));
        userDetails.setPassword(password);
        userDetails.setPeerServer(peerServer);
        userDetails.setOrgName(orgName);
        userDetails.setOrgMsp(orgMsp);
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_BLOCKCHAIN"));
        userDetails.setAuthorities(authorities);
        return userDetails;
    }
}

