/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.service.impl;

import cn.gtmap.gtc.bc.domain.dto.ChainOptionDTO;
import cn.gtmap.gtc.chain.exception.BlockChainException;
import cn.gtmap.gtc.chain.service.AliFabricService;
import cn.gtmap.gtc.chain.util.BaseUtils;
import cn.gtmap.gtc.chain.util.HttpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

@Service
public class AliFabricServiceImpl
implements AliFabricService {
    private static final Logger logger = LoggerFactory.getLogger(AliFabricService.class);
    private static final String INVOKE_PATH = "/api/v1/networks/{network}/transactions/invoke";
    private static final String QUERY_PATH = "/api/v1/networks/{network}/transactions/query";

    public String invokeBlockChain(ChainOptionDTO chainOptionDTO) throws UnsupportedEncodingException {
        String url = INVOKE_PATH.replace("{network}", chainOptionDTO.getChannelId());
        HashMap request = Maps.newHashMap();
        request.put("chaincode", chainOptionDTO.getChainCodeId());
        request.put("args", chainOptionDTO.getArgs());
        request.put("function", chainOptionDTO.getFuncName());
        request.put("invoke_chain", chainOptionDTO.getInvokeChain());
        String accessHeader = BaseUtils.getOauth2Header(null);
        String res = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)request), null, (String)accessHeader);
        logger.debug("invokeBlockChain:{}", (Object)res);
        return this.parseResponse(res);
    }

    public String queryBlockChain(ChainOptionDTO chainOptionDTO) throws UnsupportedEncodingException {
        String url = QUERY_PATH.replace("{network}", chainOptionDTO.getChannelId());
        HashMap request = Maps.newHashMap();
        request.put("chaincode", chainOptionDTO.getChainCodeId());
        request.put("args", chainOptionDTO.getArgs());
        request.put("function", chainOptionDTO.getFuncName());
        request.put("invoke_chain", chainOptionDTO.getInvokeChain());
        String accessHeader = BaseUtils.getOauth2Header(null);
        String res = HttpUtils.post((String)url, (String)JSON.toJSONString((Object)request), null, (String)accessHeader);
        logger.debug("invokeBlockChain:{}", (Object)res);
        return this.parseResponse(res);
    }

    public String parseResponse(String res) throws UnsupportedEncodingException {
        if (!StringUtils.isEmpty((Object)res)) {
            JSONObject jsonObject = JSON.parseObject((String)res);
            Boolean success = jsonObject.getBoolean("Success");
            if (success.booleanValue()) {
                JSONObject response = jsonObject.getJSONObject("Response");
                String base64Data = response.getString("data");
                byte[] data = Base64Utils.decodeFromString((String)base64Data);
                return new String(data, "UTF-8");
            }
            JSONObject err = jsonObject.getJSONObject("Error");
            throw new BlockChainException(err.getString("message"));
        }
        throw new BlockChainException("no response");
    }
}

