/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.config.handler;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.AbstractAuthenticationTargetUrlRequestHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class SimpleUrlLogoutEventSuccessHandler
extends AbstractAuthenticationTargetUrlRequestHandler
implements LogoutSuccessHandler,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String targetUrl = this.determineTargetUrl(request, response);
        if (null != authentication) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (null != targetUrl) {
                data.put("targetUrl", targetUrl);
            } else {
                data.put("targetUrl", "unknown");
            }
            if (authentication.getDetails() != null) {
                data.put("details", authentication.getDetails());
            }
            String principal = "unknown";
            if (authentication.getPrincipal() instanceof UserDetails) {
                principal = ((UserDetails)authentication.getPrincipal()).getUsername();
            }
        }
        if (response.isCommitted()) {
            this.logger.debug((Object)("Response has already been committed. Unable to redirect to " + targetUrl));
            return;
        }
        this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    protected ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    protected void publish(AuditEvent event) {
        if (this.getPublisher() != null) {
            this.getPublisher().publishEvent((ApplicationEvent)new AuditApplicationEvent(event));
        }
    }
}

