/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.config.handler;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class BlockChainAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private RequestCache requestCache = new HttpSessionRequestCache();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        SavedRequest savedRequest;
        String[] urls;
        String configUrl = "/index";
        Map parameterMap = request.getParameterMap();
        if (!CollectionUtils.isEmpty((Map)parameterMap) && (urls = (String[])parameterMap.get("redirect_url")) != null && urls.length > 0 && !StringUtils.isEmpty((Object)urls[0])) {
            configUrl = urls[0];
        }
        if ((savedRequest = this.requestCache.getRequest(request, response)) == null) {
            this.getRedirectStrategy().sendRedirect(request, response, configUrl);
            super.onAuthenticationSuccess(request, response, authentication);
        } else {
            String url = savedRequest.getRedirectUrl();
            if (null == url) {
                this.getRedirectStrategy().sendRedirect(request, response, configUrl);
            }
            String targetUrlParameter = this.getTargetUrlParameter();
            if (!(this.isAlwaysUseDefaultTargetUrl() || targetUrlParameter != null && StringUtils.hasText((String)request.getParameter(targetUrlParameter)))) {
                this.clearAuthenticationAttributes(request);
                this.logger.debug((Object)("Redirecting to DefaultSavedRequest Url: " + url));
                this.getRedirectStrategy().sendRedirect(request, response, url);
            } else {
                this.requestCache.removeRequest(request, response);
                super.onAuthenticationSuccess(request, response, authentication);
            }
        }
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }
}

