/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.chain.config;

import cn.gtmap.gtc.chain.config.handler.BlockChainAuthenticationFailureHandler;
import cn.gtmap.gtc.chain.config.handler.BlockChainAuthenticationSuccessHandler;
import cn.gtmap.gtc.chain.config.handler.BlockChainPasswordEncoder;
import cn.gtmap.gtc.chain.config.handler.BlockChainSecurityContextLogoutHandler;
import cn.gtmap.gtc.chain.config.handler.SimpleUrlLogoutEventSuccessHandler;
import cn.gtmap.gtc.chain.service.AuthUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled=true, prePostEnabled=true)
@Order(value=0x7FFFFFF8)
public class AccountSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String REDIRECT_URI_PARAM = "redirect_uri";
    @Autowired
    private AuthUserDetailsService userDetailsService;
    @Autowired
    private BlockChainAuthenticationSuccessHandler gtmapAuthenticationSuccessHandler;
    @Autowired
    private BlockChainSecurityContextLogoutHandler securityContextLogoutHandler;
    @Autowired
    private SessionInformationExpiredStrategy sessionInformationExpiredStrategy;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BlockChainPasswordEncoder((PasswordEncoder)new BCryptPasswordEncoder());
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginPage("/login").successHandler((AuthenticationSuccessHandler)this.gtmapAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.gtmapAuthenticationFailureHandler())).and()).authorizeRequests().antMatchers(new String[]{"/login", "/error", "/auth/**", "/info", "/health", "/home", "/swagger-ui.html", "/api/**", "/v2/**"})).permitAll().anyRequest()).authenticated().and()).csrf().disable()).cors().disable()).headers().xssProtection().disable().contentTypeOptions().disable().frameOptions().disable();
        http.logout().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/logout")).logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler()).addLogoutHandler((LogoutHandler)this.securityContextLogoutHandler).deleteCookies(new String[]{"JSESSIONID"});
        http.authorizeRequests().withObjectPostProcessor((ObjectPostProcessor)new /* Unavailable Anonymous Inner Class!! */);
        http.exceptionHandling().accessDeniedPage("/accessDenied");
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).invalidSessionUrl("/login").maximumSessions(-1).maxSessionsPreventsLogin(false).expiredSessionStrategy(this.sessionInformationExpiredStrategy);
    }

    SimpleUrlLogoutEventSuccessHandler logoutSuccessHandler() {
        SimpleUrlLogoutEventSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutEventSuccessHandler();
        logoutSuccessHandler.setTargetUrlParameter(REDIRECT_URI_PARAM);
        logoutSuccessHandler.setApplicationEventPublisher((ApplicationEventPublisher)super.getApplicationContext());
        return logoutSuccessHandler;
    }

    @Bean
    BlockChainAuthenticationFailureHandler gtmapAuthenticationFailureHandler() {
        BlockChainAuthenticationFailureHandler gtmapAuthenticationFailureHandler = new BlockChainAuthenticationFailureHandler();
        gtmapAuthenticationFailureHandler.setDefaultFailureUrl("/login?error=true");
        return gtmapAuthenticationFailureHandler;
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/swagger-resources/**", "/assets/**", "/lib/**", "/image/**", "/css/**", "/js/**", "/webjars/**", "/env", "/metrics", "/info", "/custom/**", "/rest/v1/**"});
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.userDetailsService).passwordEncoder(this.passwordEncoder());
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

