/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.testing;

import cn.gtmap.common.base.basis.Equivalence;
import cn.gtmap.common.collect.collection.ImmutableList;
import cn.gtmap.common.collect.utils.Lists;
import cn.gtmap.common.testing.RelationshipTester;
import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.util.List;

@Beta
@GwtCompatible
public final class EqualsTester {
    private static final int REPETITIONS = 3;
    private final List<List<Object>> equalityGroups = Lists.newArrayList();
    private final RelationshipTester.ItemReporter itemReporter;

    public EqualsTester() {
        this(new RelationshipTester.ItemReporter());
    }

    EqualsTester(RelationshipTester.ItemReporter itemReporter) {
        this.itemReporter = (RelationshipTester.ItemReporter)Preconditions.checkNotNull((Object)itemReporter);
    }

    public EqualsTester addEqualityGroup(Object ... equalityGroup) {
        Preconditions.checkNotNull((Object)equalityGroup);
        this.equalityGroups.add((List<Object>)ImmutableList.copyOf((Object[])equalityGroup));
        return this;
    }

    public EqualsTester testEquals() {
        RelationshipTester<Object> delegate = new RelationshipTester<Object>(Equivalence.equals(), "Object#equals", "Object#hashCode", this.itemReporter);
        for (List<Object> group : this.equalityGroups) {
            delegate.addRelatedGroup(group);
        }
        for (int run = 0; run < 3; ++run) {
            this.testItems();
            delegate.test();
        }
        return this;
    }

    private void testItems() {
    }

    private static enum NotAnInstance {
        EQUAL_TO_NOTHING;

    }
}

