/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.collect.utils;

import cn.gtmap.common.base.Functions;
import cn.gtmap.common.base.basis.Function;
import cn.gtmap.common.collect.collection.ImmutableList;
import cn.gtmap.common.collect.utils.Lists;
import cn.gtmap.common.collect.utils.Ordering;
import cn.gtmap.common.primitives.Ints;
import cn.gtmap.common.testing.EqualsTester;
import cn.gtmap.common.testing.NullPointerTester;
import cn.gtmap.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.Iterators;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import junit.framework.TestCase;

public class OrderingTest
extends TestCase {
    private final Ordering<Number> numberOrdering = new NumberOrdering();
    private static final Ordering<Integer> DECREASING_INTEGER = Ordering.natural().reverse();

    public void testAllEqual() {
        Ordering comparator = Ordering.allEqual();
        OrderingTest.assertSame((Object)comparator, (Object)comparator.reverse());
        OrderingTest.assertEquals((int)comparator.compare(null, null), (int)0);
        OrderingTest.assertEquals((int)comparator.compare(new Object(), new Object()), (int)0);
        OrderingTest.assertEquals((int)comparator.compare((Object)"apples", (Object)"oranges"), (int)0);
        OrderingTest.assertSame((Object)comparator, (Object)SerializableTester.reserialize(comparator));
        OrderingTest.assertEquals((String)"Ordering.allEqual()", (String)comparator.toString());
        ImmutableList strings = ImmutableList.of((Object)"b", (Object)"a", (Object)"d", (Object)"c");
        OrderingTest.assertEquals((Object)strings, (Object)comparator.sortedCopy((Iterable)strings));
        OrderingTest.assertEquals((Object)strings, (Object)comparator.immutableSortedCopy((Iterable)strings));
    }

    public void testComplicatedOrderingExample() {
        Integer nullInt = null;
        Ordering example = Ordering.natural().nullsFirst().reverse().lexicographical().reverse().nullsLast();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList((Object[])new Integer[]{1});
        ArrayList list3 = Lists.newArrayList((Object[])new Integer[]{1, 1});
        ArrayList list4 = Lists.newArrayList((Object[])new Integer[]{1, 2});
        ArrayList list5 = Lists.newArrayList((Object[])new Integer[]{1, null, 2});
        ArrayList list6 = Lists.newArrayList((Object[])new Integer[]{2});
        ArrayList list7 = Lists.newArrayList((Object[])new Integer[]{nullInt});
        ArrayList list8 = Lists.newArrayList((Object[])new Integer[]{nullInt, nullInt});
        ArrayList list = Lists.newArrayList((Object[])new List[]{list1, list2, list3, list4, list5, list6, list7, list8, null});
        List sorted = example.sortedCopy((Iterable)list);
        Truth.assertThat((Iterable)sorted).containsExactly(new Object[]{Lists.newArrayList((Object[])new Integer[]{nullInt, nullInt}), Lists.newArrayList((Object[])new Integer[]{nullInt}), Lists.newArrayList((Object[])new Integer[]{1, null, 2}), Lists.newArrayList((Object[])new Integer[]{1, 1}), Lists.newArrayList((Object[])new Integer[]{1, 2}), Lists.newArrayList((Object[])new Integer[]{1}), Lists.newArrayList((Object[])new Integer[]{2}), Lists.newArrayList(), null}).inOrder();
    }

    public void testFrom() {
        Ordering caseInsensitiveOrdering = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER);
        OrderingTest.assertEquals((int)0, (int)caseInsensitiveOrdering.compare((Object)"A", (Object)"a"));
        OrderingTest.assertTrue((caseInsensitiveOrdering.compare((Object)"a", (Object)"B") < 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((caseInsensitiveOrdering.compare((Object)"B", (Object)"a") > 0 ? 1 : 0) != 0);
        Ordering orderingFromOrdering = Ordering.from((Comparator)Ordering.natural());
        new EqualsTester().addEqualityGroup(caseInsensitiveOrdering, Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER)).addEqualityGroup(orderingFromOrdering, Ordering.natural()).testEquals();
    }

    private static Ordering<String> byCharAt(int index) {
        return Ordering.natural().onResultOf((Function)CharAtFunction.values()[index]);
    }

    public void testReverseOfReverseSameAsForward() {
        OrderingTest.assertSame(this.numberOrdering, (Object)this.numberOrdering.reverse().reverse());
    }

    public void testOnResultOf_natural() {
        Ordering comparator = Ordering.natural().onResultOf((Function)StringLengthFunction.StringLength);
        OrderingTest.assertTrue((comparator.compare("to", "be") == 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("or", "not") < 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("that", "to") > 0 ? 1 : 0) != 0);
        new EqualsTester().addEqualityGroup(comparator, Ordering.natural().onResultOf((Function)StringLengthFunction.StringLength)).addEqualityGroup(DECREASING_INTEGER).testEquals();
        SerializableTester.reserializeAndAssert(comparator);
        OrderingTest.assertEquals((String)"Ordering.natural().onResultOf(StringLength)", (String)comparator.toString());
    }

    public void testOnResultOf_chained() {
        Ordering comparator = DECREASING_INTEGER.onResultOf((Function)StringLengthFunction.StringLength);
        OrderingTest.assertTrue((comparator.compare("to", "be") == 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("not", "or") < 0 ? 1 : 0) != 0);
        OrderingTest.assertTrue((comparator.compare("to", "that") > 0 ? 1 : 0) != 0);
        new EqualsTester().addEqualityGroup(comparator, DECREASING_INTEGER.onResultOf((Function)StringLengthFunction.StringLength)).addEqualityGroup(DECREASING_INTEGER.onResultOf(Functions.constant((Object)1))).addEqualityGroup(Ordering.natural()).testEquals();
        SerializableTester.reserializeAndAssert(comparator);
        OrderingTest.assertEquals((String)"Ordering.natural().reverse().onResultOf(StringLength)", (String)comparator.toString());
    }

    public void testSortedCopy() {
        List<Integer> unsortedInts = Collections.unmodifiableList(Arrays.asList(5, 0, 3, null, 0, 9));
        List sortedInts = this.numberOrdering.nullsLast().sortedCopy(unsortedInts);
        OrderingTest.assertEquals(Arrays.asList(0, 0, 3, 5, 9, null), (Object)sortedInts);
        OrderingTest.assertEquals(Collections.emptyList(), (Object)this.numberOrdering.sortedCopy(Collections.emptyList()));
    }

    public void testImmutableSortedCopy() {
        ImmutableList unsortedInts = ImmutableList.of((Object)5, (Object)3, (Object)0, (Object)9, (Object)3);
        ImmutableList sortedInts = this.numberOrdering.immutableSortedCopy((Iterable)unsortedInts);
        OrderingTest.assertEquals(Arrays.asList(0, 3, 3, 5, 9), (Object)sortedInts);
        OrderingTest.assertEquals(Collections.emptyList(), (Object)this.numberOrdering.immutableSortedCopy(Collections.emptyList()));
        List<Integer> listWithNull = Arrays.asList(5, 3, null, 9);
        try {
            Ordering.natural().nullsFirst().immutableSortedCopy(listWithNull);
            OrderingTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testIsOrdered() {
        OrderingTest.assertFalse((boolean)this.numberOrdering.isOrdered(Arrays.asList(5, 3, 0, 9)));
        OrderingTest.assertFalse((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 5, 3, 9)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 3, 5, 9)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 0, 3, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Arrays.asList(0, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Collections.singleton(1)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isOrdered(Collections.emptyList()));
    }

    public void testIsStrictlyOrdered() {
        OrderingTest.assertFalse((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(5, 3, 0, 9)));
        OrderingTest.assertFalse((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 5, 3, 9)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 3, 5, 9)));
        OrderingTest.assertFalse((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 0, 3, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Arrays.asList(0, 3)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Collections.singleton(1)));
        OrderingTest.assertTrue((boolean)this.numberOrdering.isStrictlyOrdered(Collections.emptyList()));
    }

    public void testLeastOfIterable_empty_0() {
        List result = this.numberOrdering.leastOf(Arrays.asList(new Integer[0]), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_empty_0() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.emptyIterator(), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_empty_1() {
        List result = this.numberOrdering.leastOf(Arrays.asList(new Integer[0]), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_empty_1() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.emptyIterator(), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_simple_negativeOne() {
        try {
            this.numberOrdering.leastOf(Arrays.asList(3, 4, 5, -1), -1);
            OrderingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLeastOfIterator_simple_negativeOne() {
        try {
            this.numberOrdering.leastOf((Iterator)Iterators.forArray((Object[])new Integer[]{3, 4, 5, -1}), -1);
            OrderingTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLeastOfIterable_singleton_0() {
        List result = this.numberOrdering.leastOf(Arrays.asList(3), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_singleton_0() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.singletonIterator((Object)3), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_simple_0() {
        List result = this.numberOrdering.leastOf(Arrays.asList(3, 4, 5, -1), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterator_simple_0() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.forArray((Object[])new Integer[]{3, 4, 5, -1}), 0);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of(), (Object)result);
    }

    public void testLeastOfIterable_simple_1() {
        List result = this.numberOrdering.leastOf(Arrays.asList(3, 4, 5, -1), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1), (Object)result);
    }

    public void testLeastOfIterator_simple_1() {
        List result = this.numberOrdering.leastOf((Iterator)Iterators.forArray((Object[])new Integer[]{3, 4, 5, -1}), 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1), (Object)result);
    }

    public void testLeastOfIterable_simple_nMinusOne_withNullElement() {
        List<Integer> list = Arrays.asList(3, null, 5, -1);
        List result = Ordering.natural().nullsLast().leastOf(list, list.size() - 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)5), (Object)result);
    }

    public void testLeastOfIterator_simple_nMinusOne_withNullElement() {
        UnmodifiableIterator itr = Iterators.forArray((Object[])new Integer[]{3, null, 5, -1});
        List result = Ordering.natural().nullsLast().leastOf((Iterator)itr, 3);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)5), (Object)result);
    }

    public void testLeastOfIterable_simple_nMinusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list, list.size() - 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4), (Object)result);
    }

    public void testLeastOfIterator_simple_nMinusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size() - 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4), (Object)result);
    }

    public void testLeastOfIterable_simple_n() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list, list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterator_simple_n() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterable_simple_n_withNullElement() {
        List<Integer> list = Arrays.asList(3, 4, 5, null, -1);
        List result = Ordering.natural().nullsLast().leastOf(list, list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals(Arrays.asList(-1, 3, 4, 5, null), (Object)result);
    }

    public void testLeastOfIterator_simple_n_withNullElement() {
        List<Integer> list = Arrays.asList(3, 4, 5, null, -1);
        List result = Ordering.natural().nullsLast().leastOf(list.iterator(), list.size());
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals(Arrays.asList(-1, 3, 4, 5, null), (Object)result);
    }

    public void testLeastOfIterable_simple_nPlusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list, list.size() + 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterator_simple_nPlusOne() {
        List<Integer> list = Arrays.asList(3, 4, 5, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size() + 1);
        OrderingTest.assertTrue((boolean)(result instanceof RandomAccess));
        OrderingTest.assertListImmutable(result);
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)4, (Object)5), (Object)result);
    }

    public void testLeastOfIterable_ties() {
        Integer foo = new Integer(0x7FFFFFF5);
        Integer bar = new Integer(0x7FFFFFF5);
        OrderingTest.assertNotSame((Object)foo, (Object)bar);
        OrderingTest.assertEquals((Object)foo, (Object)bar);
        List<Integer> list = Arrays.asList(3, foo, bar, -1);
        List result = this.numberOrdering.leastOf(list, list.size());
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)foo, (Object)bar), (Object)result);
    }

    public void testLeastOfIterator_ties() {
        Integer foo = new Integer(0x7FFFFFF5);
        Integer bar = new Integer(0x7FFFFFF5);
        OrderingTest.assertNotSame((Object)foo, (Object)bar);
        OrderingTest.assertEquals((Object)foo, (Object)bar);
        List<Integer> list = Arrays.asList(3, foo, bar, -1);
        List result = this.numberOrdering.leastOf(list.iterator(), list.size());
        OrderingTest.assertEquals((Object)ImmutableList.of((Object)-1, (Object)3, (Object)foo, (Object)bar), (Object)result);
    }

    public void testLeastOf_reconcileAgainstSortAndSublist() {
        OrderingTest.runLeastOfComparison(1000, 300, 20);
    }

    public void testLeastOf_reconcileAgainstSortAndSublistSmall() {
        OrderingTest.runLeastOfComparison(10, 30, 2);
    }

    private static void runLeastOfComparison(int iterations, int elements, int seeds) {
        Random random = new Random(42L);
        Ordering ordering = Ordering.natural();
        for (int i = 0; i < iterations; ++i) {
            ArrayList list = Lists.newArrayList();
            for (int j = 0; j < elements; ++j) {
                list.add(random.nextInt(10 * i + j + 1));
            }
            for (int seed = 1; seed < seeds; ++seed) {
                int k = random.nextInt(10 * seed);
                OrderingTest.assertEquals(ordering.sortedCopy((Iterable)list).subList(0, k), (Object)ordering.leastOf((Iterable)list, k));
            }
        }
    }

    public void testLeastOfIterableLargeK() {
        List<Integer> list = Arrays.asList(4, 2, 3, 5, 1);
        OrderingTest.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)Ordering.natural().leastOf(list, Integer.MAX_VALUE));
    }

    public void testLeastOfIteratorLargeK() {
        List<Integer> list = Arrays.asList(4, 2, 3, 5, 1);
        OrderingTest.assertEquals(Arrays.asList(1, 2, 3, 4, 5), (Object)Ordering.natural().leastOf(list.iterator(), Integer.MAX_VALUE));
    }

    public void testGreatestOfIterable_simple() {
        List<Integer> list = Arrays.asList(3, 1, 3, 2, 4, 2, 4, 3);
        OrderingTest.assertEquals(Arrays.asList(4, 4, 3, 3), (Object)this.numberOrdering.greatestOf(list, 4));
    }

    public void testGreatestOfIterator_simple() {
        List<Integer> list = Arrays.asList(3, 1, 3, 2, 4, 2, 4, 3);
        OrderingTest.assertEquals(Arrays.asList(4, 4, 3, 3), (Object)this.numberOrdering.greatestOf(list.iterator(), 4));
    }

    private static void assertListImmutable(List<Integer> result) {
        try {
            result.set(0, 1);
            OrderingTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testIteratorMinAndMax() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{5, 3, 0, 9});
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max(ints.iterator())));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min(ints.iterator())));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        ints = Lists.newArrayList((Object[])new Integer[]{a, b, b});
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max(ints.iterator()));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min(ints.iterator()));
    }

    public void testIteratorMinExhaustsIterator() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{9, 0, 3, 5});
        Iterator iterator = ints.iterator();
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min(iterator)));
        OrderingTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testIteratorMaxExhaustsIterator() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{9, 0, 3, 5});
        Iterator iterator = ints.iterator();
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max(iterator)));
        OrderingTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testIterableMinAndMax() {
        ArrayList ints = Lists.newArrayList((Object[])new Integer[]{5, 3, 0, 9});
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Iterable)ints)));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Iterable)ints)));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        ints = Lists.newArrayList((Object[])new Integer[]{a, b, b});
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max((Iterable)ints));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min((Iterable)ints));
    }

    public void testVarargsMinAndMax() {
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)9, (Object)3, (Object)0, (Object[])new Integer[]{5, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)9, (Object)0, (Object[])new Integer[]{3, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3, (Object)9, (Object[])new Integer[]{0, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)9, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{8, 9})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)0, (Object)3, (Object)5, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)0, (Object)3, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{9, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3, (Object)9, (Object[])new Integer[]{0, 8})));
        OrderingTest.assertEquals((int)0, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3, (Object)0, (Object[])new Integer[]{9, 0})));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max((Object)a, (Object)b, (Object)b, (Object[])new Integer[0]));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min((Object)a, (Object)b, (Object)b, (Object[])new Integer[0]));
    }

    public void testParameterMinAndMax() {
        OrderingTest.assertEquals((int)5, (int)((Integer)this.numberOrdering.max((Object)3, (Object)5)));
        OrderingTest.assertEquals((int)5, (int)((Integer)this.numberOrdering.max((Object)5, (Object)3)));
        OrderingTest.assertEquals((int)3, (int)((Integer)this.numberOrdering.min((Object)3, (Object)5)));
        OrderingTest.assertEquals((int)3, (int)((Integer)this.numberOrdering.min((Object)5, (Object)3)));
        Integer a = new Integer(4);
        Integer b = new Integer(4);
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.max((Object)a, (Object)b));
        OrderingTest.assertSame((Object)a, (Object)this.numberOrdering.min((Object)a, (Object)b));
    }

    public void testNullPointerExceptions() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicStaticMethods(Ordering.class);
        tester.testAllPublicInstanceMethods(Ordering.usingToString().nullsFirst());
    }

    private static <T> List<T> shuffledCopy(List<T> in, Random random) {
        ArrayList mutable = Lists.newArrayList(in);
        ArrayList out = Lists.newArrayList();
        while (!mutable.isEmpty()) {
            out.add(mutable.remove(random.nextInt(mutable.size())));
        }
        return out;
    }

    private static class Composite<T>
    implements Comparable<Composite<T>> {
        final T value;
        final int rank;

        Composite(T value, int rank) {
            this.value = value;
            this.rank = rank;
        }

        @Override
        public int compareTo(Composite<T> that) {
            return Ints.compare((int)this.rank, (int)that.rank);
        }

        static <T> Function<Composite<T>, T> getValueFunction() {
            return new Function<Composite<T>, T>(){

                public T apply(Composite<T> from) {
                    return from.value;
                }
            };
        }
    }

    private static class NumberOrdering
    extends Ordering<Number> {
        private static final long serialVersionUID = 0L;

        private NumberOrdering() {
        }

        public int compare(Number a, Number b) {
            return Double.valueOf(a.doubleValue()).compareTo(b.doubleValue());
        }

        public int hashCode() {
            return NumberOrdering.class.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof NumberOrdering;
        }
    }

    private static enum StringLengthFunction implements Function<String, Integer>
    {
        StringLength;


        public Integer apply(String string) {
            return string.length();
        }
    }

    private static enum CharAtFunction implements Function<String, Character>
    {
        AT0(0),
        AT1(1),
        AT2(2),
        AT3(3),
        AT4(4),
        AT5(5);

        final int index;

        private CharAtFunction(int index) {
            this.index = index;
        }

        public Character apply(String string) {
            return Character.valueOf(string.charAt(this.index));
        }
    }
}

