/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.collect.utils;

import cn.gtmap.common.collect.collection.ImmutableMap;
import cn.gtmap.common.collect.collection.MapDifference;
import cn.gtmap.common.collect.collection.SortedMapDifference;
import cn.gtmap.common.collect.utils.Maps;
import cn.gtmap.common.testing.EqualsTester;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.Truth;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import junit.framework.TestCase;

public class MapsTest
extends TestCase {
    private static final Comparator<Integer> SOME_COMPARATOR = Collections.reverseOrder();
    private static final Map<Integer, Integer> EMPTY = Collections.emptyMap();
    private static final Map<Integer, Integer> SINGLETON = Collections.singletonMap(1, 2);
    private static final SortedMap<Integer, Integer> SORTED_EMPTY = Maps.newTreeMap();

    public void testHashMap() {
        HashMap map = Maps.newHashMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testHashMapWithInitialMap() {
        TreeMap<String, Integer> original = new TreeMap<String, Integer>();
        original.put("a", 1);
        original.put("b", 2);
        original.put("c", 3);
        HashMap map = Maps.newHashMap(original);
        MapsTest.assertEquals(original, (Object)map);
    }

    public void testHashMapGeneralizesTypes() {
        TreeMap<String, Integer> original = new TreeMap<String, Integer>();
        original.put("a", 1);
        original.put("b", 2);
        original.put("c", 3);
        HashMap map = Maps.newHashMap(original);
        MapsTest.assertEquals(original, (Object)map);
    }

    public void testCapacityForNegativeSizeFails() {
        try {
            Maps.capacity((int)-1);
            MapsTest.fail((String)"Negative expected size must result in IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewHashMapWithExpectedSize_wontGrow() throws Exception {
        MapsTest.assertTrue((MapsTest.bucketsOf(Maps.newHashMapWithExpectedSize((int)0)) <= 1 ? 1 : 0) != 0);
        for (int size = 1; size < 200; ++size) {
            MapsTest.assertWontGrow(size, Maps.newHashMapWithExpectedSize((int)size), Maps.newHashMapWithExpectedSize((int)size));
        }
    }

    public void testNewLinkedHashMapWithExpectedSize_wontGrow() throws Exception {
        MapsTest.assertTrue((MapsTest.bucketsOf(Maps.newLinkedHashMapWithExpectedSize((int)0)) <= 1 ? 1 : 0) != 0);
        for (int size = 1; size < 200; ++size) {
            MapsTest.assertWontGrow(size, Maps.newLinkedHashMapWithExpectedSize((int)size), Maps.newLinkedHashMapWithExpectedSize((int)size));
        }
    }

    private static void assertWontGrow(int size, HashMap<Object, Object> map1, HashMap<Object, Object> map2) throws Exception {
        map1.put(0, null);
        int initialBuckets = MapsTest.bucketsOf(map1);
        for (int i = 1; i < size; ++i) {
            map1.put(i, null);
        }
        ((IntegerSubject)Truth.assertThat((Integer)MapsTest.bucketsOf(map1)).named("table size after adding " + size + " elements", new Object[0])).isEqualTo((Object)initialBuckets);
        map2.putAll(map1);
        ((IntegerSubject)Truth.assertThat((Integer)MapsTest.bucketsOf(map1)).named("table size after adding " + size + " elements", new Object[0])).isEqualTo((Object)initialBuckets);
    }

    private static int bucketsOf(HashMap<?, ?> hashMap) throws Exception {
        Field tableField = HashMap.class.getDeclaredField("table");
        tableField.setAccessible(true);
        Object[] table = (Object[])tableField.get(hashMap);
        return table == null ? 0 : table.length;
    }

    public void testCapacityForLargeSizes() {
        int[] largeExpectedSizes;
        for (int expectedSize : largeExpectedSizes = new int[]{0x3FFFFFFE, 0x3FFFFFFF, 0x40000000, 0x7FFFFFFE, Integer.MAX_VALUE}) {
            int capacity = Maps.capacity((int)expectedSize);
            MapsTest.assertTrue((String)("capacity (" + capacity + ") must be >= expectedSize (" + expectedSize + ")"), (capacity >= expectedSize ? 1 : 0) != 0);
        }
    }

    public void testLinkedHashMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testLinkedHashMapWithInitialMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(){
            {
                this.put("Hello", "World");
                this.put("first", "second");
                this.put("polygene", "lubricants");
                this.put("alpha", "betical");
            }
        };
        LinkedHashMap copy = Maps.newLinkedHashMap((Map)map);
        Iterator iter = copy.entrySet().iterator();
        MapsTest.assertTrue((boolean)iter.hasNext());
        Map.Entry entry = iter.next();
        MapsTest.assertEquals((String)"Hello", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"World", (String)((String)entry.getValue()));
        MapsTest.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        MapsTest.assertEquals((String)"first", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"second", (String)((String)entry.getValue()));
        MapsTest.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        MapsTest.assertEquals((String)"polygene", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"lubricants", (String)((String)entry.getValue()));
        MapsTest.assertTrue((boolean)iter.hasNext());
        entry = iter.next();
        MapsTest.assertEquals((String)"alpha", (String)((String)entry.getKey()));
        MapsTest.assertEquals((String)"betical", (String)((String)entry.getValue()));
        MapsTest.assertFalse((boolean)iter.hasNext());
    }

    public void testLinkedHashMapGeneralizesTypes() {
        LinkedHashMap<String, Integer> original = new LinkedHashMap<String, Integer>();
        original.put("a", 1);
        original.put("b", 2);
        original.put("c", 3);
        LinkedHashMap map = Maps.newLinkedHashMap(original);
        MapsTest.assertEquals(original, (Object)map);
    }

    public void testIdentityHashMap() {
        IdentityHashMap map = Maps.newIdentityHashMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testConcurrentMap() {
        ConcurrentMap map = Maps.newConcurrentMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
    }

    public void testTreeMap() {
        TreeMap map = Maps.newTreeMap();
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        MapsTest.assertNull(map.comparator());
    }

    public void testTreeMapWithComparator() {
        TreeMap map = Maps.newTreeMap(SOME_COMPARATOR);
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        MapsTest.assertSame(SOME_COMPARATOR, map.comparator());
    }

    public void testTreeMapWithInitialMap() {
        TreeMap map = Maps.newTreeMap();
        map.put(5, 10);
        map.put(3, 20);
        map.put(1, 30);
        TreeMap copy = Maps.newTreeMap((SortedMap)map);
        MapsTest.assertEquals((Object)copy, (Object)map);
        MapsTest.assertSame(copy.comparator(), map.comparator());
    }

    public void testEnumMap() {
        EnumMap map = Maps.newEnumMap(SomeEnum.class);
        MapsTest.assertEquals(Collections.emptyMap(), (Object)map);
        map.put(SomeEnum.SOME_INSTANCE, 0);
        MapsTest.assertEquals(Collections.singletonMap(SomeEnum.SOME_INSTANCE, 0), (Object)map);
    }

    public void testEnumMapNullClass() {
        try {
            Maps.newEnumMap((Class)null);
            MapsTest.fail((String)"no exception thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEnumMapWithInitialEnumMap() {
        EnumMap original = Maps.newEnumMap(SomeEnum.class);
        original.put(SomeEnum.SOME_INSTANCE, 0);
        EnumMap copy = Maps.newEnumMap((Map)original);
        MapsTest.assertEquals((Object)original, (Object)copy);
    }

    public void testEnumMapWithInitialEmptyEnumMap() {
        EnumMap original = Maps.newEnumMap(SomeEnum.class);
        EnumMap copy = Maps.newEnumMap((Map)original);
        MapsTest.assertEquals((Object)original, (Object)copy);
        MapsTest.assertNotSame((Object)original, (Object)copy);
    }

    public void testEnumMapWithInitialMap() {
        HashMap original = Maps.newHashMap();
        original.put(SomeEnum.SOME_INSTANCE, 0);
        EnumMap copy = Maps.newEnumMap((Map)original);
        MapsTest.assertEquals((Object)original, (Object)copy);
    }

    public void testEnumMapWithInitialEmptyMap() {
        HashMap original = Maps.newHashMap();
        try {
            Maps.newEnumMap((Map)original);
            MapsTest.fail((String)"Empty map must result in an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToStringImplWithNullKeys() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put(null, "baz");
        MapsTest.assertEquals((String)((Object)hashmap).toString(), (String)Maps.toStringImpl((Map)hashmap));
    }

    public void testToStringImplWithNullValues() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put("baz", null);
        MapsTest.assertEquals((String)((Object)hashmap).toString(), (String)Maps.toStringImpl((Map)hashmap));
    }

    public void testMapDifferenceEmptyEmpty() {
        MapDifference diff = Maps.difference(EMPTY, EMPTY);
        MapsTest.assertTrue((boolean)diff.areEqual());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"equal", (String)diff.toString());
    }

    public void testMapDifferenceEmptySingleton() {
        MapDifference diff = Maps.difference(EMPTY, SINGLETON);
        MapsTest.assertFalse((boolean)diff.areEqual());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(SINGLETON, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on right={1=2}", (String)diff.toString());
    }

    public void testMapDifferenceSingletonEmpty() {
        MapDifference diff = Maps.difference(SINGLETON, EMPTY);
        MapsTest.assertFalse((boolean)diff.areEqual());
        MapsTest.assertEquals(SINGLETON, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={1=2}", (String)diff.toString());
    }

    public void testMapDifferenceTypical() {
        ImmutableMap left = ImmutableMap.of((Object)1, (Object)"a", (Object)2, (Object)"b", (Object)3, (Object)"c", (Object)4, (Object)"d", (Object)5, (Object)"e");
        ImmutableMap right = ImmutableMap.of((Object)1, (Object)"a", (Object)3, (Object)"f", (Object)5, (Object)"g", (Object)6, (Object)"z");
        MapDifference diff1 = Maps.difference((Map)left, (Map)right);
        MapsTest.assertFalse((boolean)diff1.areEqual());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)"b", (Object)4, (Object)"d"), (Object)diff1.entriesOnlyOnLeft());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)6, (Object)"z"), (Object)diff1.entriesOnlyOnRight());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"a"), (Object)diff1.entriesInCommon());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"c", (Object)"f"), (Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"e", (Object)"g")), (Object)diff1.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={2=b, 4=d}: only on right={6=z}: value differences={3=(c, f), 5=(e, g)}", (String)diff1.toString());
        MapDifference diff2 = Maps.difference((Map)right, (Map)left);
        MapsTest.assertFalse((boolean)diff2.areEqual());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)6, (Object)"z"), (Object)diff2.entriesOnlyOnLeft());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)"b", (Object)4, (Object)"d"), (Object)diff2.entriesOnlyOnRight());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)"a"), (Object)diff2.entriesInCommon());
        MapsTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Maps.ValueDifferenceImpl.create((Object)"f", (Object)"c"), (Object)5, (Object)Maps.ValueDifferenceImpl.create((Object)"g", (Object)"e")), (Object)diff2.entriesDiffering());
        MapsTest.assertEquals((String)"not equal: only on left={6=z}: only on right={2=b, 4=d}: value differences={3=(f, c), 5=(g, e)}", (String)diff2.toString());
    }

    public void testMapDifferenceEquals() {
        ImmutableMap left = ImmutableMap.of((Object)1, (Object)"a", (Object)2, (Object)"b", (Object)3, (Object)"c", (Object)4, (Object)"d", (Object)5, (Object)"e");
        ImmutableMap right = ImmutableMap.of((Object)1, (Object)"a", (Object)3, (Object)"f", (Object)5, (Object)"g", (Object)6, (Object)"z");
        ImmutableMap right2 = ImmutableMap.of((Object)1, (Object)"a", (Object)3, (Object)"h", (Object)5, (Object)"g", (Object)6, (Object)"z");
        MapDifference original = Maps.difference((Map)left, (Map)right);
        MapDifference same = Maps.difference((Map)left, (Map)right);
        MapDifference reverse = Maps.difference((Map)right, (Map)left);
        MapDifference diff2 = Maps.difference((Map)left, (Map)right2);
        new EqualsTester().addEqualityGroup(original, same).addEqualityGroup(reverse).addEqualityGroup(diff2).testEquals();
    }

    public void testSortedMapDifferenceEmptyEmpty() {
        SortedMapDifference diff = Maps.difference(SORTED_EMPTY, SORTED_EMPTY);
        MapsTest.assertTrue((boolean)diff.areEqual());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesOnlyOnLeft());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesOnlyOnRight());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesInCommon());
        MapsTest.assertEquals(SORTED_EMPTY, (Object)diff.entriesDiffering());
        MapsTest.assertEquals((String)"equal", (String)diff.toString());
    }

    public static enum SomeEnum {
        SOME_INSTANCE;

    }
}

