/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.collect.utils;

import cn.gtmap.common.base.basis.Function;
import cn.gtmap.common.collect.utils.Lists;
import com.google.common.truth.Truth;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.TestCase;

public class ListsTest
extends TestCase {
    private static final Collection<Integer> SOME_COLLECTION = Arrays.asList(0, 1, 1);
    private static final Iterable<Integer> SOME_ITERABLE = new SomeIterable();
    private static final List<Integer> SOME_LIST = Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4});
    private static final List<Integer> SOME_SEQUENTIAL_LIST = Lists.newLinkedList(Arrays.asList(1, 2, 3, 4));
    private static final List<String> SOME_STRING_LIST = Arrays.asList("1", "2", "3", "4");
    private static final Function<Number, String> SOME_FUNCTION = new SomeFunction();

    public void testNewArrayListEmpty() {
        ArrayList list = Lists.newArrayList();
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
    }

    public void testNewArrayListWithCapacity() {
        ArrayList list = Lists.newArrayListWithCapacity((int)0);
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
        ArrayList bigger = Lists.newArrayListWithCapacity((int)256);
        ListsTest.assertEquals(Collections.emptyList(), (Object)bigger);
    }

    public void testNewArrayListWithCapacity_negative() {
        try {
            Lists.newArrayListWithCapacity((int)-1);
            ListsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewArrayListWithExpectedSize() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)0);
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
        ArrayList bigger = Lists.newArrayListWithExpectedSize((int)256);
        ListsTest.assertEquals(Collections.emptyList(), (Object)bigger);
    }

    public void testNewArrayListWithExpectedSize_negative() {
        try {
            Lists.newArrayListWithExpectedSize((int)-1);
            ListsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNewArrayListVarArgs() {
        ArrayList list = Lists.newArrayList((Object[])new Integer[]{0, 1, 1});
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testComputeArrayListCapacity() {
        ListsTest.assertEquals((int)5, (int)Lists.computeArrayListCapacity((int)0));
        ListsTest.assertEquals((int)13, (int)Lists.computeArrayListCapacity((int)8));
        ListsTest.assertEquals((int)89, (int)Lists.computeArrayListCapacity((int)77));
        ListsTest.assertEquals((int)22000005, (int)Lists.computeArrayListCapacity((int)20000000));
        ListsTest.assertEquals((int)Integer.MAX_VALUE, (int)Lists.computeArrayListCapacity((int)2147482647));
    }

    public void testNewArrayListFromCollection() {
        ArrayList list = Lists.newArrayList(SOME_COLLECTION);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewArrayListFromIterable() {
        ArrayList list = Lists.newArrayList(SOME_ITERABLE);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewArrayListFromIterator() {
        ArrayList list = Lists.newArrayList(SOME_COLLECTION.iterator());
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewLinkedListEmpty() {
        LinkedList list = Lists.newLinkedList();
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
    }

    public void testNewLinkedListFromCollection() {
        LinkedList list = Lists.newLinkedList(SOME_COLLECTION);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewLinkedListFromIterable() {
        LinkedList list = Lists.newLinkedList(SOME_ITERABLE);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testNewCOWALEmpty() {
        CopyOnWriteArrayList list = Lists.newCopyOnWriteArrayList();
        ListsTest.assertEquals(Collections.emptyList(), (Object)list);
    }

    public void testNewCOWALFromIterable() {
        CopyOnWriteArrayList list = Lists.newCopyOnWriteArrayList(SOME_ITERABLE);
        ListsTest.assertEquals(SOME_COLLECTION, (Object)list);
    }

    public void testArraysAsList() {
        ArrayList ourWay = Lists.newArrayList((Object[])new String[]{"foo", "bar", "baz"});
        List<String> otherWay = Arrays.asList("foo", "bar", "baz");
        ListsTest.assertEquals((Object)ourWay, otherWay);
        otherWay.set(0, "FOO");
        ListsTest.assertEquals((String)"FOO", (String)otherWay.get(0));
        try {
            otherWay.add("nope");
            ListsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            otherWay.remove(2);
            ListsTest.fail((String)"no exception thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static void assertIndexIsOutOfBounds(List<String> list, int index) {
        try {
            list.get(index);
            ListsTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testReverseViewRandomAccess() {
        ArrayList fromList = Lists.newArrayList(SOME_LIST);
        List toList = Lists.reverse((List)fromList);
        ListsTest.assertReverseView(fromList, toList);
    }

    public void testReverseViewSequential() {
        LinkedList fromList = Lists.newLinkedList(SOME_SEQUENTIAL_LIST);
        List toList = Lists.reverse((List)fromList);
        ListsTest.assertReverseView(fromList, toList);
    }

    private static void assertReverseView(List<Integer> fromList, List<Integer> toList) {
        fromList.set(0, 5);
        ListsTest.assertEquals(Arrays.asList(4, 3, 2, 5), toList);
        fromList.add(6);
        ListsTest.assertEquals(Arrays.asList(6, 4, 3, 2, 5), toList);
        fromList.add(2, 9);
        ListsTest.assertEquals(Arrays.asList(6, 4, 3, 9, 2, 5), toList);
        fromList.remove((Object)2);
        ListsTest.assertEquals(Arrays.asList(6, 4, 3, 9, 5), toList);
        fromList.remove(3);
        ListsTest.assertEquals(Arrays.asList(6, 3, 9, 5), toList);
        toList.remove(0);
        ListsTest.assertEquals(Arrays.asList(5, 9, 3), fromList);
        toList.add(7);
        ListsTest.assertEquals(Arrays.asList(7, 5, 9, 3), fromList);
        toList.add(5);
        ListsTest.assertEquals(Arrays.asList(5, 7, 5, 9, 3), fromList);
        toList.remove((Object)5);
        ListsTest.assertEquals(Arrays.asList(5, 7, 9, 3), fromList);
        toList.set(1, 8);
        ListsTest.assertEquals(Arrays.asList(5, 7, 8, 3), fromList);
        toList.clear();
        ListsTest.assertEquals(Collections.emptyList(), fromList);
    }

    public void testPartition_empty() {
        List source = Collections.emptyList();
        List partitions = Lists.partition(source, (int)1);
        ListsTest.assertTrue((boolean)partitions.isEmpty());
        ListsTest.assertEquals((int)0, (int)partitions.size());
    }

    public void testPartition_1_1() {
        List<Integer> source = Collections.singletonList(1);
        List partitions = Lists.partition(source, (int)1);
        ListsTest.assertEquals((int)1, (int)partitions.size());
        ListsTest.assertEquals(Collections.singletonList(1), partitions.get(0));
    }

    public void testPartition_1_2() {
        List<Integer> source = Collections.singletonList(1);
        List partitions = Lists.partition(source, (int)2);
        ListsTest.assertEquals((int)1, (int)partitions.size());
        ListsTest.assertEquals(Collections.singletonList(1), partitions.get(0));
    }

    public void testPartition_2_1() {
        List<Integer> source = Arrays.asList(1, 2);
        List partitions = Lists.partition(source, (int)1);
        ListsTest.assertEquals((int)2, (int)partitions.size());
        ListsTest.assertEquals(Collections.singletonList(1), partitions.get(0));
        ListsTest.assertEquals(Collections.singletonList(2), partitions.get(1));
    }

    public void testPartition_3_2() {
        List<Integer> source = Arrays.asList(1, 2, 3);
        List partitions = Lists.partition(source, (int)2);
        ListsTest.assertEquals((int)2, (int)partitions.size());
        ListsTest.assertEquals(Arrays.asList(1, 2), partitions.get(0));
        ListsTest.assertEquals(Arrays.asList(3), partitions.get(1));
    }

    public void testPartitionRandomAccessTrue() {
        List<Integer> source = Arrays.asList(1, 2, 3);
        List partitions = Lists.partition(source, (int)2);
        ListsTest.assertTrue((String)("partition should be RandomAccess, but not: " + partitions.getClass()), (boolean)(partitions instanceof RandomAccess));
        ListsTest.assertTrue((String)("partition[0] should be RandomAccess, but not: " + ((List)partitions.get(0)).getClass()), (boolean)(partitions.get(0) instanceof RandomAccess));
        ListsTest.assertTrue((String)("partition[1] should be RandomAccess, but not: " + ((List)partitions.get(1)).getClass()), (boolean)(partitions.get(1) instanceof RandomAccess));
    }

    public void testPartitionRandomAccessFalse() {
        LinkedList source = Lists.newLinkedList(Arrays.asList(1, 2, 3));
        List partitions = Lists.partition((List)source, (int)2);
        Truth.assertThat((Iterable)partitions).isNotInstanceOf(RandomAccess.class);
        Truth.assertThat((Iterable)((Iterable)partitions.get(0))).isNotInstanceOf(RandomAccess.class);
        Truth.assertThat((Iterable)((Iterable)partitions.get(1))).isNotInstanceOf(RandomAccess.class);
    }

    public void testPartition_view() {
        List<Integer> list = Arrays.asList(1, 2, 3);
        List partitions = Lists.partition(list, (int)3);
        list.set(0, 3);
        Iterator iterator = partitions.iterator();
        list.set(1, 4);
        List first = (List)iterator.next();
        list.set(2, 5);
        ListsTest.assertEquals(Arrays.asList(3, 4, 5), (Object)first);
        first.set(1, 6);
        ListsTest.assertEquals(Arrays.asList(3, 6, 5), list);
    }

    public void testPartitionSize_1() {
        List<Integer> list = Arrays.asList(1, 2, 3);
        ListsTest.assertEquals((int)1, (int)Lists.partition(list, (int)Integer.MAX_VALUE).size());
        ListsTest.assertEquals((int)1, (int)Lists.partition(list, (int)0x7FFFFFFE).size());
    }

    public void testPartitionSize_2() {
        ListsTest.assertEquals((int)2, (int)Lists.partition(Collections.nCopies(0x40000001, 1), (int)0x40000000).size());
    }

    private static class SomeFunction
    implements Function<Number, String>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private SomeFunction() {
        }

        public String apply(Number n) {
            return String.valueOf(n);
        }
    }

    private static class SomeIterable
    implements Iterable<Integer>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private SomeIterable() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return SOME_COLLECTION.iterator();
        }
    }

    private static final class RemoveFirstFunction
    implements Function<String, String>,
    Serializable {
        private RemoveFirstFunction() {
        }

        public String apply(String from) {
            return from.length() == 0 ? from : from.substring(1);
        }
    }
}

