/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.cache;

import cn.gtmap.common.cache.CacheBuilder;
import cn.gtmap.common.cache.CacheTesting;
import cn.gtmap.common.cache.LoadingCache;
import cn.gtmap.common.cache.LocalCache;
import cn.gtmap.common.cache.TestingCacheLoaders;
import cn.gtmap.common.cache.TestingRemovalListeners;
import cn.gtmap.common.cache.TestingWeighers;
import cn.gtmap.common.cache.Weigher;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class CacheEvictionTest
extends TestCase {
    static final int MAX_SIZE = 100;

    public void testEviction_setMaxSegmentSize() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        for (int i = 1; i < 1000; ++i) {
            LoadingCache cache = CacheBuilder.newBuilder().maximumSize((long)i).build(loader);
            CacheEvictionTest.assertEquals((int)i, (int)CacheTesting.getTotalSegmentSize(cache));
        }
    }

    public void testEviction_setMaxSegmentWeight() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        for (int i = 1; i < 1000; ++i) {
            LoadingCache cache = CacheBuilder.newBuilder().maximumWeight((long)i).weigher(TestingWeighers.constantWeigher(1)).build(loader);
            CacheEvictionTest.assertEquals((int)i, (int)CacheTesting.getTotalSegmentSize(cache));
        }
    }

    public void testEviction_maxSizeOneSegment() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(100L).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertEquals((long)Math.min(i + 1, 100), (long)cache.size());
        }
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxWeightOneSegment() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(200L).weigher(TestingWeighers.constantWeigher(2)).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertEquals((long)Math.min(i + 1, 100), (long)cache.size());
        }
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxSize() {
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(100L).removalListener(removalListener).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertTrue((cache.size() <= 100L ? 1 : 0) != 0);
        }
        CacheEvictionTest.assertEquals((int)100, (int)CacheTesting.accessQueueSize(cache));
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.processPendingNotifications(cache);
        CacheEvictionTest.assertEquals((int)100, (int)removalListener.getCount());
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxWeight() {
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().maximumWeight(200L).weigher(TestingWeighers.constantWeigher(2)).removalListener(removalListener).build(loader);
        for (int i = 0; i < 200; ++i) {
            cache.getUnchecked((Object)i);
            CacheEvictionTest.assertTrue((cache.size() <= 100L ? 1 : 0) != 0);
        }
        CacheEvictionTest.assertEquals((int)100, (int)CacheTesting.accessQueueSize(cache));
        CacheEvictionTest.assertEquals((long)100L, (long)cache.size());
        CacheTesting.processPendingNotifications(cache);
        CacheEvictionTest.assertEquals((int)100, (int)removalListener.getCount());
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxWeight_zero() {
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        Weigher<Integer, Integer> evensOnly = new Weigher<Integer, Integer>(){

            public int weigh(Integer k, Integer v) {
                return k % 2;
            }
        };
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(0L).weigher((Weigher)evensOnly).removalListener(removalListener).build(loader);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)1))).isEqualTo((Object)1);
        Truth.assertThat(cache.asMap().keySet()).isEmpty();
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)2))).isEqualTo((Object)2);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{2});
        CacheTesting.processPendingNotifications(cache);
        CacheTesting.checkValidState(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)4))).isEqualTo((Object)4);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{2, 4});
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)5))).isEqualTo((Object)5);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{2, 4});
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)2);
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_maxWeight_entryTooBig() {
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(4L).weigher(TestingWeighers.intValueWeigher()).removalListener(removalListener).build(loader);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)2))).isEqualTo((Object)2);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{2});
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)0);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)3))).isEqualTo((Object)3);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{3});
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)5))).isEqualTo((Object)5);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{3});
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)1))).isEqualTo((Object)1);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{3, 1});
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)2);
        Truth.assertThat((Integer)((Integer)cache.getUnchecked((Object)4))).isEqualTo((Object)4);
        Truth.assertThat(cache.asMap().keySet()).containsExactly(new Object[]{4});
        CacheTesting.processPendingNotifications(cache);
        Truth.assertThat((Integer)removalListener.getCount()).isEqualTo((Object)4);
        CacheTesting.checkValidState(cache);
    }

    public void testEviction_overflow() {
        TestingRemovalListeners.CountingRemovalListener removalListener = TestingRemovalListeners.countingRemovalListener();
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(0x80000000L).weigher(TestingWeighers.constantWeigher(Integer.MAX_VALUE)).removalListener(removalListener).build(loader);
        cache.getUnchecked(this.objectWithHash(0));
        cache.getUnchecked(this.objectWithHash(0));
        CacheTesting.processPendingNotifications(cache);
        CacheEvictionTest.assertEquals((int)1, (int)removalListener.getCount());
    }

    public void testUpdateRecency_onGet() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        final LoadingCache cache = CacheBuilder.newBuilder().maximumSize(100L).build(loader);
        CacheTesting.checkRecency((LoadingCache<Integer, Integer>)cache, 100, new CacheTesting.Receiver<LocalCache.ReferenceEntry<Integer, Integer>>(){

            @Override
            public void accept(LocalCache.ReferenceEntry<Integer, Integer> entry) {
                cache.getUnchecked(entry.getKey());
            }
        });
    }

    public void testUpdateRecency_onInvalidate() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        final LoadingCache cache = CacheBuilder.newBuilder().maximumSize(100L).concurrencyLevel(1).build(loader);
        CacheTesting.checkRecency((LoadingCache<Integer, Integer>)cache, 100, new CacheTesting.Receiver<LocalCache.ReferenceEntry<Integer, Integer>>(){

            @Override
            public void accept(LocalCache.ReferenceEntry<Integer, Integer> entry) {
                Integer key = (Integer)entry.getKey();
                cache.invalidate((Object)key);
            }
        });
    }

    public void testEviction_lru() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(10L).build(loader);
        CacheTesting.warmUp((LoadingCache<Integer, Integer>)cache, 0, 10);
        Set keySet = cache.asMap().keySet();
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{3, 4, 5, 6, 7, 8, 9, 0, 1, 2});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(10, 11, 12));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{6, 7, 8, 9, 0, 1, 2, 10, 11, 12});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(6, 7, 8));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{9, 0, 1, 2, 10, 11, 12, 6, 7, 8});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(13, 14, 15));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{2, 10, 11, 12, 6, 7, 8, 13, 14, 15});
    }

    public void testEviction_weightedLru() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(45L).weigher(TestingWeighers.intKeyWeigher()).build(loader);
        CacheTesting.warmUp((LoadingCache<Integer, Integer>)cache, 0, 10);
        Set keySet = cache.asMap().keySet();
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{3, 4, 5, 6, 7, 8, 9, 0, 1, 2});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(10));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{6, 7, 8, 9, 0, 1, 2, 10});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(6, 7, 8));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{9, 0, 1, 2, 10, 6, 7, 8});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(15));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 6, 7, 8, 15});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(9));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 6, 7, 8, 15, 9});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(1));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 7, 8, 15, 9, 1});
    }

    public void testEviction_overweight() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumWeight(45L).weigher(TestingWeighers.intKeyWeigher()).build(loader);
        CacheTesting.warmUp((LoadingCache<Integer, Integer>)cache, 0, 10);
        Set keySet = cache.asMap().keySet();
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(45));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 45});
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(46));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).contains((Object)0);
    }

    public void testEviction_invalidateAll() {
        TestingCacheLoaders.IdentityLoader loader = TestingCacheLoaders.identityLoader();
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(10L).build(loader);
        Set keySet = cache.asMap().keySet();
        Truth.assertThat(keySet).isEmpty();
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(0, 1, 2, 3, 4));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{0, 1, 2, 3, 4});
        cache.invalidateAll();
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).isEmpty();
        CacheEvictionTest.getAll((LoadingCache<Integer, Integer>)cache, Arrays.asList(5, 6, 7, 8, 9, 10, 11, 12));
        CacheTesting.drainRecencyQueues(cache);
        Truth.assertThat(keySet).containsExactly(new Object[]{5, 6, 7, 8, 9, 10, 11, 12});
    }

    private static void getAll(LoadingCache<Integer, Integer> cache, List<Integer> keys) {
        for (int i : keys) {
            cache.getUnchecked((Object)i);
        }
    }

    private Object objectWithHash(final int hash) {
        return new Object(){

            public int hashCode() {
                return hash;
            }
        };
    }
}

