/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.cache;

import cn.gtmap.common.base.basis.Ticker;
import cn.gtmap.common.cache.CacheBuilder;
import cn.gtmap.common.cache.CacheLoader;
import cn.gtmap.common.cache.CacheTesting;
import cn.gtmap.common.cache.LoadingCache;
import cn.gtmap.common.cache.LocalCache;
import cn.gtmap.common.cache.TestingCacheLoaders;
import cn.gtmap.common.cache.TestingWeighers;
import cn.gtmap.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;

public class CacheBuilderTest
extends TestCase {
    public void testInitialCapacity_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.initialCapacity(-1);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInitialCapacity_setTwice() {
        CacheBuilder builder = new CacheBuilder().initialCapacity(16);
        try {
            builder.initialCapacity(16);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testInitialCapacity_small() {
        LoadingCache cache = CacheBuilder.newBuilder().initialCapacity(5).build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[0].table.length());
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[1].table.length());
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[2].table.length());
        CacheBuilderTest.assertEquals((int)2, (int)map.segments[3].table.length());
    }

    public void testInitialCapacity_smallest() {
        LoadingCache cache = CacheBuilder.newBuilder().initialCapacity(0).build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[0].table.length());
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[1].table.length());
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[2].table.length());
        CacheBuilderTest.assertEquals((int)1, (int)map.segments[3].table.length());
    }

    public void testInitialCapacity_large() {
        CacheBuilder.newBuilder().initialCapacity(Integer.MAX_VALUE);
    }

    public void testConcurrencyLevel_zero() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.concurrencyLevel(0);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConcurrencyLevel_setTwice() {
        CacheBuilder builder = new CacheBuilder().concurrencyLevel(16);
        try {
            builder.concurrencyLevel(16);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testConcurrencyLevel_small() {
        LoadingCache cache = CacheBuilder.newBuilder().concurrencyLevel(1).build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(1);
    }

    public void testConcurrencyLevel_large() {
        CacheBuilder.newBuilder().concurrencyLevel(Integer.MAX_VALUE);
    }

    public void testMaximumSize_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.maximumSize(-1L);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMaximumSize_setTwice() {
        CacheBuilder builder = new CacheBuilder().maximumSize(16L);
        try {
            builder.maximumSize(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMaximumSize_andWeight() {
        CacheBuilder builder = new CacheBuilder().maximumSize(16L);
        try {
            builder.maximumWeight(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMaximumWeight_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.maximumWeight(-1L);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMaximumWeight_setTwice() {
        CacheBuilder builder = new CacheBuilder().maximumWeight(16L);
        try {
            builder.maximumWeight(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            builder.maximumSize(16L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMaximumWeight_withoutWeigher() {
        CacheBuilder builder = new CacheBuilder().maximumWeight(1L);
        try {
            builder.build(TestingCacheLoaders.identityLoader());
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testWeigher_withoutMaximumWeight() {
        CacheBuilder builder = new CacheBuilder().weigher(TestingWeighers.constantWeigher(42));
        try {
            builder.build(TestingCacheLoaders.identityLoader());
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testWeigher_withMaximumSize() {
        try {
            new CacheBuilder().weigher(TestingWeighers.constantWeigher(42)).maximumSize(1L);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            new CacheBuilder().maximumSize(1L).weigher(TestingWeighers.constantWeigher(42));
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testKeyStrengthSetTwice() {
        CacheBuilder builder1 = new CacheBuilder().weakKeys();
        try {
            builder1.weakKeys();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValueStrengthSetTwice() {
        CacheBuilder builder1 = new CacheBuilder().weakValues();
        try {
            builder1.weakValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            builder1.softValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CacheBuilder builder2 = new CacheBuilder().softValues();
        try {
            builder2.softValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            builder2.weakValues();
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTimeToLive_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.expireAfterWrite(-1L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTimeToLive_small() {
        CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.NANOSECONDS).build(TestingCacheLoaders.identityLoader());
    }

    public void testTimeToLive_setTwice() {
        CacheBuilder builder = new CacheBuilder().expireAfterWrite(3600L, TimeUnit.SECONDS);
        try {
            builder.expireAfterWrite(3600L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTimeToIdle_negative() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.expireAfterAccess(-1L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTimeToIdle_small() {
        CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.NANOSECONDS).build(TestingCacheLoaders.identityLoader());
    }

    public void testTimeToIdle_setTwice() {
        CacheBuilder builder = new CacheBuilder().expireAfterAccess(3600L, TimeUnit.SECONDS);
        try {
            builder.expireAfterAccess(3600L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTimeToIdleAndToLive() {
        CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.NANOSECONDS).expireAfterAccess(1L, TimeUnit.NANOSECONDS).build(TestingCacheLoaders.identityLoader());
    }

    public void testRefresh_zero() {
        CacheBuilder builder = new CacheBuilder();
        try {
            builder.refreshAfterWrite(0L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRefresh_setTwice() {
        CacheBuilder builder = new CacheBuilder().refreshAfterWrite(3600L, TimeUnit.SECONDS);
        try {
            builder.refreshAfterWrite(3600L, TimeUnit.SECONDS);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testTicker_setTwice() {
        Ticker testTicker = Ticker.systemTicker();
        CacheBuilder builder = new CacheBuilder().ticker(testTicker);
        try {
            builder.ticker(testTicker);
            CacheBuilderTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testValuesIsNotASet() {
        CacheBuilderTest.assertFalse((boolean)(new CacheBuilder().build().asMap().values() instanceof Set));
    }

    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        CacheBuilder builder = new CacheBuilder();
        tester.testAllPublicInstanceMethods(builder);
    }

    public void testSizingDefaults() {
        LoadingCache cache = CacheBuilder.newBuilder().build(TestingCacheLoaders.identityLoader());
        LocalCache map = CacheTesting.toLocalCache(cache);
        Truth.assertThat((Object[])map.segments).hasLength(4);
        CacheBuilderTest.assertEquals((int)4, (int)map.segments[0].table.length());
    }

    static final class DelayingIdentityLoader<T>
    extends CacheLoader<T, T> {
        private final AtomicBoolean shouldWait;
        private final CountDownLatch delayLatch;

        DelayingIdentityLoader(AtomicBoolean shouldWait, CountDownLatch delayLatch) {
            this.shouldWait = shouldWait;
            this.delayLatch = delayLatch;
        }

        public T load(T key) throws InterruptedException {
            if (this.shouldWait.get()) {
                this.delayLatch.await();
            }
            return key;
        }
    }
}

