/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.base;

import cn.gtmap.common.base.Throwables;
import cn.gtmap.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import junit.framework.TestCase;

public class ThrowablesTest
extends TestCase {
    public void testThrowIfUnchecked_Unchecked() {
        try {
            Throwables.throwIfUnchecked((Throwable)new SomeUncheckedException());
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testThrowIfUnchecked_Error() {
        try {
            Throwables.throwIfUnchecked((Throwable)new SomeError());
            ThrowablesTest.fail();
        }
        catch (SomeError someError) {
            // empty catch block
        }
    }

    public void testThrowIfUnchecked_Checked() {
        Throwables.throwIfUnchecked((Throwable)new SomeCheckedException());
    }

    public void testPropagateIfPossible_NoneDeclared_NoneThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.noneDeclared();
    }

    public void testPropagateIfPossible_NoneDeclared_UncheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_NoneDeclared_UndeclaredThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUndeclaredChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeChainingException someChainingException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_OneDeclared_NoneThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.oneDeclared();
    }

    public void testPropagateIfPossible_OneDeclared_UncheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_OneDeclared_CheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_OneDeclared_UndeclaredThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUndeclaredChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeChainingException someChainingException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_TwoDeclared_NoneThrown() throws SomeCheckedException, SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        sample.twoDeclared();
    }

    public void testPropagateIfPossible_TwoDeclared_UncheckedThrown() throws SomeCheckedException, SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_TwoDeclared_CheckedThrown() throws SomeOtherCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfPossible_TwoDeclared_OtherCheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsOtherChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfPossible((Throwable)t, SomeCheckedException.class, SomeOtherCheckedException.class);
                    throw new SomeChainingException(t);
                }
            }
        };
        try {
            sample.twoDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeOtherCheckedException someOtherCheckedException) {
            // empty catch block
        }
    }

    public void testThrowIfUnchecked_null() throws SomeCheckedException {
        try {
            Throwables.throwIfUnchecked(null);
            ThrowablesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPropageIfPossible_null() throws SomeCheckedException {
        Throwables.propagateIfPossible(null);
    }

    public void testPropageIfPossible_OneDeclared_null() throws SomeCheckedException {
        Throwables.propagateIfPossible(null, SomeCheckedException.class);
    }

    public void testPropageIfPossible_TwoDeclared_null() throws SomeCheckedException {
        Throwables.propagateIfPossible(null, SomeCheckedException.class, SomeUncheckedException.class);
    }

    public void testPropagate_NoneDeclared_NoneThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        sample.noneDeclared();
    }

    public void testPropagate_NoneDeclared_UncheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagate_NoneDeclared_ErrorThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsError();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeError someError) {
            // empty catch block
        }
    }

    public void testPropagate_NoneDeclared_CheckedThrown() {
        Sample sample = new Sample(){

            @Override
            public void noneDeclared() {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.noneDeclared();
            ThrowablesTest.fail();
        }
        catch (RuntimeException expected) {
            ThrowablesTest.assertTrue((boolean)(expected.getCause() instanceof SomeCheckedException));
        }
    }

    public void testThrowIfInstanceOf_Unchecked() throws SomeCheckedException {
        Throwables.throwIfInstanceOf((Throwable)new SomeUncheckedException(), SomeCheckedException.class);
    }

    public void testThrowIfInstanceOf_CheckedDifferent() throws SomeCheckedException {
        Throwables.throwIfInstanceOf((Throwable)new SomeOtherCheckedException(), SomeCheckedException.class);
    }

    public void testThrowIfInstanceOf_CheckedSame() {
        try {
            Throwables.throwIfInstanceOf((Throwable)new SomeCheckedException(), SomeCheckedException.class);
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testThrowIfInstanceOf_CheckedSubclass() {
        try {
            Throwables.throwIfInstanceOf((Throwable)new SomeCheckedException(){}, SomeCheckedException.class);
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfInstanceOf_NoneThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatDoesntThrowAnything();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        sample.oneDeclared();
    }

    public void testPropagateIfInstanceOf_DeclaredThrown() {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeCheckedException someCheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfInstanceOf_UncheckedThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsUnchecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (SomeUncheckedException someUncheckedException) {
            // empty catch block
        }
    }

    public void testPropagateIfInstanceOf_UndeclaredThrown() throws SomeCheckedException {
        Sample sample = new Sample(){

            @Override
            public void oneDeclared() throws SomeCheckedException {
                try {
                    ThrowablesTest.methodThatThrowsOtherChecked();
                }
                catch (Throwable t) {
                    Throwables.propagateIfInstanceOf((Throwable)t, SomeCheckedException.class);
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
        try {
            sample.oneDeclared();
            ThrowablesTest.fail();
        }
        catch (RuntimeException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(SomeOtherCheckedException.class);
        }
    }

    public void testThrowIfInstanceOf_null() throws SomeCheckedException {
        try {
            Throwables.throwIfInstanceOf(null, SomeCheckedException.class);
            ThrowablesTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPropageIfInstanceOf_null() throws SomeCheckedException {
        Throwables.propagateIfInstanceOf(null, SomeCheckedException.class);
    }

    public void testGetRootCause_NoCause() {
        SomeCheckedException exception = new SomeCheckedException();
        ThrowablesTest.assertSame((Object)exception, (Object)Throwables.getRootCause((Throwable)exception));
    }

    public void testGetRootCause_SingleWrapped() {
        SomeCheckedException cause = new SomeCheckedException();
        SomeChainingException exception = new SomeChainingException(cause);
        ThrowablesTest.assertSame((Object)cause, (Object)Throwables.getRootCause((Throwable)exception));
    }

    public void testGetRootCause_DoubleWrapped() {
        SomeCheckedException cause = new SomeCheckedException();
        SomeChainingException exception = new SomeChainingException(new SomeChainingException(cause));
        ThrowablesTest.assertSame((Object)cause, (Object)Throwables.getRootCause((Throwable)exception));
    }

    static void methodThatDoesntThrowAnything() {
    }

    static void methodThatThrowsError() {
        throw new SomeError();
    }

    static void methodThatThrowsUnchecked() {
        throw new SomeUncheckedException();
    }

    static void methodThatThrowsChecked() throws SomeCheckedException {
        throw new SomeCheckedException();
    }

    static void methodThatThrowsOtherChecked() throws SomeOtherCheckedException {
        throw new SomeOtherCheckedException();
    }

    static void methodThatThrowsUndeclaredChecked() throws SomeUndeclaredCheckedException {
        throw new SomeUndeclaredCheckedException();
    }

    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(Throwables.class);
    }

    static class Sample {
        Sample() {
        }

        void noneDeclared() {
        }

        void oneDeclared() throws SomeCheckedException {
        }

        void twoDeclared() throws SomeCheckedException, SomeOtherCheckedException {
        }
    }

    private static class SomeChainingException
    extends RuntimeException {
        public SomeChainingException(Throwable cause) {
            super(cause);
        }
    }

    private static class SomeUndeclaredCheckedException
    extends Exception {
        private SomeUndeclaredCheckedException() {
        }
    }

    private static class SomeUncheckedException
    extends RuntimeException {
        private SomeUncheckedException() {
        }
    }

    private static class SomeOtherCheckedException
    extends Exception {
        private SomeOtherCheckedException() {
        }
    }

    private static class SomeCheckedException
    extends Exception {
        private SomeCheckedException() {
        }
    }

    private static class SomeError
    extends Error {
        private SomeError() {
        }
    }
}

