/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.subsidy.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.ret.common.model.subsidy.TbFwqlr;
import cn.gtmap.estateplat.ret.common.model.subsidy.TbFwxx;
import cn.gtmap.estateplat.ret.common.model.subsidy.TbGfhtbt;
import cn.gtmap.estateplat.ret.common.model.subsidy.TbHtbtsh;
import cn.gtmap.estateplat.subsidy.mapper.ExistingHomeMapper;
import cn.gtmap.estateplat.subsidy.model.AddOrUpdateVo;
import cn.gtmap.estateplat.subsidy.service.ExistingHomeService;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExistingHomeServiceImpl
implements ExistingHomeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExistingHomeServiceImpl.class);
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private ExistingHomeMapper existingHomeMapper;

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdate(AddOrUpdateVo addOrUpdateVo) {
        TbFwxx tbFwxx;
        String fwxxid;
        TbFwqlr tbFwqlr;
        String qlrid;
        TbGfhtbt tbGfhtbt = addOrUpdateVo.getTbGfhtbtb();
        String btid = tbGfhtbt.getBtid();
        if ("".equals(btid) || null == btid) {
            btid = UUIDGenerator.generate18();
        }
        if ("".equals(qlrid = (tbFwqlr = addOrUpdateVo.getTbFwqlr()).getQlrid()) || null == qlrid) {
            qlrid = UUIDGenerator.generate18();
        }
        if ("".equals(fwxxid = (tbFwxx = addOrUpdateVo.getTbFwxx()).getFwxxid()) || null == fwxxid) {
            fwxxid = UUIDGenerator.generate18();
        }
        try {
            this.entityMapper.saveOrUpdate((Object)tbGfhtbt, (Object)btid);
            this.entityMapper.saveOrUpdate((Object)tbFwqlr, (Object)qlrid);
            this.entityMapper.saveOrUpdate((Object)tbFwxx, (Object)fwxxid);
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u6216\u4fee\u6539\u8865\u8d34" + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(String btid, String status, String shbh) {
        UserInfo userInfo = null;
        try {
            userInfo = SessionUtil.getCurrentUser();
        }
        catch (Exception e) {
            LOGGER.info("\u7528\u6237\u4fe1\u606f\uff1a", (Throwable)e);
        }
        Date date = new Date();
        TbHtbtsh tbHtbtsh = new TbHtbtsh();
        tbHtbtsh.setBtbh(shbh);
        tbHtbtsh.setCjrid(userInfo.getId());
        tbHtbtsh.setShzt(status);
        tbHtbtsh.setShid(UUIDGenerator.generate18());
        tbHtbtsh.setShr(userInfo.getUsername());
        tbHtbtsh.setXgsj(date);
        tbHtbtsh.setShsj(date);
        try {
            this.entityMapper.saveOrUpdate((Object)tbHtbtsh, (Object)tbHtbtsh.getShid());
            this.existingHomeMapper.updateStatus(btid, status);
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u72b6\u6001" + e.getMessage(), (Throwable)e);
        }
    }

    public void delet(String btid) {
        this.entityMapper.deleteByPrimaryKey(TbGfhtbt.class, (Object)btid);
    }
}

