<@com.html title="证明单信息列表" import="fr,ace,jqueryVersion">
<style>
    /*移动modal样式*/
    #logSearchPop .modal-dialog {
        width: 650px;
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        z-index: 1050;
        -webkit-overflow-scrolling: touch;
        outline: 0;
    }

    /*高级搜索的样式修改*/
    .btn01:hover {
        background-color: #c7c7c7;
        text-decoration: none;
        color: #333;
    }

    .btn01 {
        display: inline-block;
        padding: 4px 12px;
        margin-bottom: 0;
        font-size: 14px;
        color: #333333;
        text-align: center;
        vertical-align: middle;
        cursor: pointer;
        background-color: #f2f2f2;
        border: 1px solid #aaa;
        webkit-border-radius: 0px !important;
        -moz-border-radius: 0px !important;
        border-radius: 0px !important;
    }

    input[type="text"] {
        border-radius: 0 !important;
        color: #858585;
        background-color: #fff;
        border: 0px solid #d5d5d5;
        font-size: 14px;
        font-family: inherit;
        -webkit-box-shadow: none !important;
        box-shadow: none !important;
        -webkit-transition-duration: .1s;
        transition-duration: .1 smargin;
        margin: 1px 5px 1px 5px;
    }

    .print {
        border: 0px !important;
        padding-left: 20px;
    }

    /*表单样式重写*/
    form input[type='text'], select, textarea {
        border-radius: 4px !important;
        width;
        100% !important;
    }

    pre, input[type="text"] {
        padding: 0px !important;
    }

    .modelFooter {
        background: none;
        border-top: 1px solid #e5e5e5;
        padding: 10px;
        text-align: center;
    }

    .form .row {
        margin: 10px 0px 10px 0px;
    }

    .form .row .col-xs-2 {
        padding-left: 0px;
        padding-right: 4px;
        text-align: right;
    }

    .form .row .col-xs-4, .col-xs-10 {
        padding-left: 0px;
        padding-right: 0px;
    }

    label {
        font-weight: bold;
    }

    /*日期表单样式*/
    .dropdown-menu {
        z-index: 10000 !important;
    }

    .input-icon {
        border: 0px;
        height: 34px;
        width: 100px;
        font-size: 10px;
    }

    .ace-settings-box.open {
        max-width: 1000px;
        padding: 0 0px;
    }
</style>

<script type="text/javascript">

    _$(function () {

        //初始化权利信息列表
        logTableInit();
        /*   文字水印  */
        _$(".watermarkText").watermark();
        //查询按钮点击事件
        _$("#search").click(function () {
            var searchInfo = _$("#searchInfo").val();
            var workflowProid = "${workflowProid!}";
            var logUrl = "${bdcdjUrl}/bdcZsResource/getZmdData?workflowProid=" + workflowProid;
            tableReload("log-grid-table", logUrl, {zl: encodeURI(searchInfo)});
        })

        var width = _$(window).width() / 2;
        if (width < 1000) {
            width = 1000;
        }
        var height = _$(window).height() - 20;
        _$("#ace-settings-box").css("width", width).css("height", height);
        _$(window).resize(function () {
            var width = _$(window).width() / 2;
            if (width < 1000) {
                width = 1000;
            }
            var height = _$(window).height() - 20;
            _$("#ace-settings-box").css("width", width).css("height", height);
        })

        //定位
        _$("#ace-settings-btn").click(function () {
            if (_$("#ace-settings-box").hasClass("open")) {
                setTimeout(function () {
                    _$("#iframe").attr("src", _$("#iframeSrcUrl").val())
                }, 500);
            }
        })

        //resize to fit page size
        _$(window).on('resize.jqGrid', function () {
            var contentWidth;
            if (_$("#mainContent").width() > 0) {
                contentWidth = _$("#mainContent").width();
            }
            _$("#log-grid-table").jqGrid('setGridWidth', contentWidth);
        });
        _$("#plprint").click(function () {
            var wiid = "${wiid!}";
            var startNum = _$("#startNum").val();
            var endNum = _$("#endNum").val();
            if (endNum == '' && startNum == '') {
                startNum = '99999';
                endNum = '99999';
            } else if (endNum == '' && startNum != '') {
                endNum = '99999';
            } else if (endNum != '' && startNum == '') {
                startNum = '1';
            }
            var printUrl = "${bdcdjUrl}/bdcPrint/printBdcqz?wiid=" + wiid + "&zslx=zmd&hiddeMode=true" + "&startNum=" + startNum + "&endNum=" + endNum;
            window.location.href = "eprt://" + printUrl;
        });
    })
    //选择数据的事件
    function sel(proid, bdcdyid) {
        if (proid != '' && proid != undefined && bdcdyid != '' && bdcdyid != undefined) {
            var rid = "${rid!}";
            var taskid = "${taskid!}";
            var from = "${from!}";
            var wiid = "${wiid!}";
            var url = "${bdcdjUrl}/bdcZsResource?from=" + from + "&taskid=" + taskid + "&proid=" + proid + "&wiid=" + wiid + "&rid=" + rid + "&getSimpleCpt=zmd&bdcdyid=" + bdcdyid;
            _$("#iframeSrcUrl").val(url);
            if (_$("#ace-settings-box").hasClass("open")) {
                _$("#iframe").attr("src", url);
            } else {
                _$("#ace-settings-box").click();
            }
        }
    }

    function tableReload(table, Url, data) {
        var jqgrid = _$("#" + table);
        jqgrid.setGridParam({url: Url, datatype: 'json', page: 1, postData: data});
        jqgrid.trigger("reloadGrid");//重新加载JqGrid
    }


    function logTableInit() {
        var grid_selector = "#log-grid-table";
        var pager_selector = "#log-grid-pager";
        var workflowProid = "${workflowProid!}";
        var parent_column = _$(grid_selector).closest('[class*="col-"]');
        _$(document).on('settings.ace.jqGrid', function (ev, event_name, collapsed) {
            if (event_name === 'sidebar_collapsed' || event_name === 'main_container_fixed') {
                _$(grid_selector).jqGrid('setGridWidth', parent_column.width());
            }
        });
        _$(grid_selector).jqGrid({
            url: "${bdcdjUrl}/bdcZsResource/getZmdData?workflowProid=" + workflowProid,
            datatype: "json",
            height: 'auto',
            jsonReader: {id: 'BDCDYID'},
            colNames: ['序列', '坐落', '不动产单元号', "权利人", "定着物面积", '规划用途', 'ID'],
            colModel: [
                {
                    name: 'XL',
                    index: '',
                    width: '10%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        return '<span style="font-family: cursive;"> ' + rowObject.ROWNUM_ + '. </span><input type="radio" name="xl" onclick="sel(\'' + rowObject.PROID + '\',\'' + rowObject.BDCDYID + '\')"/>'
                    }
                },
                {name: 'ZL', index: 'ZL', width: '25%', sortable: false},
                {
                    name: 'BDCDYH',
                    index: 'BDCDYH',
                    width: '20%',
                    sortable: false,
                    formatter: function (cellvalue, options, rowObject) {
                        var value = cellvalue.substr(0, 6) + " " + cellvalue.substr(6, 6) + " " + cellvalue.substr(12, 7) + " " + cellvalue.substr(19);
                        return value;
                    }
                },
                {name: 'QLR', index: 'QLR', width: '20%', sortable: false},
                {name: 'DJZWMJ', index: 'DJZWMJ', width: '10%', sortable: false},
                {name: 'GHYT', index: 'GHYT', width: '15%', sortable: false},
                {name: 'BDCDYID', index: 'BDCDYID', width: '0%', sortable: false, hidden: true}
            ],
            viewrecords: true,
            rowNum: 10,
            rowList: [10, 20, 30],
            pager: pager_selector,
            pagerpos: "left",
            altRows: false,
            rownumbers: false,
            rownumWidth: 50,
            multiboxonly: false,
            multiselect: false,
            loadComplete: function () {
                var table = this;
                setTimeout(function () {
                    updatePagerIcons(table);
                    enableTooltips(table);
                }, 0);
            },
            editurl: "",
            caption: "",
            autowidth: true
        });
    }

    function enableTooltips(table) {
        _$('.navtable .ui-pg-button').tooltip({container: 'body'});
        _$(table).find('.ui-pg-div').tooltip({container: 'body'});
    }

    function updatePagerIcons(table) {
        var replacement =
                {
                    'ui-icon-seek-first': 'ace-icon fa fa-angle-double-left bigger-140',
                    'ui-icon-seek-prev': 'ace-icon fa fa-angle-left bigger-140',
                    'ui-icon-seek-next': 'ace-icon fa fa-angle-right bigger-140',
                    'ui-icon-seek-end': 'ace-icon fa fa-angle-double-right bigger-140'
                };
        _$('.ui-pg-table:not(.navtable) > tbody > tr > .ui-pg-button > .ui-icon').each(function () {
            var icon = _$(this);
            var $class = _$.trim(icon.attr('class').replace('ui-icon', ''));
            if ($class in replacement) icon.attr('class', 'ui-icon ' + replacement[$class]);
        })
    }
</script>
<div class="main-container">
    <div class="space-8"></div>
    <div class="page-content" id="mainContent">
    <#--图形-->
        <div class="ace-settings-container" id="ace-settings-container">
            <div class="btn btn-app btn-xs btn-warning ace-settings-btn open" id="ace-settings-btn">
                <i class="ace-icon fa fa-globe blue bigger-200"></i>
            </div>

            <div class="ace-settings-box clearfix " id="ace-settings-box">
                <iframe src="" style="width: 100%;height: 100%" id="iframe"></iframe>
            </div>
            <!-- /.ace-settings-box -->
        </div>
        <div class="simpleSearch">
            <table cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>
                        <input type="text" class="SSinput watermarkText" id="searchInfo" data-watermark="请输入坐落/不动产单元号">
                    </td>
                    <td class="Search">
                        <a href="#" id="search">
                            搜索
                            <i class="ace-icon fa fa-search bigger-130"></i>
                        </a>
                    </td>

                    <td>
                        <input type="text" id="startNum" class="input-icon " data-watermark="请输入开始编号"
                               onkeyup="value=value.replace(/[^\d]/g,'')">
                    </td>

                    <td>
                        <input type="text" id="endNum" class="input-icon " data-watermark="请输入结束编号"
                               onkeyup="value=value.replace(/[^\d]/g,'')">
                    </td>

                    <td class="print">
                        <button id="plprint" class="btn01 AdvancedButton" value="批量打印">批量打印</button>
                    </td>
                </tr>
            </table>
        </div>
        <table id="log-grid-table"></table>
        <div id="log-grid-pager"></div>
    </div>
</div>
<input type="hidden" id="iframeSrcUrl">
<div style="display: none">
    <ul>
        <#list proidList as proids>
            <li>
            ${proids}
            </li>
        </#list>
    </ul>
</div>
<#--无用div 防止ace报错-->
<div id="navbar" class="navbar navbar-default" hidden="hidden"></div>
</@com.html>
