/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.web.query;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.model.server.core.BdcGdxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.service.BdcGdxxService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.service.ArchivePostService;
import cn.gtmap.estateplat.server.web.main.BaseController;
import com.gtis.config.AppConfig;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BdcGdxx"})
public class BdcGdxxController
extends BaseController {
    @Autowired
    BdcGdxxService bdcGdxxService;
    @Autowired
    BdcXmService bdcXmService;
    @Autowired
    private ArchivePostService archivePostService;
    @Autowired
    private Repo repository;
    @Autowired
    private EntityMapper entityMapper;

    @RequestMapping(value={"/list"})
    public String index(Model model) {
        String gjcx = AppConfig.getProperty((String)"GD_GJCX");
        if (StringUtils.isNotBlank((CharSequence)gjcx) && StringUtils.equals((CharSequence)"true", (CharSequence)gjcx)) {
            model.addAttribute("gjcx", (Object)"true");
        }
        model.addAttribute("isgd", (Object)"0");
        return "query/bdcGdxxListV2";
    }

    @ResponseBody
    @RequestMapping(value={"/getGdxxPagesJson"})
    public Object getGdxxPagesJson(Pageable pageable, String xmmc, String bdcdyh, String bdcqzh, String zl, String isgd, String searchText) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchText})) {
            map.put("searchText", searchText);
        } else {
            map.put("xmmc", xmmc);
            map.put("bdcdyh", bdcdyh);
            map.put("bdcqzh", bdcqzh);
            map.put("zl", zl);
            map.put("isgd", isgd);
        }
        Page dataPaging = this.repository.selectPaging("getGdxxByPage", map, pageable);
        return dataPaging;
    }

    @ResponseBody
    @RequestMapping(value={"/bdcXmGd"})
    public String bdcXmGd(Model model, String proids) {
        String msg = "\u5f52\u6863\u6210\u529f";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proids})) {
            String[] proid = proids.split(",");
            for (int i = 0; i < proid.length; ++i) {
                BdcGdxx bdcGdxx;
                if (!this.bdcGdxxService.checkIsGd(proid[i])) {
                    msg = "\u5df2\u7ecf\u5f52\u6863\uff0c\u4e0d\u80fd\u91cd\u590d\u5f52\u6863\uff01";
                    continue;
                }
                BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid[i]);
                if (bdcXm == null || !StringUtils.isBlank((CharSequence)(bdcGdxx = this.archivePostService.postBdcXmInfo(bdcXm)).getDaid())) continue;
                msg = "";
            }
        }
        return msg;
    }

    @ResponseBody
    @RequestMapping(value={"/bdcXmGdOne"})
    public String bdcXmGdOne(Model model, String proid) {
        BdcGdxx bdcGdxx;
        BdcXm bdcXm;
        String msg = "\u5f52\u6863\u6210\u529f";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proid}) && (bdcXm = this.bdcXmService.getBdcXmByProid(proid)) != null && StringUtils.isBlank((CharSequence)(bdcGdxx = this.archivePostService.postBdcXmInfo(bdcXm)).getDaid())) {
            msg = "";
        }
        return msg;
    }

    @ResponseBody
    @RequestMapping(value={"/checkBdcXmIsGd"})
    public String checkBdcXmIsGd(Model model, String proid) {
        String msg = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proid}) && !this.bdcGdxxService.checkIsGd(proid)) {
            msg = "\u5df2\u7ecf\u5f52\u6863\uff0c\u4e0d\u80fd\u91cd\u590d\u5f52\u6863\uff01";
        }
        return msg;
    }
}

