/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.web.main;

import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.repository.Repo;
import cn.gtmap.estateplat.server.core.mapper.BdcZmMapper;
import cn.gtmap.estateplat.server.web.main.BaseController;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/zm"})
public class ZmController
extends BaseController {
    @Autowired
    private Repo repository;
    @Autowired
    private BdcZmMapper bdcZmMapper;
    @Autowired
    private SysAuthorService sysAuthorService;

    @RequestMapping(value={"/zm"})
    public String index(Model model, String rid) {
        List zmmcList = this.bdcZmMapper.getZmMc();
        UserInfo info = SessionUtil.getCurrentUser();
        String roleIds = info.getRoleIds();
        if (StringUtils.isBlank((CharSequence)roleIds)) {
            roleIds = "'" + this.getRoleIdsByUser(info.getId()) + "'";
        }
        List list = null;
        if (StringUtils.isNotBlank((CharSequence)rid)) {
            if (rid.indexOf("r:") > -1) {
                rid = rid.replaceAll("r:", "");
            }
            list = this.sysAuthorService.getSystemResrouceFunAuthorList(roleIds, rid);
        }
        model.addAttribute("zmmcList", (Object)zmmcList);
        model.addAttribute("authorList", (Object)JSONObject.toJSONString(list));
        return "query/zmList";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/delBdcZm"})
    public HashMap<String, Object> delBdcZm(Model model, String id) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String result = "\u5220\u9664\u6210\u529f\uff01";
        try {
            if (StringUtils.isNotBlank((CharSequence)id)) {
                this.bdcZmMapper.delBdcZmByZmid(id);
            }
            resultMap.put("result", result);
        }
        catch (Exception e) {
            try {
                result = "\u5220\u9664\u5931\u8d25\uff01";
                e.printStackTrace();
                resultMap.put("result", result);
            }
            catch (Throwable throwable) {
                resultMap.put("result", result);
                throw throwable;
            }
        }
        return resultMap;
    }

    @ResponseBody
    @RequestMapping(value={"/creatBdcZm"})
    public HashMap<String, Object> creatBdcZm(Model model, String zmlx) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> saveMap = new HashMap<String, Object>();
        String zmid = UUIDGenerator.generate18();
        String zmslr = SessionUtil.getCurrentUser().getUsername();
        Date date = new Date();
        saveMap.put("date", date);
        saveMap.put("zmid", zmid);
        saveMap.put("zmslr", zmslr);
        saveMap.put("zmlx", zmlx);
        resultMap.put("zmid", zmid);
        this.bdcZmMapper.creatZm(saveMap);
        return resultMap;
    }

    @ResponseBody
    @RequestMapping(value={"/getZmPagesJson"})
    public Object getLpbPagesJson(Pageable pageable, String zmid, String zmlx, String zmslr, String zmsqr, String zmqsrq, String zmjsrq) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("zmid", zmid);
            map.put("zmlx", zmlx);
            map.put("zmslr", zmslr);
            map.put("zmsqr", zmsqr);
            if (StringUtils.isNotBlank((CharSequence)zmjsrq)) {
                map.put("zmjsrq", new SimpleDateFormat("yyyy-MM-dd").parse(zmjsrq));
            }
            if (StringUtils.isNotBlank((CharSequence)zmqsrq)) {
                map.put("zmqsrq", new SimpleDateFormat("yyyy-MM-dd").parse(zmqsrq));
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Page dataPaging = this.repository.selectPaging("getZmListByPage", map, pageable);
        return dataPaging;
    }
}

