/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.web.main;

import cn.gtmap.estateplat.core.support.xml.XmlUtils;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.server.core.service.BdcSjdService;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.model.FoldersModel;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import cn.gtmap.estateplat.server.web.main.BaseController;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/createSjdcl"})
public class CreateSjdclController
extends BaseController {
    private static final long serialVersionUID = -2676839172755812066L;
    @Autowired
    PlatformUtil platformUtil;
    @Autowired
    BdcSjdService bdcSjdService;
    @Autowired
    BdcXmService bdcXmService;

    @RequestMapping(value={"/createAllFileFolder"}, method={RequestMethod.GET})
    public String createAllFileFolder(Model model, @RequestParam(value="proid", required=false) String proid, @RequestParam(value="clmc", required=false) String clmc, @RequestParam(value="wiid", required=false) String wiid) {
        String fileCenterUrl = "fcm";
        Integer project_fileId = null;
        if (this.fileCenterUrl != null && this.fileCenterUrl.length() > 4) {
            fileCenterUrl = fileCenterUrl + this.fileCenterUrl.substring(4);
        }
        try {
            if (proid != null && !proid.equals("")) {
                List bdcSjclList;
                project_fileId = this.platformUtil.getProjectFileId(proid);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)wiid)) {
                    BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
                    wiid = bdcXm.getWiid();
                }
                if ((bdcSjclList = this.bdcSjdService.getSjclListByWiid(wiid, proid)) != null && bdcSjclList.size() > 0) {
                    for (BdcSjcl bdcSjcl1 : bdcSjclList) {
                        if (!org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{bdcSjcl1.getClmc()})) continue;
                        this.platformUtil.createFileFolderByclmc(project_fileId, bdcSjcl1.getClmc());
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{clmc})) {
                    clmc = URLDecoder.decode(clmc, "UTF-8");
                    project_fileId = this.platformUtil.createFileFolderByclmc(project_fileId, clmc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("fileCenterUrl", (Object)fileCenterUrl);
        model.addAttribute("nodeId", (Object)project_fileId);
        return "main/sjd";
    }

    @RequestMapping(value={"/saveSjclFs"}, method={RequestMethod.POST})
    @ResponseBody
    public String saveSjclFs(@RequestParam(value="proid", required=false) String proid, @RequestParam(value="wiid", required=false) String wiid) {
        String msg = "ok";
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)proid)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)wiid)) {
                BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
                wiid = bdcXm.getWiid();
            }
            List bdcSjclList = this.bdcSjdService.getSjclListByWiid(wiid, proid);
            Integer project_fileId = this.platformUtil.getProjectFileId(proid);
            if (bdcSjclList != null && bdcSjclList.size() > 0) {
                for (BdcSjcl bdcSjcl1 : bdcSjclList) {
                    if (!org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{bdcSjcl1.getClmc()})) continue;
                    bdcSjcl1.setFs(this.platformUtil.getAllChildFilesCountByNodeName(project_fileId, bdcSjcl1.getClmc()));
                    this.bdcSjdService.saveSjcl(bdcSjcl1);
                }
            }
        }
        return msg;
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public String deleteFile(@RequestParam(value="proid", required=false) String proid, @RequestParam(value="clmc", required=false) String clmc) {
        String msg = "ok";
        this.platformUtil.deleteFileByProidAndClmc(proid, clmc);
        return msg;
    }

    @ResponseBody
    @RequestMapping(value={"/uploadSjcl"})
    public String gdFile(HttpServletRequest request) {
        String result = "0";
        String xml = "";
        try {
            if (request.getInputStream() != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                if (sb != null) {
                    xml = URLDecoder.decode(sb.toString(), "UTF-8");
                }
            }
            if (StringUtils.isNotBlank((String)xml)) {
                System.out.println("\u63a5\u53d7\u6750\u6599xml:" + xml);
                XmlUtils xmlUtils = new XmlUtils(new Class[]{FoldersModel.class});
                FoldersModel foldersModel = (FoldersModel)xmlUtils.fromXml(xml, false);
                if (foldersModel != null) {
                    this.bdcSjdService.updateSjclsFiles(foldersModel);
                }
                result = "1";
                System.out.println("\u63a5\u6536\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            result = "0";
            e.printStackTrace();
            System.out.println("\u63a5\u6536\u5931\u8d25\uff01");
        }
        return result;
    }
}

