/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.web.main;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.DjsjFwHs;
import cn.gtmap.estateplat.model.server.print.XmlData;
import cn.gtmap.estateplat.server.core.mapper.BdcXmMapper;
import cn.gtmap.estateplat.server.core.mapper.DjsjFwMapper;
import cn.gtmap.estateplat.server.core.service.BdcXmService;
import cn.gtmap.estateplat.server.core.service.BdcZsService;
import cn.gtmap.estateplat.server.core.service.PrintService;
import cn.gtmap.estateplat.server.core.utils.GetQRcode;
import cn.gtmap.estateplat.server.web.main.BaseController;
import cn.gtmap.estateplat.utils.CalendarUtil;
import com.google.common.collect.Maps;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/bdcPrint"})
public class BdcPrintController
extends BaseController {
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcXmMapper bdcXmMapper;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private PrintService printService;
    @Autowired
    private DjsjFwMapper djsjFwMapper;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;

    @RequestMapping(value={"/printBdcqz"})
    public void printBdcqz(String proid, String zsid, String isMul, String zslx, String hiddeMode, HttpServletResponse response, String wiid, @RequestParam(value="startNum") String start, @RequestParam(value="endNum") String end) throws IOException {
        String modalUrls = "";
        String xmlUrls = "";
        int startNum = Integer.parseInt(start);
        int endNum = Integer.parseInt(end);
        if (StringUtils.isNotBlank((CharSequence)zslx)) {
            String zslxTemp = URLDecoder.decode(zslx, "UTF-8");
            if (StringUtils.equals((CharSequence)"\u4e0d\u52a8\u4ea7\u6743", (CharSequence)zslxTemp)) {
                zslx = "zs";
            } else if (StringUtils.equals((CharSequence)"\u4e0d\u52a8\u4ea7\u8bc1\u660e", (CharSequence)zslxTemp)) {
                zslx = "zms";
            }
        }
        if (StringUtils.equals((CharSequence)zslx, (CharSequence)"zs")) {
            modalUrls = "C:/GTIS/zsPrint.fr3";
        } else if (StringUtils.equals((CharSequence)zslx, (CharSequence)"zms")) {
            modalUrls = "C:/GTIS/zmsPrint.fr3";
        } else if (StringUtils.equals((CharSequence)zslx, (CharSequence)"zmd")) {
            modalUrls = "C:/GTIS/zmdPrintWw.fr3";
        }
        if (StringUtils.isNotBlank((CharSequence)wiid)) {
            xmlUrls = this.bdcdjUrl + "/bdcPrint/getBatchBdcqzXml?wiid=" + wiid + "&amp;zsid=" + zsid + "&amp;zslx=" + zslx + "&amp;startNum=" + startNum + "&amp;endNum=" + endNum;
        } else if (StringUtils.isNotBlank((CharSequence)proid)) {
            xmlUrls = this.bdcdjUrl + "/bdcPrint/getBdcqzXml?proid=" + proid + "&amp;zsid=" + zsid + "&amp;zslx=" + zslx + "&amp;isMul=" + isMul;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modalUrls})) {
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
            sb.append("<frs>");
            if (StringUtils.indexOf((CharSequence)modalUrls, (CharSequence)",") > -1) {
                String[] modalUrlList = modalUrls.split(",");
                String[] xmlUrlsList = xmlUrls.split(",");
                for (int i = 0; i < modalUrlList.length; ++i) {
                    sb.append("<fr url=\"eprt://v2|designMode=false|frURL=" + modalUrlList[i] + "|dataURL=" + xmlUrlsList[i] + "|updateUrl=http://oa.gtis.com.cn:80/platform/pluging/update.ini|hiddeMode=" + hiddeMode + "\"/>");
                }
            } else {
                sb.append("<fr url=\"eprt://v2|designMode=false|frURL=" + modalUrls + "|dataURL=" + xmlUrls + "|updateUrl=http://oa.gtis.com.cn:80/platform/pluging/update.ini|hiddeMode=" + hiddeMode + "\"/>");
            }
            sb.append("</frs>");
            response.setContentType("text/xml;charset=utf-8");
            System.out.println(sb.toString());
            PrintWriter out = response.getWriter();
            out.write(sb.toString());
            out.flush();
            out.close();
        }
    }

    @RequestMapping(value={"/getBdcqzXml"})
    public void getBdcqzXml(String proid, String zsid, String zslx, String isMul, HttpServletResponse response, HttpServletRequest request) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<fetchdatas>");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("proid", proid);
        List zsList = new ArrayList();
        StringBuffer resultXML = new StringBuffer();
        zsList = this.bdcZsService.getBdczsList(param);
        BdcXm bdcXm = this.bdcXmService.getBdcXmByProid(proid);
        List fwHsList = new ArrayList();
        fwHsList = this.djsjFwMapper.getDjsjFwHsByProid(param);
        String fwbm = "";
        if (CollectionUtils.isNotEmpty(fwHsList) && StringUtils.isNotBlank((CharSequence)((DjsjFwHs)fwHsList.get(0)).getFwbm())) {
            fwbm = ((DjsjFwHs)fwHsList.get(0)).getFwbm();
        }
        String qlr = "";
        HashMap zsMap = new HashMap();
        if (bdcXm != null) {
            int i;
            if (StringUtils.isNotBlank((CharSequence)bdcXm.getSqfbcz()) && "\u662f".equals(bdcXm.getSqfbcz())) {
                for (i = 0; i < zsList.size(); ++i) {
                    zsMap = (HashMap)zsList.get(i);
                    zsMap.put("SQFBCZ", bdcXm.getSqfbcz());
                    resultXML = this.printService.getZsPrintXml(bdcXm.getProid(), sb, zsMap, zslx, this.bdcdjUrl, request, zsid, isMul);
                    sb.append(resultXML);
                }
            } else {
                if (CollectionUtils.isNotEmpty(zsList)) {
                    for (i = 0; i < zsList.size(); ++i) {
                        HashMap zsMapTemp = (HashMap)zsList.get(i);
                        String qlrmc = (String)zsMapTemp.get("QLR");
                        qlr = StringUtils.isNotBlank((CharSequence)qlrmc) ? qlr.concat(qlrmc).concat(" ") : qlrmc;
                    }
                    zsMap = (HashMap)zsList.get(0);
                    zsMap.put("QLR", qlr);
                    zsMap.put("FWBM", fwbm);
                    resultXML = this.printService.getZsPrintXml(bdcXm.getProid(), sb, zsMap, zslx, this.bdcdjUrl, request, zsid, isMul);
                }
                sb.append(resultXML);
            }
        }
        sb.append("</fetchdatas>");
        response.setContentType("text/xml;charset=utf-8");
        PrintWriter out = response.getWriter();
        this.logger.debug((Object)sb.toString());
        out.write(sb.toString());
        out.flush();
        out.close();
    }

    private String getSqlxdm(String proid, String wiid) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo;
        BdcXm bdcXm;
        String sqlxdm = "";
        String wiidTemp = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{wiid})) {
            wiidTemp = wiid;
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proid}) && (bdcXm = this.bdcXmService.getBdcXmByProid(proid)) != null) {
            wiidTemp = bdcXm.getWiid();
        }
        if (StringUtils.isNotBlank((CharSequence)wiidTemp) && (pfWorkFlowInstanceVo = this.sysWorkFlowInstanceService.getWorkflowInstance(wiidTemp)) != null && StringUtils.isNotBlank((CharSequence)pfWorkFlowInstanceVo.getWorkflowDefinitionId())) {
            sqlxdm = this.bdcZdGlService.getBdcSqlxdmByWdid(pfWorkFlowInstanceVo.getWorkflowDefinitionId());
        }
        return sqlxdm;
    }

    @RequestMapping(value={"/getBatchBdcqzXml"})
    public void getBatchBdcqzXml(String zslx, String wiid, String startNum, String endNum, HttpServletResponse response, HttpServletRequest request) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<fetchdatas>");
        StringBuffer resultXML = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)wiid)) {
            List bdcXmList;
            HashMap params = Maps.newHashMap();
            params.put("wiid", wiid);
            params.put("firstSortParam", "bdcdyh");
            params.put("startNum", startNum);
            params.put("endNum", endNum);
            if (StringUtils.equals((CharSequence)this.getSqlxdm("", wiid), (CharSequence)"10170")) {
                params.put("displaySC", "true");
            }
            if (CollectionUtils.isNotEmpty((Collection)(bdcXmList = this.bdcXmMapper.getBdcXmListByWiidSort((Map)params)))) {
                HashMap<String, String> param = new HashMap<String, String>();
                for (BdcXm bdcXm : bdcXmList) {
                    param.put("proid", bdcXm.getProid());
                    List zsList = new ArrayList();
                    this.updateFzrq(bdcXm.getProid());
                    if (StringUtils.isNotBlank((CharSequence)zslx) && (zslx.equals("zs") || StringUtils.equals((CharSequence)zslx, (CharSequence)"zmd"))) {
                        zsList = this.bdcZsService.getBdczsList(param);
                    } else if (!StringUtils.isNotBlank((CharSequence)zslx) || zslx.equals("zms")) {
                        // empty if block
                    }
                    String qlr = "";
                    if (bdcXm == null) continue;
                    if (CollectionUtils.isNotEmpty(zsList)) {
                        for (int j = 0; j < zsList.size(); ++j) {
                            HashMap zsMapTemp = (HashMap)zsList.get(j);
                            String qlrmc = (String)zsMapTemp.get("QLR");
                            qlr = StringUtils.isNotBlank((CharSequence)qlrmc) ? qlr.concat(qlrmc).concat(" ") : qlrmc;
                        }
                        HashMap zsMap = (HashMap)zsList.get(0);
                        zsMap.put("QLR", qlr);
                        resultXML = this.printService.getZsPrintXml(bdcXm.getProid(), sb, zsMap, zslx, this.bdcdjUrl, request, null, null);
                    }
                    sb.append(resultXML);
                }
            }
        }
        sb.append("</fetchdatas>");
        response.setContentType("text/xml;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.write(sb.toString());
        this.logger.error((Object)sb.toString());
        out.flush();
        out.close();
    }

    public XmlData zzData(String name, String type, String value) {
        XmlData xmlData = new XmlData();
        xmlData.setName(name);
        xmlData.setType(type);
        xmlData.setValue(value);
        return xmlData;
    }

    @RequestMapping(value={"/getewm"})
    public void getEwmStream(@RequestParam(value="proid", required=false) String proid, @RequestParam(value="bz", required=false) String bz, HttpServletResponse response) {
        BdcXm bdcXm;
        String content = "";
        if (StringUtils.isNotBlank((CharSequence)URLDecoder.decode(bz))) {
            content = URLDecoder.decode(bz);
        } else if (StringUtils.isNotBlank((CharSequence)proid) && (bdcXm = this.bdcXmService.getBdcXmByProid(proid)) != null) {
            content = bdcXm.getBh();
        }
        response.setContentType("image/jpg;charset=utf-8");
        response.addHeader("Content-Disposition", "attachment; filename=test.jpg");
        GetQRcode.encoderQRCode((String)content, null, (HttpServletResponse)response);
    }

    @RequestMapping(value={"updateFzrq"})
    public void updateFzrq(String proid) {
        List bdcZsList = this.bdcZsService.queryBdcZsByProid(proid);
        if (CollectionUtils.isNotEmpty((Collection)bdcZsList)) {
            for (BdcZs bdcZs : bdcZsList) {
                if (bdcZs.getFzrq() != null) continue;
                bdcZs.setFzrq(CalendarUtil.getCurDate());
                this.entityMapper.saveOrUpdate((Object)bdcZs, (Object)bdcZs.getZsid());
            }
        }
    }
}

