/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.web.main;

import cn.gtmap.estateplat.core.i18n.NLS;
import cn.gtmap.estateplat.server.core.service.BdcZdGlService;
import cn.gtmap.estateplat.server.utils.PlatformUtil;
import cn.gtmap.estateplat.utils.ExUtils;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfPartitionInfoVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.spring.Container;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public abstract class BaseController {
    public static final String RET = "ret";
    public static final String MSG = "msg";
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected String platformUrl;
    protected String fcxtUrl;
    protected String bdcdjUrl;
    protected String archiveUrl;
    protected String etlUrl;
    protected String ompUrl;
    protected String fileCenterUrl;
    protected String reportUrl;
    protected String portalUrl;
    protected String sysVersion;
    protected String sflw;
    protected String analysisUrl;
    @Autowired
    protected SysUserService sysUserService;
    @Autowired
    protected BdcZdGlService bdcZdGlService;

    protected static void success(RedirectAttributes ra, String msg) {
        ra.addFlashAttribute(RET, (Object)true);
        ra.addFlashAttribute(MSG, (Object)msg);
    }

    protected static void success(RedirectAttributes ra) {
        ra.addFlashAttribute(RET, (Object)true);
    }

    protected static void fail(Model model, String msg) {
        model.addAttribute(RET, (Object)false);
        model.addAttribute(MSG, (Object)msg);
    }

    protected static void fail(Model model, Exception ex) {
        model.addAttribute(RET, (Object)false);
        model.addAttribute(MSG, (Object)ex.getMessage());
    }

    protected static void fail(Model model) {
        model.addAttribute(RET, (Object)false);
    }

    protected static Map<String, Object> success() {
        return Collections.singletonMap(RET, true);
    }

    protected static Map<String, Object> fail(String message) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put(RET, false);
        map.put(MSG, message);
        return map;
    }

    protected static Map<String, Object> fail(Exception ex) {
        return ExUtils.toMap((Exception)ex);
    }

    @ModelAttribute
    public void setReqAndRes(HttpServletRequest request, HttpServletResponse response) {
        this.platformUrl = AppConfig.getPlatFormUrl();
        this.fcxtUrl = AppConfig.getProperty((String)"fcxt.url");
        this.bdcdjUrl = AppConfig.getProperty((String)"bdcdj.url");
        this.etlUrl = AppConfig.getProperty((String)"etl.url");
        this.archiveUrl = AppConfig.getProperty((String)"archive.url");
        this.fileCenterUrl = AppConfig.getFileCenterUrl();
        this.ompUrl = AppConfig.getProperty((String)"omp.url");
        this.reportUrl = AppConfig.getProperty((String)"report.url");
        this.portalUrl = AppConfig.getProperty((String)"portal.url");
        this.sysVersion = AppConfig.getProperty((String)"sys.version");
        this.sflw = AppConfig.getProperty((String)"sflw");
        this.analysisUrl = AppConfig.getProperty((String)"analysis.url");
        request.setAttribute("archiveUrl", (Object)this.archiveUrl);
        request.setAttribute("ompUrl", (Object)this.ompUrl);
        request.setAttribute("reportUrl", (Object)this.reportUrl);
        request.setAttribute("portalUrl", (Object)this.portalUrl);
        request.setAttribute("sysVersion", (Object)this.sysVersion);
        request.setAttribute("fileCenterUrl", (Object)this.fileCenterUrl);
        request.setAttribute("platformUrl", (Object)this.platformUrl);
        request.setAttribute("bdcdjUrl", (Object)this.bdcdjUrl);
        request.setAttribute("fcxtUrl", (Object)this.fcxtUrl);
        request.setAttribute("etlUrl", (Object)this.etlUrl);
        request.setAttribute("sflw", (Object)this.sflw);
        request.setAttribute("analysisUrl", (Object)this.analysisUrl);
        String methodPath = request.getServletPath();
    }

    protected final String getMsg(String key) {
        return NLS.get((String)key);
    }

    protected final String getMsg(String key, Object ... args) {
        return NLS.get((String)key, (Object[])args);
    }

    protected final List<PfUserVo> getUserListByOrgan(String organName) {
        return this.sysUserService.getUsersByOrganName(organName);
    }

    protected final String getUserNameById(String id) {
        PfUserVo userVo = this.sysUserService.getUserVo(id);
        if (userVo != null) {
            return userVo.getUserName();
        }
        return "";
    }

    protected final String getDeptNameById(String id) {
        PfOrganVo organVo = this.sysUserService.getOrganVo(id);
        if (organVo != null) {
            return organVo.getOrganName();
        }
        return "";
    }

    protected final String getUserId() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            return userInfo.getId();
        }
        return null;
    }

    protected final String getUserName() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            return userInfo.getUsername();
        }
        return null;
    }

    protected final List<PfOrganVo> getOrganName() {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        return userInfo.getLstOragn();
    }

    protected final String getUserDptId() {
        if (this.getOrganName().size() == 0) {
            return null;
        }
        return ((PfOrganVo)this.getOrganName().get(0)).getOrganId();
    }

    protected final PfWorkFlowInstanceVo getWorkFlowInstance(String proid) {
        SysWorkFlowInstanceService workFlowDAO = (SysWorkFlowInstanceService)Container.getBean((String)"SysWorkFlowInstanceService");
        return workFlowDAO.getWorkflowInstanceByProId(proid);
    }

    protected String getActivityName(String taskid) {
        SysTaskService sysTaskService = (SysTaskService)Container.getBean((String)"TaskService");
        PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
        PfActivityVo pfActivityVo = sysTaskService.getActivity(pfTaskVo.getActivityId());
        return pfActivityVo.getActivityName();
    }

    protected final SysUserService getUserDAO() {
        return (SysUserService)Container.getBean((String)"SysUserServiceImpl");
    }

    protected final List getAllUsers() {
        return this.getUserDAO().getAllUsers();
    }

    protected final List<String> getAllUserName() {
        ArrayList<String> list = new ArrayList<String>();
        List users = this.getAllUsers();
        for (PfUserVo vo : users) {
            if (vo == null) continue;
            list.add(vo.getUserName());
        }
        return list;
    }

    protected final String getUserIdByUserName(String userName) {
        String userId = "";
        if (StringUtils.isBlank((CharSequence)userName)) {
            return userId;
        }
        List users = this.getAllUsers();
        for (PfUserVo vo : users) {
            if (vo == null || !userName.equals(vo.getUserName())) continue;
            userId = vo.getUserId();
        }
        return userId;
    }

    protected final String getUserNo(String userName) {
        String userNo = "";
        PfUserVo pfUserVo = this.sysUserService.getUserVo(this.getUserIdByUserName(userName));
        if (pfUserVo != null) {
            userNo = pfUserVo.getUserNo();
        }
        return userNo;
    }

    protected final List<PfOrganVo> getDptList() {
        return this.getUserDAO().getOrganList();
    }

    protected final List<String> getUnitList() {
        ArrayList<String> list = new ArrayList<String>();
        for (PfOrganVo vo : this.getDptList()) {
            list.add(vo.getOrganName());
        }
        return list;
    }

    protected final List<PfUserVo> getUserListByOrganId(String organId) {
        return this.getUserDAO().getUserListByOragn(organId);
    }

    protected final List<String> getUserNameListByOrgan(String organId) {
        ArrayList<String> list = new ArrayList<String>();
        for (PfUserVo vo : this.getUserListByOrganId(organId)) {
            String bb = vo.getUserName();
            list.add(vo.getUserName());
        }
        return list;
    }

    protected final Map getUnitUserMap() {
        HashMap<String, List> map = new HashMap<String, List>();
        List units = this.getDptList();
        for (PfOrganVo vo : units) {
            String name = vo.getOrganName();
            List users = this.getUserNameListByOrgan(vo.getOrganId());
            map.put(name, users);
        }
        return map;
    }

    protected final Map getUnitAndUserMap() {
        HashMap map = new HashMap();
        List units = this.getDptList();
        Iterator i = units.iterator();
        while (i.hasNext()) {
            PfOrganVo vo = (PfOrganVo)i.next();
            String organName = vo.getOrganName();
            String organId = vo.getOrganId();
            HashMap<String, String> organMap = new HashMap<String, String>();
            organMap.put(organId, organName);
            List users = this.getUserListByOrganId(organId);
            Iterator ite = users.iterator();
            while (i.hasNext()) {
                PfUserVo user = (PfUserVo)ite.next();
                HashMap<String, String> userMap = new HashMap<String, String>();
                String userName = user.getUserName();
                String userId = user.getUserId();
                userMap.put(userName, userId);
                map.put(organMap, userMap);
            }
        }
        return map;
    }

    protected final Map getOrganUserSetMap() {
        HashMap setMap = new HashMap();
        HashMap<String, PfOrganVo> organMap = new HashMap<String, PfOrganVo>();
        HashMap<String, PfUserVo> userMap = new HashMap<String, PfUserVo>();
        HashMap<String, HashMap<String, String>> userIdOrganIdMap = new HashMap<String, HashMap<String, String>>();
        HashMap<String, HashMap<String, String>> organIdUserIdMap = new HashMap<String, HashMap<String, String>>();
        setMap.put("organMap", organMap);
        setMap.put("userMap", userMap);
        setMap.put("userIdOrganIdMap", userIdOrganIdMap);
        setMap.put("organIdUserIdMap", organIdUserIdMap);
        List units = this.getDptList();
        for (PfOrganVo voOrgan : units) {
            String organId = voOrgan.getOrganId();
            organMap.put(organId, voOrgan);
            List users = this.getUserListByOrganId(organId);
            for (int num = 0; num < users.size(); ++num) {
                PfUserVo voUser = (PfUserVo)users.get(num);
                String userId = voUser.getUserId();
                userMap.put(userId, voUser);
                HashMap<String, String> tempUserOrganMap = (HashMap<String, String>)userIdOrganIdMap.get(userId);
                if (tempUserOrganMap == null) {
                    tempUserOrganMap = new HashMap<String, String>();
                    userIdOrganIdMap.put(userId, tempUserOrganMap);
                }
                tempUserOrganMap.put(organId, organId);
                HashMap<String, String> tempOrganUserMap = (HashMap<String, String>)organIdUserIdMap.get(organId);
                if (tempOrganUserMap == null) {
                    tempOrganUserMap = new HashMap<String, String>();
                    organIdUserIdMap.put(organId, tempOrganUserMap);
                }
                tempOrganUserMap.put(userId, userId);
            }
        }
        return setMap;
    }

    protected final List<PfOrganVo> getOrgainList() throws Exception {
        List organList = this.getUserDAO().getAllOrganList();
        return organList;
    }

    protected final PfUserVo getUserVo() {
        String userid = this.getUserId();
        PfUserVo pfUserVo = this.getUserDAO().getUserVo(userid);
        if (pfUserVo == null) {
            pfUserVo = new PfUserVo();
        }
        return pfUserVo;
    }

    protected final List<PfRoleVo> getRoleListByUser(String userId) {
        return this.getUserDAO().getRoleListByUser(userId);
    }

    protected final String getRoleIdsByUser(String userId) {
        List roleVoList = this.getUserDAO().getRoleListByUser(userId);
        String roleIds = "";
        if (roleVoList != null && roleVoList.size() > 0) {
            for (PfRoleVo pfRoleVo : roleVoList) {
                if (StringUtils.isBlank((CharSequence)roleIds)) {
                    roleIds = pfRoleVo.getRoleId();
                    continue;
                }
                roleIds = roleIds + "," + pfRoleVo.getRoleId();
            }
        }
        return roleIds;
    }

    protected final String getDeptIdByDeptName(String deptName) {
        String deptId = "";
        List pfOrganVoList = this.getDptList();
        if (StringUtils.isNotBlank((CharSequence)deptName)) {
            for (PfOrganVo pfOrganVo : pfOrganVoList) {
                if (pfOrganVo == null || !StringUtils.equals((CharSequence)pfOrganVo.getOrganName(), (CharSequence)deptName)) continue;
                deptId = pfOrganVo.getOrganId();
                break;
            }
        }
        return deptId;
    }

    protected final String getUserDptName(String userId) {
        PfOrganVo pfOrganVo;
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        List pfOrganVoList = this.getUserDAO().getOrganListByUser(userId);
        if (pfOrganVoList != null && pfOrganVoList.size() > 0 && (pfOrganVo = (PfOrganVo)pfOrganVoList.get(0)) != null) {
            return pfOrganVo.getOrganName();
        }
        return null;
    }

    protected final String getUserDptId(String userId) {
        PfOrganVo pfOrganVo;
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        List pfOrganVoList = this.getUserDAO().getOrganListByUser(userId);
        if (pfOrganVoList != null && pfOrganVoList.size() > 0 && (pfOrganVo = (PfOrganVo)pfOrganVoList.get(0)) != null) {
            return pfOrganVo.getOrganId();
        }
        return null;
    }

    protected final PfOrganVo getDeptByUserName(String userName) {
        PfOrganVo pfOrganVo = null;
        String userId = "";
        if (StringUtils.isBlank((CharSequence)userName)) {
            return pfOrganVo;
        }
        List users = this.getAllUsers();
        for (PfUserVo vo : users) {
            if (vo == null || !userName.equals(vo.getUserName())) continue;
            userId = vo.getUserId();
        }
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            String deptId = this.getUserDptId(userId);
            String deptName = this.getUserDptName(userId);
            pfOrganVo = new PfOrganVo();
            pfOrganVo.setOrganId(deptId);
            pfOrganVo.setOrganName(deptName);
        }
        return pfOrganVo;
    }

    protected final String checkPlatformAuthor(HttpServletRequest request, String key) {
        String readyTag = "false";
        String userId = this.getUserId();
        String roleIds = this.getRoleIdsByUser(userId);
        String proid = request.getParameter("proid");
        String rid = request.getParameter("rid");
        String taskid = request.getParameter("taskid");
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("proid", request.getParameter("proid"));
        paraMap.put("rid", request.getParameter("rid"));
        paraMap.put("taskid", request.getParameter("taskid"));
        paraMap.put("roles", roleIds);
        String pageEnterType = PlatformUtil.getPageEnterType((String)proid, (String)taskid);
        if (pageEnterType.equals("task")) {
            paraMap.put("from", "task");
            request.setAttribute("from", (Object)"task");
        } else {
            paraMap.put("from", "project");
            request.setAttribute("from", (Object)"project");
        }
        List tempPartionInfoList = PlatformUtil.getAuthorList(paraMap);
        for (int i = 0; i < tempPartionInfoList.size(); ++i) {
            PfPartitionInfoVo tempPfPartitionInfoVo = (PfPartitionInfoVo)tempPartionInfoList.get(i);
            if (tempPfPartitionInfoVo == null) continue;
            String elementId = tempPfPartitionInfoVo.getElementId();
            int operateType = tempPfPartitionInfoVo.getOperateType();
            if (elementId == null) {
                elementId = "";
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)elementId, (CharSequence)key)) continue;
            readyTag = operateType == 0 ? "true" : "false";
        }
        return readyTag;
    }

    protected final String getCurrentUserDwdm() {
        String userDwdm = this.sysUserService.getUserRegionCode(this.getUserId());
        return userDwdm;
    }

    protected final String getWhereXzqdm() {
        String userDwdm = this.getCurrentUserDwdm();
        if (StringUtils.isNotBlank((CharSequence)userDwdm)) {
            while (StringUtils.isNotBlank((CharSequence)userDwdm) && userDwdm.endsWith("0")) {
                userDwdm = userDwdm.substring(0, userDwdm.length() - 1);
            }
        }
        return userDwdm;
    }

    private final void createLog(String methodPath) {
        HashMap map;
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{methodPath}) || (map = this.bdcZdGlService.getZdLogControllerMap()) == null || map.size() <= 0 || map.get(methodPath) != null) {
            // empty if block
        }
    }
}

