/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.estateplat.server.utils;

import com.gtis.plat.wf.model.ActivityModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class WorkFlowXml
implements Serializable {
    private static final long serialVersionUID = -5905728708914724839L;
    private static final Log log = LogFactory.getLog(WorkFlowXml.class);
    private String instanceXml;
    private Document doc;
    private Date modifyDate;

    public WorkFlowXml(String xml) {
        this.setInstanceXml(xml);
    }

    public String getBeginActivityDefine() {
        Node tmpNode;
        if (this.doc != null && (tmpNode = this.doc.selectSingleNode("//WorkflowProcess/ExtendedAttributes/ExtendedAttribute[@Name='PROCESS_BEGIN_ACTIVITYID']")) != null) {
            return tmpNode.valueOf("@Value");
        }
        return null;
    }

    public String getEndActivityDefine() {
        Node tmpNode;
        if (this.doc != null && (tmpNode = this.doc.selectSingleNode("//WorkflowProcess/ExtendedAttributes/ExtendedAttribute[@Name='PROCESS_END_ACTIVITYID']")) != null) {
            return tmpNode.valueOf("@Value");
        }
        return null;
    }

    public ActivityModel getActivity(String activityId) {
        Node tmpNode;
        if (this.doc != null && (tmpNode = this.doc.selectSingleNode("//Activities/Activity[@Id='" + activityId + "']")) != null) {
            return new ActivityModel(tmpNode);
        }
        return null;
    }

    public List<ActivityModel> getActivityList() {
        List activityNodeList;
        ArrayList<ActivityModel> activityList = new ArrayList<ActivityModel>();
        if (this.doc != null && (activityNodeList = this.doc.selectNodes("//Activities/Activity")) != null && !activityNodeList.isEmpty()) {
            for (Node actNode : activityNodeList) {
                activityList.add(new ActivityModel(actNode));
            }
        }
        return activityList;
    }

    public String CooperRootId(String activityId) {
        Node tmpNode;
        if (this.doc != null && (tmpNode = this.doc.selectSingleNode("//Activities/Activity[@Id='" + activityId + "']/ExtendedAttributes/ExtendedAttribute[@Name='COOPERROOTID']")) != null) {
            return tmpNode.valueOf("@Value");
        }
        return "";
    }

    public int getActivitiesCount() {
        if (this.doc != null) {
            List lstNodes = this.doc.selectNodes("//Activities/Activity");
            return lstNodes.size();
        }
        return 0;
    }

    public List<String> getToActivitys(String activityId) {
        ArrayList<String> lstActivitys = new ArrayList<String>();
        List lstNodes = this.doc.selectNodes("//Transition[@To='" + activityId + "']");
        for (Node tmpNode : lstNodes) {
            lstActivitys.add(tmpNode.valueOf("@From"));
        }
        return lstActivitys;
    }

    public List<String[]> getTransitionList() {
        Vector<String[]> transitionsList = new Vector<String[]>();
        List lstNodes = this.doc.selectNodes("//Transitions/Transition");
        for (Node tmpNode : lstNodes) {
            String[] activityArray = new String[]{tmpNode.valueOf("@Id"), tmpNode.valueOf("@From"), tmpNode.valueOf("@To")};
            transitionsList.add(activityArray);
        }
        return transitionsList;
    }

    public String getInstanceXml() {
        return this.instanceXml;
    }

    public void setInstanceXml(String xml) {
        this.instanceXml = xml;
        if (this.instanceXml != null && !this.instanceXml.equals("")) {
            try {
                this.doc = DocumentHelper.parseText((String)this.instanceXml);
            }
            catch (Exception e) {
                log.error((Object)"---\u89e3\u6790\u5de5\u4f5c\u6d41XML\u5931\u8d25---");
                e.printStackTrace();
            }
        }
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getExtendedAttribute(String aName) {
        Node tmpNode = this.doc.selectSingleNode("//WorkflowProcess/ExtendedAttributes/ExtendedAttribute[@Name='" + aName + "']");
        if (tmpNode != null) {
            return tmpNode.valueOf("@Value");
        }
        return "";
    }

    public boolean isDisable() {
        return !"false".equals(this.getExtendedAttribute("disable"));
    }
}

